/*
 * Decompiled with CFR 0.152.
 */
package ccchunkloader.niko.ink;

import ccchunkloader.niko.ink.ChunkLoaderPeripheral;
import ccchunkloader.niko.ink.ChunkLoaderRegistry;
import ccchunkloader.niko.ink.ChunkManager;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.AbstractTurtleUpgrade;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkLoaderUpgrade
extends AbstractTurtleUpgrade {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChunkLoaderUpgrade.class);
    private static final String TURTLE_UUID_KEY = "TurtleUUID";

    public ChunkLoaderUpgrade(class_2960 id, class_1799 stack) {
        super(id, TurtleUpgradeType.PERIPHERAL, stack);
    }

    public IPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        UUID turtleId = ChunkLoaderUpgrade.getTurtleUUID(turtle, side);
        class_1937 class_19372 = turtle.getLevel();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            this.cleanupOldTurtleUUIDs(turtle, side, turtleId, serverWorld);
        }
        ChunkLoaderPeripheral peripheral = new ChunkLoaderPeripheral(turtle, side);
        LOGGER.debug("Peripheral created for turtle {} - will restore from upgrade NBT", (Object)turtleId);
        return peripheral;
    }

    private void cleanupOldTurtleUUIDs(ITurtleAccess turtle, TurtleSide side, UUID currentUUID, class_3218 serverWorld) {
        try {
            ITurtleUpgrade rightUpgrade;
            class_2586 blockEntity = serverWorld.method_8321(turtle.getPosition());
            if (!(blockEntity instanceof TurtleBlockEntity)) {
                LOGGER.warn("Cannot cleanup UUIDs - block entity is not a TurtleBlockEntity");
                return;
            }
            TurtleBlockEntity turtleEntity = (TurtleBlockEntity)blockEntity;
            ServerComputer computer = turtleEntity.getServerComputer();
            if (computer == null) {
                LOGGER.debug("Cannot cleanup UUIDs - no ServerComputer instance (computer not ready yet)");
                return;
            }
            int computerId = computer.getID();
            ChunkManager chunkManager = ChunkManager.get(serverWorld);
            Set<UUID> storedUUIDs = chunkManager.getUUIDsForComputer(computerId);
            HashSet<UUID> currentlyEquippedUUIDs = new HashSet<UUID>();
            ITurtleUpgrade leftUpgrade = turtleEntity.getUpgrade(TurtleSide.LEFT);
            if (leftUpgrade instanceof ChunkLoaderUpgrade) {
                UUID leftUUID = ChunkLoaderUpgrade.getTurtleUUID(turtle, TurtleSide.LEFT);
                currentlyEquippedUUIDs.add(leftUUID);
            }
            if ((rightUpgrade = turtleEntity.getUpgrade(TurtleSide.RIGHT)) instanceof ChunkLoaderUpgrade) {
                UUID rightUUID = ChunkLoaderUpgrade.getTurtleUUID(turtle, TurtleSide.RIGHT);
                currentlyEquippedUUIDs.add(rightUUID);
            }
            LOGGER.info("Computer {} cleanup: stored UUIDs={}, currently equipped={}", new Object[]{computerId, storedUUIDs.size(), currentlyEquippedUUIDs.size()});
            HashSet<UUID> toRemove = new HashSet<UUID>(storedUUIDs);
            toRemove.removeAll(currentlyEquippedUUIDs);
            for (UUID orphanedUUID : toRemove) {
                if (orphanedUUID.equals(currentUUID)) continue;
                LOGGER.info("Computer {} cleanup: removing orphaned UUID {} (no longer equipped)", (Object)computerId, (Object)orphanedUUID);
                ChunkManager.permanentlyRemoveTurtleFromWorld(serverWorld, orphanedUUID);
                ChunkLoaderRegistry.permanentlyRemoveTurtle(orphanedUUID);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to cleanup UUIDs for turtle {}: {}", (Object)currentUUID, (Object)e.getMessage());
        }
    }

    public void update(ITurtleAccess turtle, TurtleSide side) {
        if (!(turtle.getLevel() instanceof class_3218)) {
            return;
        }
        IPeripheral peripheral = turtle.getPeripheral(side);
        if (peripheral instanceof ChunkLoaderPeripheral) {
            ChunkLoaderPeripheral chunkLoaderPeripheral = (ChunkLoaderPeripheral)peripheral;
            chunkLoaderPeripheral.updateChunkLoading();
        }
    }

    public static UUID getTurtleUUID(ITurtleAccess turtle, TurtleSide side) {
        UUID uuid;
        class_2487 upgradeData = turtle.getUpgradeNBTData(side);
        if (upgradeData.method_25928(TURTLE_UUID_KEY)) {
            uuid = upgradeData.method_25926(TURTLE_UUID_KEY);
            LOGGER.debug("Retrieved existing UUID from upgrade NBT: {}", (Object)uuid);
        } else {
            uuid = UUID.randomUUID();
            upgradeData.method_25927(TURTLE_UUID_KEY, uuid);
            turtle.updateUpgradeNBTData(side);
            LOGGER.info("Generated new UUID and saved to upgrade NBT: {}", (Object)uuid);
        }
        return uuid;
    }

    public static void setTurtleUUID(ITurtleAccess turtle, TurtleSide side, UUID uuid) {
        class_2487 upgradeData = turtle.getUpgradeNBTData(side);
        upgradeData.method_25927(TURTLE_UUID_KEY, uuid);
        turtle.updateUpgradeNBTData(side);
        LOGGER.info("Set UUID in upgrade NBT: {}", (Object)uuid);
    }

    public class_2487 getPersistedData(class_2487 data) {
        class_2487 persistedData = data.method_10553();
        if (data.method_25928(TURTLE_UUID_KEY)) {
            LOGGER.debug("Persisting turtle UUID to item NBT: {}", (Object)data.method_25926(TURTLE_UUID_KEY));
        }
        return persistedData;
    }
}

