/*
 * Decompiled with CFR 0.152.
 */
package ccchunkloader.niko.ink;

import ccchunkloader.niko.ink.ChunkLoaderPeripheral;
import ccchunkloader.niko.ink.ChunkManager;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_3218;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkLoaderRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChunkLoaderRegistry.class);
    private static final Map<UUID, ChunkLoaderPeripheral> ACTIVE_PERIPHERALS = new ConcurrentHashMap<UUID, ChunkLoaderPeripheral>();

    public static void register(UUID turtleId, ChunkLoaderPeripheral peripheral) {
        ACTIVE_PERIPHERALS.put(turtleId, peripheral);
        LOGGER.debug("Registered active turtle chunk loader: {}", (Object)turtleId);
    }

    public static void unregister(UUID turtleId) {
        ChunkLoaderPeripheral removed = ACTIVE_PERIPHERALS.remove(turtleId);
        if (removed != null) {
            LOGGER.debug("Unregistered turtle chunk loader: {}", (Object)turtleId);
        }
    }

    public static ChunkLoaderPeripheral getPeripheral(UUID turtleId) {
        return ACTIVE_PERIPHERALS.get(turtleId);
    }

    public static boolean isActive(UUID turtleId) {
        return ACTIVE_PERIPHERALS.containsKey(turtleId);
    }

    public static Map<UUID, ChunkLoaderPeripheral> getAllPeripherals() {
        return Map.copyOf(ACTIVE_PERIPHERALS);
    }

    public static boolean canBootstrap(UUID turtleId, class_3218 world) {
        if (world != null) {
            ChunkManager manager = ChunkManager.get(world);
            return manager.getCachedTurtleState(turtleId) != null;
        }
        return false;
    }

    public static String getTurtleDiagnostic(UUID turtleId, class_3218 world) {
        boolean isActive = ChunkLoaderRegistry.isActive(turtleId);
        boolean hasCache = world != null ? ChunkManager.get(world).getCachedTurtleState(turtleId) != null : false;
        return String.format("Turtle %s: active=%s, cached=%s", turtleId, isActive, hasCache);
    }

    public static void permanentlyRemoveTurtle(UUID turtleId) {
        LOGGER.info("PERMANENTLY removing turtle {} from registry", (Object)turtleId);
        ChunkLoaderPeripheral removed = ACTIVE_PERIPHERALS.remove(turtleId);
        if (removed != null) {
            LOGGER.info("Removed active peripheral for turtle {}", (Object)turtleId);
        }
    }

    public static void clearAll() {
        int activeCount = ACTIVE_PERIPHERALS.size();
        ACTIVE_PERIPHERALS.clear();
        if (activeCount > 0) {
            LOGGER.info("Cleared {} active turtle records", (Object)activeCount);
        }
    }

    public static void removePeripherals(Set<UUID> turtleIds) {
        int removed = 0;
        for (UUID turtleId : turtleIds) {
            if (ACTIVE_PERIPHERALS.remove(turtleId) == null) continue;
            ++removed;
        }
        if (removed > 0) {
            LOGGER.debug("Clean slate: removed {} peripherals from unloaded chunks", (Object)removed);
        }
    }
}

