/*
 * Decompiled with CFR 0.152.
 */
package ccchunkloader.niko.ink;

import ccchunkloader.niko.ink.CCChunkloader;
import ccchunkloader.niko.ink.ChunkLoaderRegistry;
import ccchunkloader.niko.ink.ChunkLoaderUpgrade;
import ccchunkloader.niko.ink.ChunkManager;
import ccchunkloader.niko.ink.Config;
import ccchunkloader.niko.ink.TurtleStateEvents;
import ccchunkloader.niko.ink.TurtleStateManager;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkLoaderPeripheral
implements IPeripheral {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChunkLoaderPeripheral.class);
    private static final String RADIUS_KEY = "Radius";
    private static final String FUEL_DEBT_KEY = "FuelDebt";
    private static final String WAKE_ON_WORLD_LOAD_KEY = "WakeOnWorldLoad";
    private static final String RANDOM_TICK_ENABLED_KEY = "RandomTickEnabled";
    private static final String LAST_CHUNK_POS_KEY = "LastChunkPos";
    private static final double FUEL_DEBT_THRESHOLD = 1.0;
    private static final double FUEL_DEBT_EPSILON = 0.001;
    private static final int CHUNK_SEARCH_PADDING = 1;
    private final ITurtleAccess turtle;
    private final TurtleSide side;
    private final UUID turtleId;
    private double radius = 0.0;
    private class_1923 lastChunkPos = null;
    private double fuelDebt = 0.0;
    private boolean wakeOnWorldLoad = false;
    private boolean randomTickEnabled = false;
    private boolean computerIdRegistered = false;
    private boolean isDirty = false;

    public ChunkLoaderPeripheral(ITurtleAccess turtle, TurtleSide side) {
        this.turtle = turtle;
        this.side = side;
        this.turtleId = ChunkLoaderUpgrade.getTurtleUUID(turtle, side);
        this.loadStateFromNewArchitecture();
        ChunkLoaderRegistry.register(this.turtleId, this);
        LOGGER.info("ChunkLoaderPeripheral created for turtle {} using new bug-free architecture", (Object)this.turtleId);
        class_1937 class_19372 = turtle.getLevel();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            this.lastChunkPos = new class_1923(turtle.getPosition());
            ChunkManager manager = ChunkManager.get(serverWorld);
            if (!manager.isTurtleTracked(this.turtleId)) {
                manager.touch(this.turtleId);
            }
            manager.updateTurtlePosition(this.turtleId, this.lastChunkPos);
            manager.updateTurtleFuel(this.turtleId, turtle.getFuelLevel());
            TurtleStateManager stateManager = CCChunkloader.getStateManager();
            TurtleStateEvents eventSystem = CCChunkloader.getEventSystem();
            TurtleStateManager.TurtleState state = stateManager.getState(this.turtleId);
            eventSystem.fireEvent(new TurtleStateEvents.TurtleLoadedEvent(this.turtleId, this, state));
            LOGGER.info("Successfully created ChunkLoaderPeripheral with UUID: {} (restored radius: {})", (Object)this.turtleId, (Object)this.radius);
            this.markDirty();
            this.forceSaveState();
            serverWorld.method_8503().execute(() -> {
                if (this.radius > 0.0) {
                    this.resumeChunkLoading(serverWorld);
                }
                this.confirmAndClearRadiusOverride(serverWorld);
            });
        } else {
            LOGGER.error("ERROR: World is not ServerWorld! Type: {}", (Object)(turtle.getLevel() != null ? turtle.getLevel().getClass().getName() : "NULL"));
        }
    }

    @NotNull
    public String getType() {
        return "chunkloader";
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }

    @LuaFunction
    public final double setRadius(double newRadius) throws LuaException {
        if (newRadius < 0.0 || newRadius > Config.MAX_RADIUS) {
            throw new LuaException("Radius must be between 0.0 and " + Config.MAX_RADIUS);
        }
        class_1937 class_19372 = this.turtle.getLevel();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            double oldRadius = this.radius;
            this.radius = newRadius;
            serverWorld.method_8503().execute(() -> this.setRadiusAsync(serverWorld, oldRadius, newRadius));
            LOGGER.info("\ud83c\udfaf COMMAND EFFECT: Turtle {} radius change {} -> {} queued for execution", new Object[]{this.turtleId, oldRadius, newRadius});
        }
        return newRadius;
    }

    private void setRadiusAsync(class_3218 serverWorld, double oldRadius, double newRadius) {
        try {
            ChunkManager manager = ChunkManager.get(serverWorld);
            if (oldRadius > 0.0) {
                int removedCount = manager.getLoadedChunkCount(this.turtleId);
                manager.removeAllChunks(this.turtleId);
                LOGGER.info("\ud83d\udd04 CHUNK UNLOAD: Turtle {} removed {} force-loaded chunks (radius {} -> {})", new Object[]{this.turtleId, removedCount, oldRadius, newRadius});
            }
            if (newRadius > 0.0) {
                class_1923 currentChunk = new class_1923(this.turtle.getPosition());
                Set<class_1923> chunksToLoad = this.computeChunks(currentChunk, newRadius);
                manager.addChunksFromSet(this.turtleId, chunksToLoad);
                this.lastChunkPos = currentChunk;
                LOGGER.info("\ud83d\udd04 CHUNK LOAD: Turtle {} force-loaded {} chunks at radius {} (center: {})", new Object[]{this.turtleId, chunksToLoad.size(), newRadius, currentChunk});
            } else {
                this.lastChunkPos = null;
                LOGGER.info("\ud83d\udd04 CHUNK CLEAR: Turtle {} cleared all force-loaded chunks (radius set to 0)", (Object)this.turtleId);
            }
            this.markDirty();
            this.forceSaveState();
        }
        catch (Exception e) {
            LOGGER.error("Failed to set radius asynchronously for turtle {}: {}", (Object)this.turtleId, (Object)e.getMessage());
        }
    }

    @LuaFunction
    public final double getRadius() {
        return this.radius;
    }

    @LuaFunction
    public final double getFuelRate() {
        return this.calculateFuelCost();
    }

    public int getLoadedChunkCount() {
        class_1937 class_19372 = this.turtle.getLevel();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            ChunkManager manager = ChunkManager.get(serverWorld);
            return manager.getLoadedChunkCount(this.turtleId);
        }
        return 0;
    }

    public boolean isActive() {
        return this.radius > 0.0;
    }

    @LuaFunction
    public final void setWakeOnWorldLoad(boolean wake) {
        this.wakeOnWorldLoad = wake;
        this.markDirty();
        this.forceSaveState();
        class_1937 class_19372 = this.turtle.getLevel();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            ChunkManager.get(serverWorld).touch(this.turtleId);
        }
        LOGGER.debug("Turtle {} wake on world load set to {}", (Object)this.turtleId, (Object)wake);
    }

    @LuaFunction
    public final boolean getWakeOnWorldLoad() {
        return this.wakeOnWorldLoad;
    }

    @LuaFunction
    public final void setRandomTick(boolean enabled) throws LuaException {
        if (enabled && this.radius > Config.MAX_RANDOM_TICK_RADIUS) {
            throw new LuaException("Cannot enable random ticks - radius " + this.radius + " exceeds maximum " + Config.MAX_RANDOM_TICK_RADIUS);
        }
        this.setRandomTickEnabled(enabled);
    }

    @LuaFunction
    public final boolean getRandomTick() {
        return this.isRandomTickEnabled();
    }

    public double calculateFuelCost() {
        if (this.radius <= 0.0) {
            return 0.0;
        }
        class_1923 centerChunk = new class_1923(this.turtle.getPosition());
        Set<class_1923> chunks = this.computeChunks(centerChunk, this.radius);
        double totalCost = 0.0;
        for (class_1923 chunkPos : chunks) {
            int x = chunkPos.field_9181 - centerChunk.field_9181;
            int z = chunkPos.field_9180 - centerChunk.field_9180;
            double distance = Math.sqrt(x * x + z * z);
            double chunkCost = Config.BASE_FUEL_COST_PER_CHUNK * Math.pow(Config.DISTANCE_MULTIPLIER, distance);
            totalCost += chunkCost;
        }
        if (this.randomTickEnabled) {
            totalCost *= Config.RANDOM_TICK_FUEL_MULTIPLIER;
        }
        return totalCost;
    }

    private Set<class_1923> computeChunks(class_1923 centerChunk, double radius) {
        HashSet<class_1923> chunks = new HashSet<class_1923>();
        if (radius <= 0.0) {
            return chunks;
        }
        int searchRadius = (int)Math.ceil(radius) + 1;
        for (int x = -searchRadius; x <= searchRadius; ++x) {
            for (int z = -searchRadius; z <= searchRadius; ++z) {
                double distance = Math.sqrt(x * x + z * z);
                if (!(distance < radius)) continue;
                chunks.add(new class_1923(centerChunk.field_9181 + x, centerChunk.field_9180 + z));
            }
        }
        return chunks;
    }

    private void cleanupInactiveChunks(ChunkManager manager) {
        if (manager.hasLoadedChunks(this.turtleId)) {
            manager.removeAllChunks(this.turtleId);
        }
    }

    private boolean updatePersistentState(ChunkManager manager, class_1923 currentChunk) {
        boolean moved;
        boolean bl = moved = this.lastChunkPos == null || !this.lastChunkPos.equals((Object)currentChunk);
        if (moved) {
            this.lastChunkPos = currentChunk;
        }
        manager.updateTurtlePosition(this.turtleId, currentChunk);
        manager.updateTurtleFuel(this.turtleId, this.turtle.getFuelLevel());
        return moved;
    }

    private void ensureComputerRegistration(ChunkManager manager, class_3218 serverWorld) {
        Integer computerId;
        if (!this.computerIdRegistered && (computerId = this.getTurtleComputerId()) != null) {
            manager.registerUUIDForComputer(computerId, this.turtleId);
            LOGGER.info("Registered turtle {} (UUID: {}) with computer ID {} [DEFERRED]", new Object[]{this.turtle.getPosition(), this.turtleId, computerId});
            this.validateComputerUUIDs(manager, computerId, serverWorld);
            this.computerIdRegistered = true;
        }
    }

    private boolean processChunkLoading(ChunkManager manager, class_1923 currentChunk, boolean moved) {
        if (moved || !manager.hasLoadedChunks(this.turtleId)) {
            double fuelCostPerTick = this.calculateFuelCost();
            if (this.turtle.getFuelLevel() > 0 && fuelCostPerTick > 0.0) {
                Set<class_1923> chunksToLoad = this.computeChunks(currentChunk, this.radius);
                manager.addChunksFromSet(this.turtleId, chunksToLoad);
            } else {
                this.radius = 0.0;
                this.fuelDebt = 0.0;
                manager.removeAllChunks(this.turtleId);
                LOGGER.debug("Turtle {} cannot afford chunk loading, disabling.", (Object)this.turtleId);
                this.markDirty();
                this.forceSaveState();
                return true;
            }
        }
        return false;
    }

    private boolean processFuelConsumption(ChunkManager manager) {
        double oldFuelDebt = this.fuelDebt;
        this.fuelDebt += this.calculateFuelCost();
        if (this.fuelDebt >= 1.0) {
            int fuelToConsume = (int)Math.floor(this.fuelDebt);
            if (this.turtle.getFuelLevel() >= fuelToConsume && this.turtle.consumeFuel(fuelToConsume)) {
                this.fuelDebt -= (double)fuelToConsume;
                return true;
            }
            this.radius = 0.0;
            this.fuelDebt = 0.0;
            manager.removeAllChunks(this.turtleId);
            LOGGER.debug("Turtle {} ran out of fuel, disabling chunk loading.", (Object)this.turtleId);
            this.markDirty();
            this.forceSaveState();
            return true;
        }
        return Math.abs(this.fuelDebt - oldFuelDebt) > 0.001;
    }

    private void markDirty() {
        this.isDirty = true;
    }

    private void saveStateIfChanged(boolean stateChanged) {
        if (stateChanged) {
            this.markDirty();
        }
    }

    private void forceSaveState() {
        if (this.isDirty) {
            this.saveStateToUpgradeNBT();
            this.isDirty = false;
        }
    }

    public void updateChunkLoading() {
        class_1937 class_19372 = this.turtle.getLevel();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        ChunkManager manager = ChunkManager.get(serverWorld);
        class_1923 currentChunk = new class_1923(this.turtle.getPosition());
        boolean moved = this.updatePersistentState(manager, currentChunk);
        this.ensureComputerRegistration(manager, serverWorld);
        boolean stateChanged = moved;
        if (this.radius > 0.0) {
            stateChanged |= this.processChunkLoading(manager, currentChunk, moved);
            stateChanged |= this.processFuelConsumption(manager);
        } else {
            this.cleanupInactiveChunks(manager);
        }
        this.saveStateIfChanged(stateChanged);
    }

    public void cleanup() {
        TurtleStateEvents eventSystem;
        if (this.turtle.getLevel() instanceof class_3218) {
            TurtleStateManager stateManager = CCChunkloader.getStateManager();
            eventSystem = CCChunkloader.getEventSystem();
            TurtleStateManager.TurtleState state = stateManager.getState(this.turtleId);
            eventSystem.fireEvent(new TurtleStateEvents.TurtleUnloadedEvent(this.turtleId, state, "cleanup"));
        }
        this.markDirty();
        this.forceSaveState();
        ChunkLoaderRegistry.unregister(this.turtleId);
        eventSystem = this.turtle.getLevel();
        if (eventSystem instanceof class_3218) {
            class_3218 serverWorld = (class_3218)eventSystem;
            ChunkManager manager = ChunkManager.get(serverWorld);
            manager.removeAllChunks(this.turtleId);
            LOGGER.debug("Cleaned up turtle {} but preserved state in cache", (Object)this.turtleId);
        }
    }

    public UUID getTurtleId() {
        return this.turtleId;
    }

    @LuaFunction
    public final String getTurtleIdString() {
        if (this.turtleId == null) {
            LOGGER.error("ERROR: turtleId is NULL!");
            return "NULL_TURTLE_ID";
        }
        return this.turtleId.toString();
    }

    @LuaFunction
    public final boolean hasUUID() {
        return this.turtleId != null;
    }

    public class_1937 getTurtleLevel() {
        return this.turtle.getLevel();
    }

    public class_2338 getTurtlePosition() {
        return this.turtle.getPosition();
    }

    public double getMaxRadius() {
        return Config.MAX_RADIUS;
    }

    public int getFuelLevel() {
        return this.turtle.getFuelLevel();
    }

    public boolean setRadiusRemote(double newRadius) {
        try {
            class_1937 class_19372 = this.turtle.getLevel();
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                ChunkManager manager = ChunkManager.get(serverWorld);
                manager.setRadiusOverride(this.turtleId, newRadius);
                LOGGER.debug("Set radius override {} for turtle {} during remote control", (Object)newRadius, (Object)this.turtleId);
            }
            this.setRadius(newRadius);
            return true;
        }
        catch (Exception e) {
            LOGGER.warn("Remote radius change failed for turtle {}: {}", (Object)this.turtleId, (Object)e.getMessage());
            return false;
        }
    }

    public SavedState getSavedState() {
        return new SavedState(this.radius, this.lastChunkPos, this.fuelDebt, this.wakeOnWorldLoad, this.randomTickEnabled, this.turtle.getFuelLevel());
    }

    public void restoreState(SavedState state) {
        this.radius = state.radius;
        this.lastChunkPos = state.lastChunkPos;
        this.fuelDebt = state.fuelDebt;
        this.wakeOnWorldLoad = state.wakeOnWorldLoad;
        this.randomTickEnabled = state.randomTickEnabled;
        LOGGER.debug("Restored state for turtle {}: radius={}, lastChunk={}, fuelDebt={}, wakeOnWorldLoad={}, randomTick={}", new Object[]{this.turtleId, this.radius, this.lastChunkPos, this.fuelDebt, this.wakeOnWorldLoad, this.randomTickEnabled});
    }

    public class_5321<class_1937> getWorldKey() {
        class_1937 class_19372 = this.turtle.getLevel();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            return serverWorld.method_27983();
        }
        return null;
    }

    public Set<class_1923> getLoadedChunks() {
        if (this.radius > 0.0 && this.turtle.getLevel() != null) {
            return this.computeChunks(new class_1923(this.turtle.getPosition()), this.radius);
        }
        return Set.of();
    }

    public boolean isRandomTickEnabled() {
        return this.randomTickEnabled;
    }

    public void setRandomTickEnabled(boolean enabled) {
        if (enabled && this.radius > Config.MAX_RANDOM_TICK_RADIUS) {
            LOGGER.warn("Cannot enable random ticks for turtle {} - radius {} exceeds maximum {}", new Object[]{this.turtleId, this.radius, Config.MAX_RANDOM_TICK_RADIUS});
            return;
        }
        this.randomTickEnabled = enabled;
        this.markDirty();
        this.forceSaveState();
        LOGGER.debug("Random ticks {} for turtle {} (radius: {})", new Object[]{enabled ? "enabled" : "disabled", this.turtleId, this.radius});
    }

    private void loadStateFromNewArchitecture() {
        class_1937 class_19372;
        class_2487 upgradeData = this.turtle.getUpgradeNBTData(this.side);
        double nbtRadius = upgradeData.method_10574(RADIUS_KEY);
        this.fuelDebt = upgradeData.method_10574(FUEL_DEBT_KEY);
        this.wakeOnWorldLoad = upgradeData.method_10577(WAKE_ON_WORLD_LOAD_KEY);
        this.randomTickEnabled = upgradeData.method_10577(RANDOM_TICK_ENABLED_KEY);
        if (upgradeData.method_10545(LAST_CHUNK_POS_KEY)) {
            class_2487 chunkPosNbt = upgradeData.method_10562(LAST_CHUNK_POS_KEY);
            this.lastChunkPos = new class_1923(chunkPosNbt.method_10550("x"), chunkPosNbt.method_10550("z"));
        }
        if ((class_19372 = this.turtle.getLevel()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            SavedState savedState = new SavedState(nbtRadius, this.lastChunkPos, this.fuelDebt, this.wakeOnWorldLoad, this.randomTickEnabled, this.turtle.getFuelLevel());
            TurtleStateManager stateManager = CCChunkloader.getStateManager();
            Integer computerId = this.getTurtleComputerId();
            stateManager.updateFromPeripheral(this.turtleId, savedState, computerId, (class_5321<class_1937>)serverWorld.method_27983());
            TurtleStateManager.TurtleState state = stateManager.getState(this.turtleId);
            this.radius = state.getEffectiveRadius();
            this.wakeOnWorldLoad = state.getEffectiveWakeOnWorldLoad();
            LOGGER.info("Loaded turtle state via new architecture - NBT radius: {}, Effective radius: {} (preserves all commands!)", (Object)nbtRadius, (Object)this.radius);
        } else {
            this.radius = nbtRadius;
        }
        LOGGER.debug("Loaded state: radius={}, fuelDebt={}, wake={}, randomTick={}, lastChunk={}", new Object[]{this.radius, this.fuelDebt, this.wakeOnWorldLoad, this.randomTickEnabled, this.lastChunkPos});
    }

    private void saveStateToUpgradeNBT() {
        class_2487 upgradeData = this.turtle.getUpgradeNBTData(this.side);
        upgradeData.method_10549(RADIUS_KEY, this.radius);
        upgradeData.method_10549(FUEL_DEBT_KEY, this.fuelDebt);
        upgradeData.method_10556(WAKE_ON_WORLD_LOAD_KEY, this.wakeOnWorldLoad);
        upgradeData.method_10556(RANDOM_TICK_ENABLED_KEY, this.randomTickEnabled);
        if (this.lastChunkPos != null) {
            class_2487 chunkPosNbt = new class_2487();
            chunkPosNbt.method_10569("x", this.lastChunkPos.field_9181);
            chunkPosNbt.method_10569("z", this.lastChunkPos.field_9180);
            upgradeData.method_10566(LAST_CHUNK_POS_KEY, (class_2520)chunkPosNbt);
        }
        this.turtle.updateUpgradeNBTData(this.side);
        this.updateChunkManagerCache();
        this.isDirty = false;
        LOGGER.debug("Saved state to upgrade NBT: radius={}, fuelDebt={}, wake={}, randomTick={}, lastChunk={}", new Object[]{this.radius, this.fuelDebt, this.wakeOnWorldLoad, this.randomTickEnabled, this.lastChunkPos});
    }

    private void updateChunkManagerCache() {
        class_1937 class_19372 = this.turtle.getLevel();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            ChunkManager manager = ChunkManager.get(serverWorld);
            SavedState currentState = this.getSavedState();
            LOGGER.info("DEBUG: updateChunkManagerCache for turtle {} - Saving state: radius={}, fuel={} at {}", new Object[]{this.turtleId, currentState.radius, currentState.fuelLevel, System.currentTimeMillis()});
            manager.updateTurtleStateCache(this.turtleId, currentState);
        }
    }

    private void resumeChunkLoading(class_3218 serverWorld) {
        if (this.radius <= 0.0) {
            LOGGER.debug("Turtle {} radius is 0, skipping chunk loading resume", (Object)this.turtleId);
            return;
        }
        if (this.turtle.getFuelLevel() <= 0) {
            LOGGER.warn("Turtle {} has no fuel, cannot resume chunk loading", (Object)this.turtleId);
            this.radius = 0.0;
            this.markDirty();
            this.forceSaveState();
            return;
        }
        try {
            ChunkManager manager = ChunkManager.get(serverWorld);
            class_1923 currentChunk = new class_1923(this.turtle.getPosition());
            Set<class_1923> chunksToLoad = this.computeChunks(currentChunk, this.radius);
            manager.addChunksFromSet(this.turtleId, chunksToLoad);
            this.lastChunkPos = currentChunk;
            LOGGER.info("Turtle {} resumed chunk loading with {} chunks at radius {}", new Object[]{this.turtleId, chunksToLoad.size(), this.radius});
            this.markDirty();
            this.forceSaveState();
        }
        catch (Exception e) {
            LOGGER.error("Failed to resume chunk loading for turtle {}: {}", (Object)this.turtleId, (Object)e.getMessage());
        }
    }

    private void confirmAndClearRadiusOverride(class_3218 serverWorld) {
        try {
            ChunkManager manager = ChunkManager.get(serverWorld);
            Double pendingOverride = manager.getRadiusOverride(this.turtleId);
            if (pendingOverride != null) {
                serverWorld.method_8503().execute(() -> new Thread(() -> {
                    try {
                        Thread.sleep(5000L);
                        serverWorld.method_8503().execute(() -> {
                            try {
                                if (Math.abs(this.radius - pendingOverride) < 0.001) {
                                    if (this.radius > 0.0 && this.getLoadedChunkCount() > 0) {
                                        manager.clearRadiusOverride(this.turtleId);
                                        LOGGER.info("Radius override {} successfully confirmed and cleared for turtle {}", (Object)pendingOverride, (Object)this.turtleId);
                                    } else if (this.radius == 0.0 && pendingOverride == 0.0) {
                                        manager.clearRadiusOverride(this.turtleId);
                                        LOGGER.info("Zero radius override confirmed and cleared for turtle {}", (Object)this.turtleId);
                                    } else {
                                        LOGGER.debug("Turtle {} has override radius {} but isn't loading chunks yet - keeping override", (Object)this.turtleId, (Object)pendingOverride);
                                    }
                                } else {
                                    LOGGER.warn("Turtle {} has radius {} but expected {} - keeping override for retry", new Object[]{this.turtleId, this.radius, pendingOverride});
                                }
                            }
                            catch (Exception e) {
                                LOGGER.error("Failed to confirm radius override for turtle {}: {}", (Object)this.turtleId, (Object)e.getMessage());
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        LOGGER.debug("Confirmation delay interrupted for turtle {}", (Object)this.turtleId);
                    }
                }, "ChunkLoader-Override-Confirm-" + String.valueOf(this.turtleId)).start());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to check radius override for turtle {}: {}", (Object)this.turtleId, (Object)e.getMessage());
        }
    }

    private void validateComputerUUIDs(ChunkManager manager, int computerId, class_3218 serverWorld) {
        try {
            ITurtleUpgrade rightUpgrade;
            class_2586 blockEntity = serverWorld.method_8321(this.turtle.getPosition());
            if (!(blockEntity instanceof TurtleBlockEntity)) {
                LOGGER.warn("Cannot validate computer {} UUIDs - not a TurtleBlockEntity", (Object)computerId);
                return;
            }
            TurtleBlockEntity turtleEntity = (TurtleBlockEntity)blockEntity;
            HashSet<UUID> currentlyEquippedUUIDs = new HashSet<UUID>();
            ITurtleUpgrade leftUpgrade = turtleEntity.getUpgrade(TurtleSide.LEFT);
            if (leftUpgrade instanceof ChunkLoaderUpgrade) {
                UUID leftUUID = ChunkLoaderUpgrade.getTurtleUUID(this.turtle, TurtleSide.LEFT);
                currentlyEquippedUUIDs.add(leftUUID);
                LOGGER.debug("Computer {} has chunkloader on LEFT side with UUID {}", (Object)computerId, (Object)leftUUID);
            }
            if ((rightUpgrade = turtleEntity.getUpgrade(TurtleSide.RIGHT)) instanceof ChunkLoaderUpgrade) {
                UUID rightUUID = ChunkLoaderUpgrade.getTurtleUUID(this.turtle, TurtleSide.RIGHT);
                currentlyEquippedUUIDs.add(rightUUID);
                LOGGER.debug("Computer {} has chunkloader on RIGHT side with UUID {}", (Object)computerId, (Object)rightUUID);
            }
            LOGGER.info("Computer {} validation: found {} currently equipped chunkloaders", (Object)computerId, (Object)currentlyEquippedUUIDs.size());
            manager.validateUUIDsForComputer(computerId, currentlyEquippedUUIDs);
        }
        catch (Exception e) {
            LOGGER.error("Failed to validate UUIDs for computer {}: {}", (Object)computerId, (Object)e.getMessage());
        }
    }

    private Integer getTurtleComputerId() {
        class_1937 class_19372 = this.turtle.getLevel();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            try {
                class_2586 blockEntity = serverWorld.method_8321(this.turtle.getPosition());
                if (blockEntity instanceof TurtleBlockEntity) {
                    TurtleBlockEntity turtleEntity = (TurtleBlockEntity)blockEntity;
                    ServerComputer computer = turtleEntity.getServerComputer();
                    if (computer != null) {
                        return computer.getID();
                    }
                    LOGGER.debug("Turtle {} has no ServerComputer instance (computer not ready yet)", (Object)this.turtleId);
                } else {
                    LOGGER.warn("Block entity at turtle position {} is not a TurtleBlockEntity: {}", (Object)this.turtle.getPosition(), (Object)(blockEntity != null ? blockEntity.getClass().getName() : "null"));
                }
            }
            catch (Exception e) {
                LOGGER.debug("Failed to get computer ID for turtle {} (computer not ready): {}", (Object)this.turtleId, (Object)e.getMessage());
            }
        }
        return null;
    }

    public static class SavedState {
        public final double radius;
        public final class_1923 lastChunkPos;
        public final double fuelDebt;
        public final boolean wakeOnWorldLoad;
        public final boolean randomTickEnabled;
        public final int fuelLevel;

        public SavedState(double radius, class_1923 lastChunkPos, double fuelDebt, boolean wakeOnWorldLoad, boolean randomTickEnabled, int fuelLevel) {
            this.radius = radius;
            this.lastChunkPos = lastChunkPos;
            this.fuelDebt = fuelDebt;
            this.wakeOnWorldLoad = wakeOnWorldLoad;
            this.randomTickEnabled = randomTickEnabled;
            this.fuelLevel = fuelLevel;
        }
    }
}

