/*
 * Decompiled with CFR 0.152.
 */
package ccchunkloader.niko.ink;

import ccchunkloader.niko.ink.ChunkLoaderPeripheral;
import ccchunkloader.niko.ink.ChunkLoaderRegistry;
import ccchunkloader.niko.ink.ChunkLoaderUpgrade;
import ccchunkloader.niko.ink.ChunkManager;
import ccchunkloader.niko.ink.ChunkManagerPersistentState;
import ccchunkloader.niko.ink.ChunkloaderCommand;
import ccchunkloader.niko.ink.ChunkloaderManagerBlock;
import ccchunkloader.niko.ink.ChunkloaderManagerBlockEntity;
import ccchunkloader.niko.ink.DefaultTurtleEventHandlers;
import ccchunkloader.niko.ink.RandomTickOrchestrator;
import ccchunkloader.niko.ink.TurtleCommandQueue;
import ccchunkloader.niko.ink.TurtleStateEvents;
import ccchunkloader.niko.ink.TurtleStateManager;
import com.mojang.brigadier.CommandDispatcher;
import dan200.computercraft.api.peripheral.PeripheralLookup;
import dan200.computercraft.api.turtle.TurtleUpgradeSerialiser;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2591;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CCChunkloader
implements ModInitializer {
    public static final String MOD_ID = "ccchunkloader";
    private static final Logger LOGGER = LoggerFactory.getLogger(CCChunkloader.class);
    private static TurtleStateManager stateManager;
    private static TurtleCommandQueue commandQueue;
    private static TurtleStateEvents eventSystem;
    public static final class_1792 CHUNKLOADER_UPGRADE;
    public static final class_2248 CHUNKLOADER_MANAGER_BLOCK;
    public static final class_1792 CHUNKLOADER_MANAGER_ITEM;
    public static class_2591<ChunkloaderManagerBlockEntity> CHUNKLOADER_MANAGER_BLOCK_ENTITY;
    public static final TurtleUpgradeSerialiser<ChunkLoaderUpgrade> CHUNKLOADER_UPGRADE_SERIALISER;

    public void onInitialize() {
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)class_2960.method_43902((String)MOD_ID, (String)"chunkloader_upgrade"), (Object)CHUNKLOADER_UPGRADE);
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)class_2960.method_43902((String)MOD_ID, (String)"chunkloader_manager"), (Object)CHUNKLOADER_MANAGER_BLOCK);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)class_2960.method_43902((String)MOD_ID, (String)"chunkloader_manager"), (Object)CHUNKLOADER_MANAGER_ITEM);
        CHUNKLOADER_MANAGER_BLOCK_ENTITY = (class_2591)class_2378.method_10230((class_2378)class_7923.field_41181, (class_2960)class_2960.method_43902((String)MOD_ID, (String)"chunkloader_manager"), (Object)class_2591.class_2592.method_20528(ChunkloaderManagerBlockEntity::new, (class_2248[])new class_2248[]{CHUNKLOADER_MANAGER_BLOCK}).method_11034(null));
        class_2378 turtleUpgradeSerialisers = (class_2378)class_7923.field_41167.method_10223(TurtleUpgradeSerialiser.registryId().method_29177());
        class_2378.method_10230((class_2378)turtleUpgradeSerialisers, (class_2960)class_2960.method_43902((String)MOD_ID, (String)"chunkloader"), CHUNKLOADER_UPGRADE_SERIALISER);
        PeripheralLookup.get().registerForBlockEntity((blockEntity, direction) -> {
            if (blockEntity instanceof ChunkloaderManagerBlockEntity) {
                ChunkloaderManagerBlockEntity entity = blockEntity;
                return entity.getPeripheral((class_2350)direction);
            }
            return null;
        }, CHUNKLOADER_MANAGER_BLOCK_ENTITY);
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40198).register(entries -> {
            entries.method_45421((class_1935)CHUNKLOADER_UPGRADE);
            entries.method_45421((class_1935)CHUNKLOADER_MANAGER_ITEM);
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(this::onServerStopping);
        ServerWorldEvents.LOAD.register(this::onWorldLoad);
        ServerWorldEvents.UNLOAD.register(this::onWorldUnload);
        ServerChunkEvents.CHUNK_UNLOAD.register(this::onChunkUnload);
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> ChunkloaderCommand.register((CommandDispatcher<class_2168>)dispatcher));
        RandomTickOrchestrator.getInstance().initialize();
        this.initializeNewArchitecture();
    }

    private void onServerStopping(MinecraftServer server) {
        this.saveAllChunkManagerStates(server);
        ChunkManager.cleanupAll();
        ChunkLoaderRegistry.clearAll();
    }

    private void onWorldLoad(MinecraftServer server, class_3218 world) {
        ChunkManagerPersistentState persistentState = ChunkManagerPersistentState.getWorldState(world);
        if (persistentState.hasData()) {
            ChunkManager chunkManager = ChunkManager.get(world);
            class_2487 savedData = persistentState.getChunkManagerData();
            ChunkManager.DeserializationResult result = chunkManager.deserializeFromNbt(savedData);
            this.populateRegistryWithRestoredTurtles(world, chunkManager);
            int dormantCount = result.total - result.toWake;
            LOGGER.info("Loaded turtle states for {}: {} total ({} to wake, {} dormant).", new Object[]{world.method_27983().method_29177(), result.total, result.toWake, dormantCount});
        } else {
            LOGGER.info("No saved turtle states found for dimension: {}.", (Object)world.method_27983().method_29177());
        }
    }

    private void onWorldUnload(MinecraftServer server, class_3218 world) {
        this.saveChunkManagerState(world);
    }

    private void onChunkUnload(class_3218 world, class_2818 chunk) {
        class_1923 chunkPos = chunk.method_12004();
        Map<UUID, ChunkLoaderPeripheral> activePeripherals = ChunkLoaderRegistry.getAllPeripherals();
        for (Map.Entry<UUID, ChunkLoaderPeripheral> entry : activePeripherals.entrySet()) {
            class_1923 turtleChunk;
            class_2338 turtlePos;
            UUID turtleId = entry.getKey();
            ChunkLoaderPeripheral peripheral = entry.getValue();
            if (peripheral.getTurtleLevel() != world || (turtlePos = peripheral.getTurtlePosition()) == null || !(turtleChunk = new class_1923(turtlePos)).equals((Object)chunkPos)) continue;
            LOGGER.debug("Chunk {} unloaded, removing turtle {} peripheral", (Object)chunkPos, (Object)turtleId);
            peripheral.cleanup();
            TurtleStateManager.TurtleState state = stateManager.getState(turtleId);
            eventSystem.fireEvent(new TurtleStateEvents.TurtleUnloadedEvent(turtleId, state, "chunk_unload"));
        }
    }

    private void saveChunkManagerState(class_3218 world) {
        ChunkManager chunkManager = ChunkManager.get(world);
        ChunkManagerPersistentState persistentState = ChunkManagerPersistentState.getWorldState(world);
        class_2487 serializedData = chunkManager.serializeToNbt();
        persistentState.saveChunkManagerData(serializedData);
        int savedCount = serializedData.method_10554("turtleStates", 10).size();
        LOGGER.info("Saved {} turtle states for dimension: {}.", (Object)savedCount, (Object)world.method_27983().method_29177());
    }

    private void saveAllChunkManagerStates(MinecraftServer server) {
        for (class_3218 world : server.method_3738()) {
            this.saveChunkManagerState(world);
        }
    }

    private void populateRegistryWithRestoredTurtles(class_3218 world, ChunkManager chunkManager) {
        Map<UUID, ChunkLoaderPeripheral.SavedState> restoredStates = chunkManager.getAllRestoredTurtleStates();
        int wokenCount = 0;
        for (Map.Entry<UUID, ChunkLoaderPeripheral.SavedState> entry : restoredStates.entrySet()) {
            UUID turtleId = entry.getKey();
            ChunkLoaderPeripheral.SavedState savedState = entry.getValue();
            if (ChunkLoaderRegistry.getPeripheral(turtleId) != null) continue;
            if (savedState.lastChunkPos != null) {
                if (savedState.wakeOnWorldLoad) {
                    ++wokenCount;
                    LOGGER.debug("Registered turtle {} for bootstrap wake-up at position {}", (Object)turtleId, (Object)savedState.lastChunkPos);
                    continue;
                }
                LOGGER.debug("Registered dormant turtle {} at position {} (wakeOnWorldLoad = false)", (Object)turtleId, (Object)savedState.lastChunkPos);
                continue;
            }
            LOGGER.debug("Registered dormant turtle {} at position {} (saved: radius={}, fuelDebt={})", new Object[]{turtleId, savedState.lastChunkPos, savedState.radius, savedState.fuelDebt});
        }
        LOGGER.info("ChunkLoaderRegistry populated: {} total turtle states, {} woken, {} dormant", new Object[]{restoredStates.size(), wokenCount, restoredStates.size() - wokenCount});
        if (wokenCount > 0) {
            LOGGER.info("Triggering force-bootstrap for {} woken turtles", (Object)wokenCount);
            ChunkManager.forceBootstrap(world);
        }
    }

    private void initializeNewArchitecture() {
        stateManager = new TurtleStateManager();
        commandQueue = new TurtleCommandQueue();
        eventSystem = new TurtleStateEvents();
        DefaultTurtleEventHandlers eventHandlers = new DefaultTurtleEventHandlers(stateManager, commandQueue);
        eventHandlers.registerDefaultHandlers(eventSystem);
        LOGGER.info("Initialized new turtle state architecture - radius override bug fix active!");
    }

    public static TurtleStateManager getStateManager() {
        return stateManager;
    }

    public static TurtleCommandQueue getCommandQueue() {
        return commandQueue;
    }

    public static TurtleStateEvents getEventSystem() {
        return eventSystem;
    }

    static {
        CHUNKLOADER_UPGRADE = new class_1792(new class_1792.class_1793());
        CHUNKLOADER_MANAGER_BLOCK = new ChunkloaderManagerBlock(class_4970.class_2251.method_9637().method_9629(2.0f, 6.0f).method_9626(class_2498.field_11544));
        CHUNKLOADER_MANAGER_ITEM = new class_1747(CHUNKLOADER_MANAGER_BLOCK, new class_1792.class_1793());
        CHUNKLOADER_UPGRADE_SERIALISER = TurtleUpgradeSerialiser.simpleWithCustomItem(ChunkLoaderUpgrade::new);
    }
}

