/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.models;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.github.fabricators_of_create.porting_lib.models.QuadTransformers;
import io.github.fabricators_of_create.porting_lib.models.UnbakedGeometryHelper;
import io.github.fabricators_of_create.porting_lib.models.geometry.IGeometryLoader;
import io.github.fabricators_of_create.porting_lib.models.geometry.IUnbakedGeometry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1093;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_783;
import net.minecraft.class_785;
import net.minecraft.class_793;
import net.minecraft.class_806;

public class ElementsModel
implements IUnbakedGeometry<ElementsModel> {
    private final List<class_785> elements;

    public ElementsModel(List<class_785> elements) {
        this.elements = elements;
    }

    public class_1087 bake(class_793 context, class_7775 baker, Function<class_4730, class_1058> spriteGetter, class_3665 modelState, class_806 overrides, class_2960 modelLocation, boolean isGui3d) {
        class_1058 particle = spriteGetter.apply(context.method_24077("particle"));
        class_1093.class_1094 modelBuilder = new class_1093.class_1094(context.method_3444(), context.method_24298().method_24299(), true, context.method_3443(), overrides).method_4747(particle);
        MeshBuilder meshBuilder = RendererAccess.INSTANCE.getRenderer().meshBuilder();
        QuadEmitter emitter = meshBuilder.getEmitter();
        RenderContext.QuadTransform postTransform = QuadTransformers.empty();
        class_4590 rootTransform = context.getRootTransform();
        if (!rootTransform.isIdentity()) {
            postTransform = UnbakedGeometryHelper.applyRootTransform((class_3665)modelState, (class_4590)rootTransform);
        }
        for (class_785 element : this.elements) {
            for (class_2350 direction : element.field_4230.keySet()) {
                class_783 face = (class_783)element.field_4230.get(direction);
                class_1058 sprite = spriteGetter.apply(context.method_24077(face.field_4224));
                class_777 quad = class_793.method_3447((class_785)element, (class_783)face, (class_1058)sprite, (class_2350)direction, (class_3665)modelState, (class_2960)modelLocation);
                emitter.fromVanilla(quad, RendererAccess.INSTANCE.getRenderer().materialFinder().find(), face.field_4225);
                postTransform.transform((MutableQuadView)emitter);
                quad = emitter.toBakedQuad(sprite);
                if (face.field_4225 == null) {
                    modelBuilder.method_4748(quad);
                    continue;
                }
                modelBuilder.method_4745(modelState.method_3509().rotateTransform(face.field_4225), quad);
            }
        }
        return modelBuilder.method_4746();
    }

    public static final class Loader
    implements IGeometryLoader<ElementsModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public ElementsModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
            if (!jsonObject.has("elements")) {
                throw new JsonParseException("An element model must have an \"elements\" member.");
            }
            if (!RendererAccess.INSTANCE.hasRenderer()) {
                throw new JsonParseException("The Fabric Rendering API is not available. If you have Sodium, install Indium!");
            }
            ArrayList<class_785> elements = new ArrayList<class_785>();
            for (JsonElement element : class_3518.method_15261((JsonObject)jsonObject, (String)"elements")) {
                elements.add((class_785)deserializationContext.deserialize(element, class_785.class));
            }
            return new ElementsModel(elements);
        }
    }
}

