/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.models;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.models.CompositeModel;
import io.github.fabricators_of_create.porting_lib.models.UnbakedGeometryHelper;
import io.github.fabricators_of_create.porting_lib.models.geometry.IGeometryLoader;
import io.github.fabricators_of_create.porting_lib.models.geometry.IUnbakedGeometry;
import io.github.fabricators_of_create.porting_lib.models.geometry.SimpleModelState;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1058;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_326;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_638;
import net.minecraft.class_7764;
import net.minecraft.class_7775;
import net.minecraft.class_7923;
import net.minecraft.class_793;
import net.minecraft.class_806;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class DynamicFluidContainerModel
implements IUnbakedGeometry<DynamicFluidContainerModel> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final class_4590 FLUID_TRANSFORM = new class_4590(new Vector3f(), new Quaternionf(), new Vector3f(1.0f, 1.0f, 1.002f), new Quaternionf());
    private static final class_4590 COVER_TRANSFORM = new class_4590(new Vector3f(), new Quaternionf(), new Vector3f(1.0f, 1.0f, 1.004f), new Quaternionf());
    private final class_3611 fluid;
    private final boolean flipGas;
    private final boolean coverIsMask;
    private final boolean applyFluidLuminosity;
    private final boolean deprecatedLoader;
    private final Map<String, String> deprecationWarnings;

    public DynamicFluidContainerModel(class_3611 fluid, boolean flipGas, boolean coverIsMask, boolean applyFluidLuminosity) {
        this(fluid, flipGas, coverIsMask, applyFluidLuminosity, false, Map.of());
    }

    private DynamicFluidContainerModel(class_3611 fluid, boolean flipGas, boolean coverIsMask, boolean applyFluidLuminosity, boolean deprecatedLoader, Map<String, String> deprecationWarnings) {
        this.fluid = fluid;
        this.flipGas = flipGas;
        this.coverIsMask = coverIsMask;
        this.applyFluidLuminosity = applyFluidLuminosity;
        this.deprecatedLoader = deprecatedLoader;
        this.deprecationWarnings = deprecationWarnings;
    }

    public DynamicFluidContainerModel withFluid(class_3611 newFluid) {
        return new DynamicFluidContainerModel(newFluid, this.flipGas, this.coverIsMask, this.applyFluidLuminosity, false, Map.of());
    }

    public class_1087 bake(class_793 context, class_7775 baker, Function<class_4730, class_1058> spriteGetter, class_3665 modelState, class_806 overrides, class_2960 modelLocation, boolean isGui3d) {
        List quads;
        List unbaked;
        SimpleModelState transformedState;
        class_1058 templateSprite;
        class_1058 particleSprite;
        if (this.deprecatedLoader) {
            LOGGER.warn("Model \"" + String.valueOf(modelLocation) + "\" is using the deprecated loader \"forge:bucket\" instead of \"forge:fluid_container\". This loader will be removed in 1.20.");
        }
        for (Map.Entry<String, String> entry : this.deprecationWarnings.entrySet()) {
            LOGGER.warn("Model \"" + String.valueOf(modelLocation) + "\" is using the deprecated \"" + entry.getKey() + "\" field in its fluid container model instead of \"" + entry.getValue() + "\". This field will be removed in 1.20.");
        }
        class_4730 particleLocation = context.method_3432("particle") ? context.method_24077("particle") : null;
        class_4730 baseLocation = context.method_3432("base") ? context.method_24077("base") : null;
        class_4730 fluidMaskLocation = context.method_3432("fluid") ? context.method_24077("fluid") : null;
        class_4730 coverLocation = context.method_3432("cover") ? context.method_24077("cover") : null;
        class_1058 baseSprite = baseLocation != null ? spriteGetter.apply(baseLocation) : null;
        class_1058 fluidSprite = FluidVariantRendering.getSprite((FluidVariant)FluidVariant.of((class_3611)this.fluid));
        class_1058 coverSprite = coverLocation != null && (!this.coverIsMask || baseLocation != null) ? spriteGetter.apply(coverLocation) : null;
        class_1058 class_10582 = particleSprite = particleLocation != null ? spriteGetter.apply(particleLocation) : null;
        if (particleSprite == null) {
            particleSprite = fluidSprite;
        }
        if (particleSprite == null) {
            particleSprite = baseSprite;
        }
        if (particleSprite == null && !this.coverIsMask) {
            particleSprite = coverSprite;
        }
        if (this.flipGas && this.fluid != class_3612.field_15906 && FluidVariantAttributes.isLighterThanAir((FluidVariant)FluidVariant.of((class_3611)this.fluid))) {
            modelState = new SimpleModelState(modelState.method_3509().method_22933(new class_4590(null, new Quaternionf(0.0f, 0.0f, 1.0f, 0.0f), null, null)));
        }
        CompositeModel.Baked.Builder modelBuilder = CompositeModel.Baked.builder(context.method_3444(), false, context.method_24298().method_24299(), particleSprite, new ContainedFluidOverrideHandler(overrides, baker, context, this), context.method_3443());
        if (baseLocation != null && baseSprite != null) {
            List unbaked2 = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (class_7764)baseSprite.method_45851());
            List quads2 = UnbakedGeometryHelper.bakeElements((List)unbaked2, $ -> baseSprite, (class_3665)modelState, (class_2960)modelLocation);
            modelBuilder.addQuads(quads2);
        }
        if (fluidMaskLocation != null && fluidSprite != null && (templateSprite = spriteGetter.apply(fluidMaskLocation)) != null) {
            transformedState = new SimpleModelState(modelState.method_3509().method_22933(FLUID_TRANSFORM), modelState.method_3512());
            unbaked = UnbakedGeometryHelper.createUnbakedItemMaskElements((int)1, (class_7764)templateSprite.method_45851());
            quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> fluidSprite, (class_3665)transformedState, (class_2960)modelLocation);
            modelBuilder.addQuads(quads);
        }
        if (coverSprite != null) {
            class_1058 sprite;
            class_1058 class_10583 = sprite = this.coverIsMask ? baseSprite : coverSprite;
            if (sprite != null) {
                transformedState = new SimpleModelState(modelState.method_3509().method_22933(COVER_TRANSFORM), modelState.method_3512());
                unbaked = UnbakedGeometryHelper.createUnbakedItemMaskElements((int)2, (class_7764)coverSprite.method_45851());
                quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> sprite, (class_3665)transformedState, (class_2960)modelLocation);
                modelBuilder.addQuads(quads);
            }
        }
        modelBuilder.setParticle(particleSprite);
        return modelBuilder.build();
    }

    private static final class ContainedFluidOverrideHandler
    extends class_806 {
        private final Map<String, class_1087> cache = Maps.newHashMap();
        private final class_806 nested;
        private final class_7775 baker;
        private final class_793 owner;
        private final DynamicFluidContainerModel parent;

        private ContainedFluidOverrideHandler(class_806 nested, class_7775 baker, class_793 owner, DynamicFluidContainerModel parent) {
            this.nested = nested;
            this.baker = baker;
            this.owner = owner;
            this.parent = parent;
        }

        public class_1087 method_3495(class_1087 originalModel, class_1799 stack, @Nullable class_638 level, @Nullable class_1309 entity, int seed) {
            class_1087 overridden = this.nested.method_3495(originalModel, stack, level, entity, seed);
            if (overridden != originalModel) {
                return overridden;
            }
            return TransferUtil.getFluidContained((class_1799)stack).map(fluidStack -> {
                class_3611 fluid = fluidStack.getFluid();
                String name = class_7923.field_41173.method_10221((Object)fluid).toString();
                if (!this.cache.containsKey(name)) {
                    DynamicFluidContainerModel unbaked = this.parent.withFluid(fluid);
                    class_1087 bakedModel = unbaked.bake(this.owner, this.baker, class_4730::method_24148, (class_3665)class_1086.field_5350, this, new class_2960("forge:bucket_override"), false);
                    this.cache.put(name, bakedModel);
                    return bakedModel;
                }
                return this.cache.get(name);
            }).orElse(originalModel);
        }
    }

    public static class Colors
    implements class_326 {
        public int getColor(@NotNull class_1799 stack, int tintIndex) {
            if (tintIndex != 1) {
                return -1;
            }
            return TransferUtil.getFluidContained((class_1799)stack).map(fluidStack -> FluidVariantRendering.getColor((FluidVariant)fluidStack.getType())).orElse(-1);
        }
    }

    public static final class Loader
    implements IGeometryLoader<DynamicFluidContainerModel> {
        public static final Loader INSTANCE = new Loader(false);
        @Deprecated(forRemoval=true, since="1.19")
        public static final Loader INSTANCE_DEPRECATED = new Loader(true);
        private final boolean deprecated;

        private Loader(boolean deprecated) {
            this.deprecated = deprecated;
        }

        public DynamicFluidContainerModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            if (!jsonObject.has("fluid")) {
                throw new RuntimeException("Bucket model requires 'fluid' value.");
            }
            class_2960 fluidName = new class_2960(jsonObject.get("fluid").getAsString());
            class_3611 fluid = (class_3611)class_7923.field_41173.method_10223(fluidName);
            boolean flip = class_3518.method_15258((JsonObject)jsonObject, (String)"flip_gas", (boolean)false);
            boolean coverIsMask = class_3518.method_15258((JsonObject)jsonObject, (String)"cover_is_mask", (boolean)true);
            boolean applyFluidLuminosity = class_3518.method_15258((JsonObject)jsonObject, (String)"apply_fluid_luminosity", (boolean)true);
            ImmutableMap.Builder deprecationWarningsBuilder = ImmutableMap.builder();
            if (jsonObject.has("flipGas")) {
                flip = class_3518.method_15270((JsonObject)jsonObject, (String)"flipGas");
                deprecationWarningsBuilder.put((Object)"flipGas", (Object)"flip_gas");
            }
            if (jsonObject.has("coverIsMask")) {
                coverIsMask = class_3518.method_15270((JsonObject)jsonObject, (String)"coverIsMask");
                deprecationWarningsBuilder.put((Object)"coverIsMask", (Object)"cover_is_mask");
            }
            if (jsonObject.has("applyFluidLuminosity")) {
                applyFluidLuminosity = class_3518.method_15270((JsonObject)jsonObject, (String)"applyFluidLuminosity");
                deprecationWarningsBuilder.put((Object)"applyFluidLuminosity", (Object)"apply_fluid_luminosity");
            }
            return new DynamicFluidContainerModel(fluid, flip, coverIsMask, applyFluidLuminosity, this.deprecated, (Map<String, String>)deprecationWarningsBuilder.build());
        }
    }
}

