/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.github.fabricators_of_create.porting_lib.models.CompositeModel;
import io.github.fabricators_of_create.porting_lib.models.geometry.IGeometryLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_793;

public enum CompositeModelLoader implements IGeometryLoader<CompositeModel>
{
    INSTANCE;


    public CompositeModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
        ArrayList<String> itemPasses = new ArrayList<String>();
        ImmutableMap.Builder childrenBuilder = ImmutableMap.builder();
        this.readChildren(jsonObject, "children", deserializationContext, (ImmutableMap.Builder<String, class_793>)childrenBuilder, itemPasses);
        ImmutableMap children = childrenBuilder.build();
        if (children.isEmpty()) {
            throw new JsonParseException("Composite model requires a \"children\" element with at least one element.");
        }
        if (jsonObject.has("item_render_order")) {
            itemPasses.clear();
            for (JsonElement element : jsonObject.getAsJsonArray("item_render_order")) {
                String name = element.getAsString();
                if (!children.containsKey((Object)name)) {
                    throw new JsonParseException("Specified \"" + name + "\" in \"item_render_order\", but that is not a child of this model.");
                }
                itemPasses.add(name);
            }
        }
        return new CompositeModel((ImmutableMap<String, class_793>)children, (ImmutableList<String>)ImmutableList.copyOf(itemPasses));
    }

    private void readChildren(JsonObject jsonObject, String name, JsonDeserializationContext deserializationContext, ImmutableMap.Builder<String, class_793> children, List<String> itemPasses) {
        if (!jsonObject.has(name)) {
            return;
        }
        JsonObject childrenJsonObject = jsonObject.getAsJsonObject(name);
        for (Map.Entry entry : childrenJsonObject.entrySet()) {
            children.put((Object)((String)entry.getKey()), (Object)((class_793)deserializationContext.deserialize((JsonElement)entry.getValue(), class_793.class)));
            itemPasses.add((String)entry.getKey());
        }
    }
}

