/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.lib.system;

import cc.tweaked.cobalt.internal.unwind.Pause;
import cc.tweaked.cobalt.internal.unwind.UnwindState;
import cc.tweaked.cobalt.internal.unwind.UnwindState$L4O4;
import java.io.InputStream;
import java.io.PrintStream;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.ErrorFactory;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.OperationHelper;
import org.squiddev.cobalt.UnwindThrowable;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.compiler.CompileException;
import org.squiddev.cobalt.compiler.LoadState;
import org.squiddev.cobalt.debug.DebugFrame;
import org.squiddev.cobalt.function.Dispatch;
import org.squiddev.cobalt.function.RegisteredFunction;
import org.squiddev.cobalt.lib.system.ResourceLoader;
import org.squiddev.cobalt.lib.system.SystemBaseLib$lambda$dofile$0;
import org.squiddev.cobalt.lib.system.SystemBaseLib$lambda$print$1;

public class SystemBaseLib {
    private static final LuaString STDIN_STR = ValueFactory.valueOf("=stdin");
    private final ResourceLoader resources;
    private final InputStream in;
    private final PrintStream out;

    public SystemBaseLib(ResourceLoader resources, InputStream in, PrintStream out) {
        this.resources = resources;
        this.in = in;
        this.out = out;
    }

    public void add(LuaState state) {
        RegisteredFunction.bind(state.globals(), new RegisteredFunction[]{RegisteredFunction.of("collectgarbage", SystemBaseLib::collectgarbage), RegisteredFunction.ofV("loadfile", this::loadfile), RegisteredFunction.ofS("dofile", this::dofile), RegisteredFunction.ofS("print", this::print)});
    }

    private static LuaValue collectgarbage(LuaState state, LuaValue arg1, LuaValue arg2) throws LuaError {
        String s;
        switch (s = arg1.optString("collect")) {
            case "collect": {
                System.gc();
                return Constants.ZERO;
            }
            case "count": {
                Runtime rt = Runtime.getRuntime();
                long used = rt.totalMemory() - rt.freeMemory();
                return ValueFactory.valueOf((double)used / 1024.0);
            }
            case "step": {
                System.gc();
                return Constants.TRUE;
            }
        }
        throw ErrorFactory.argError(1, "invalid option");
    }

    private Varargs loadfile(LuaState state, Varargs args) throws LuaError {
        return args.first().isNil() ? SystemBaseLib.loadBasicStream(state, this.in, STDIN_STR) : SystemBaseLib.loadFile(state, this.resources, args.arg(1).checkString());
    }

    private Varargs dofile(LuaState state, DebugFrame di, Varargs args) throws LuaError, UnwindThrowable {
        Varargs v;
        Varargs varargs = v = args.first().isNil() ? SystemBaseLib.loadBasicStream(state, this.in, STDIN_STR) : SystemBaseLib.loadFile(state, this.resources, args.arg(1).checkString());
        if (v.first().isNil()) {
            throw new LuaError(v.arg(2).toString());
        }
        di.state = SystemBaseLib$lambda$dofile$0.make(state, v);
        return (Varargs)((SystemBaseLib$lambda$dofile$0)di.state).call(null);
    }

    private Varargs print(LuaState state, DebugFrame frame, Varargs args) throws LuaError, UnwindThrowable {
        frame.state = SystemBaseLib$lambda$print$1.make(this, state, args);
        return (Varargs)((SystemBaseLib$lambda$print$1)frame.state).call(null);
    }

    private static Varargs loadBasicStream(LuaState state, InputStream is, LuaString chunkName) {
        try {
            return LoadState.load(state, is, chunkName, (LuaValue)state.globals());
        }
        catch (LuaError | CompileException e) {
            return ValueFactory.varargsOf(Constants.NIL, (Varargs)ValueFactory.valueOf(e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Varargs loadFile(LuaState state, ResourceLoader resources, String filename) {
        InputStream is = resources.load(filename);
        if (is == null) {
            return ValueFactory.varargsOf(Constants.NIL, (Varargs)ValueFactory.valueOf("cannot open " + filename + ": No such file or directory"));
        }
        try {
            Varargs varargs = SystemBaseLib.loadBasicStream(state, is, ValueFactory.valueOf("@" + filename));
            return varargs;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    /* synthetic */ Varargs lambda$print$1(LuaState var1_1, Varargs var2_2, Object var3_3) throws LuaError, Pause {
        if (var3_3 == null) {
            v0 = OperationHelper.getTable((LuaState)state, (LuaValue)state.globals(), ValueFactory.valueOf("tostring"));
lbl4:
            // 2 sources

            while (true) {
                tostring = v0;
                n = args.count();
                block9: for (i = 1; i <= n; ++i) {
                    if (i > 1) {
                        this.out.write(9);
                    }
                    v1 = Dispatch.call((LuaState)state, tostring, args.arg(i));
lbl12:
                    // 2 sources

                    while (true) {
                        value = v1;
                        s = value.checkLuaString();
                        z = s.indexOf((byte)0);
                        len = z >= 0 ? z : s.length();
                        bytes = new byte[len];
                        s.copyTo(0, bytes, 0, len);
                        this.out.write(bytes, 0, len);
                        continue block9;
                        break;
                    }
                }
                this.out.println();
                return Constants.NONE;
            }
        }
        var3_3 = (UnwindState$L4O4)var3_3;
        switch (var3_3.state) {
            default: {
                throw new IllegalStateException("Resuming into unknown state");
            }
            case 0: {
                var1_1 = (LuaState)var3_3.o0;
                var2_2 = (Varargs)var3_3.o1;
                var3_3.resumeArgs = null;
                v0 = var3_3.resumeArgs.first();
                ** continue;
            }
            case 1: 
        }
        var1_1 = (LuaState)var3_3.o0;
        var2_2 = (Varargs)var3_3.o1;
        var4_4 = (LuaValue)var3_3.o2;
        var5_5 = (int)var3_3.l0;
        var6_6 = (int)var3_3.l1;
        var3_3.resumeArgs = null;
        v1 = var3_3.resumeArgs.first();
        ** while (true)
        catch (UnwindThrowable v2) {
            var3_3 = UnwindState$L4O4.getOrCreate(var3_3);
            var3_3.state = 0;
            var3_3.o0 = var1_1;
            var3_3.o1 = var2_2;
            throw new Pause(v2, (UnwindState)var3_3);
        }
        catch (UnwindThrowable v3) {
            var3_3 = UnwindState$L4O4.getOrCreate(var3_3);
            var3_3.state = 1;
            var3_3.o0 = var1_1;
            var3_3.o1 = var2_2;
            var3_3.o2 = var4_4;
            var3_3.l0 = var5_5;
            var3_3.l1 = var6_6;
            throw new Pause(v3, (UnwindState)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* synthetic */ Varargs lambda$dofile$0(LuaState luaState, Varargs varargs, Object object) throws LuaError, Pause {
        Varargs varargs2;
        if (object == null) {
            try {
                void v;
                LuaState state;
                varargs2 = Dispatch.invoke(state, v.first(), Constants.NONE);
                return varargs2;
            }
            catch (UnwindThrowable unwindThrowable) {
                object = UnwindState.getOrCreate(object);
                ((UnwindState)object).state = 0;
                throw new Pause(unwindThrowable, (UnwindState)object);
            }
        }
        object = (UnwindState)object;
        if (((UnwindState)object).state != 0) {
            throw new IllegalStateException("Resuming into unknown state");
        }
        varargs2 = ((UnwindState)object).resumeArgs;
        ((UnwindState)object).resumeArgs = null;
        return varargs2;
    }
}

