/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.lib;

import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaThread;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.UnwindThrowable;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.debug.DebugFrame;
import org.squiddev.cobalt.function.LibFunction;
import org.squiddev.cobalt.function.LuaFunction;
import org.squiddev.cobalt.function.RegisteredFunction;
import org.squiddev.cobalt.function.ResumableVarArgFunction;

public final class CoroutineLib {
    private CoroutineLib() {
    }

    public static void add(LuaState state) throws LuaError {
        LibFunction.setGlobalLibrary(state, "coroutine", RegisteredFunction.bind(new RegisteredFunction[]{RegisteredFunction.of("create", CoroutineLib::create), RegisteredFunction.ofV("running", CoroutineLib::running), RegisteredFunction.of("status", CoroutineLib::status), RegisteredFunction.of("isyieldable", CoroutineLib::isyieldable), RegisteredFunction.of("wrap", CoroutineLib::wrap), RegisteredFunction.ofFactory("resume", Resume::new), RegisteredFunction.ofFactory("yield", Yield::new)}));
    }

    private static LuaValue create(LuaState state, LuaValue arg) throws LuaError {
        LuaFunction func = arg.checkFunction();
        return new LuaThread(state, func);
    }

    private static Varargs running(LuaState state, Varargs args) {
        LuaThread r = state.getCurrentThread();
        return ValueFactory.varargsOf((LuaValue)r, (Varargs)ValueFactory.valueOf(r.isMainThread()));
    }

    private static LuaValue status(LuaState state, LuaValue arg) throws LuaError {
        return arg.checkThread().getStatus().getDisplayNameValue();
    }

    private static LuaValue isyieldable(LuaState state, LuaValue arg) throws LuaError {
        return ValueFactory.valueOf(!arg.optThread(state.getCurrentThread()).isMainThread());
    }

    private static LuaValue wrap(LuaState state, LuaValue arg) throws LuaError {
        LuaFunction func = arg.checkFunction();
        LuaThread thread = new LuaThread(state, func);
        return new Wrapped(thread);
    }

    private static class Wrapped
    extends ResumableVarArgFunction<Void> {
        private final LuaThread thread;

        private Wrapped(LuaThread thread) {
            this.thread = thread;
        }

        @Override
        protected Varargs invoke(LuaState state, DebugFrame di, Varargs args) throws LuaError, UnwindThrowable {
            return (Varargs)LuaThread.resume(state, this.thread, args);
        }

        @Override
        public Varargs resume(LuaState state, Void object, Varargs value) {
            return value;
        }
    }

    private static class Yield
    extends ResumableVarArgFunction<Void> {
        private Yield() {
        }

        @Override
        protected Varargs invoke(LuaState state, DebugFrame di, Varargs args) throws LuaError, UnwindThrowable {
            return (Varargs)LuaThread.yield(state, args);
        }

        @Override
        public Varargs resume(LuaState state, Void object, Varargs value) {
            return value;
        }
    }

    private static class Resume
    extends ResumableVarArgFunction<Void> {
        private Resume() {
        }

        @Override
        protected Varargs invoke(LuaState state, DebugFrame di, Varargs args) throws LuaError, UnwindThrowable {
            di.flags |= 8;
            LuaThread thread = args.arg(1).checkThread();
            try {
                Varargs result = (Varargs)LuaThread.resume(state, thread, args.subargs(2));
                return ValueFactory.varargsOf((LuaValue)Constants.TRUE, result);
            }
            catch (LuaError le) {
                return ValueFactory.varargsOf((LuaValue)Constants.FALSE, (Varargs)le.getValue());
            }
        }

        @Override
        public Varargs resume(LuaState state, Void object, Varargs value) {
            return ValueFactory.varargsOf((LuaValue)Constants.TRUE, value);
        }

        @Override
        public Varargs resumeError(LuaState state, Void object, LuaError error) {
            return ValueFactory.varargsOf((LuaValue)Constants.FALSE, (Varargs)error.getValue());
        }
    }
}

