/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.function;

import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.Lua;
import org.squiddev.cobalt.LuaDouble;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaNumber;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.OperationHelper;
import org.squiddev.cobalt.Print;
import org.squiddev.cobalt.Prototype;
import org.squiddev.cobalt.UnwindThrowable;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.debug.DebugFrame;
import org.squiddev.cobalt.debug.DebugState;
import org.squiddev.cobalt.debug.Upvalue;
import org.squiddev.cobalt.function.Dispatch;
import org.squiddev.cobalt.function.LuaClosure;
import org.squiddev.cobalt.function.LuaFunction;
import org.squiddev.cobalt.function.LuaInterpretedFunction;

final class LuaInterpreter {
    private LuaInterpreter() {
    }

    private static LuaValue[] createStack(Prototype prototype) {
        LuaValue[] stack = new LuaValue[prototype.maxStackSize];
        System.arraycopy(Constants.NILS, 0, stack, 0, prototype.maxStackSize);
        return stack;
    }

    public static void setupCall(DebugState ds, DebugFrame frame, LuaInterpretedFunction function, int flags) throws UnwindThrowable, LuaError {
        Prototype p = function.p;
        LuaValue[] stack = LuaInterpreter.createStack(p);
        LuaInterpreter.setupFrame(ds, frame, function, Constants.NONE, stack, flags);
    }

    public static void setupCall(DebugState ds, DebugFrame frame, LuaInterpretedFunction function, LuaValue arg, int flags) throws LuaError, UnwindThrowable {
        Prototype p = function.p;
        LuaValue[] stack = LuaInterpreter.createStack(p);
        switch (p.parameters) {
            case 0: {
                LuaInterpreter.setupFrame(ds, frame, function, arg, stack, flags);
                break;
            }
            default: {
                stack[0] = arg;
                LuaInterpreter.setupFrame(ds, frame, function, Constants.NONE, stack, flags);
            }
        }
    }

    public static void setupCall(DebugState ds, DebugFrame frame, LuaInterpretedFunction function, LuaValue arg1, LuaValue arg2, int flags) throws LuaError, UnwindThrowable {
        Prototype p = function.p;
        LuaValue[] stack = LuaInterpreter.createStack(p);
        switch (p.parameters) {
            case 0: {
                LuaInterpreter.setupFrame(ds, frame, function, p.isVarArg ? ValueFactory.varargsOf(arg1, (Varargs)arg2) : Constants.NONE, stack, flags);
                break;
            }
            case 1: {
                stack[0] = arg1;
                LuaInterpreter.setupFrame(ds, frame, function, arg2, stack, flags);
                break;
            }
            default: {
                stack[0] = arg1;
                stack[1] = arg2;
                LuaInterpreter.setupFrame(ds, frame, function, Constants.NONE, stack, flags);
            }
        }
    }

    public static void setupCall(DebugState ds, DebugFrame frame, LuaInterpretedFunction function, LuaValue arg1, LuaValue arg2, LuaValue arg3, int flags) throws LuaError, UnwindThrowable {
        Prototype p = function.p;
        LuaValue[] stack = LuaInterpreter.createStack(p);
        switch (p.parameters) {
            case 0: {
                LuaInterpreter.setupFrame(ds, frame, function, p.isVarArg ? ValueFactory.varargsOf(arg1, arg2, (Varargs)arg3) : Constants.NONE, stack, flags);
                break;
            }
            case 1: {
                stack[0] = arg1;
                LuaInterpreter.setupFrame(ds, frame, function, p.isVarArg ? ValueFactory.varargsOf(arg2, (Varargs)arg3) : Constants.NONE, stack, flags);
                break;
            }
            case 2: {
                stack[0] = arg1;
                stack[1] = arg2;
                LuaInterpreter.setupFrame(ds, frame, function, arg3, stack, flags);
                break;
            }
            default: {
                stack[0] = arg1;
                stack[1] = arg2;
                stack[2] = arg3;
                LuaInterpreter.setupFrame(ds, frame, function, Constants.NONE, stack, flags);
            }
        }
    }

    private static Varargs setupStack(Prototype prototype, LuaValue[] stack, LuaValue[] args, int argsStart, int argsSize) {
        System.arraycopy(args, argsStart, stack, 0, Math.min(argsSize, prototype.parameters));
        return prototype.isVarArg && argsSize > prototype.parameters ? ValueFactory.varargsOfCopy(args, argsStart + prototype.parameters, argsSize - prototype.parameters) : Constants.NONE;
    }

    private static Varargs setupStack(Prototype prototype, LuaValue[] stack, Varargs varargs) {
        for (int i = 0; i < prototype.parameters; ++i) {
            stack[i] = varargs.arg(i + 1);
        }
        return prototype.isVarArg ? varargs.subargs(prototype.parameters + 1) : Constants.NONE;
    }

    static void setupCall(DebugState ds, DebugFrame frame, LuaInterpretedFunction function, Varargs varargs, int flags) throws LuaError, UnwindThrowable {
        Prototype p = function.p;
        LuaValue[] stack = LuaInterpreter.createStack(p);
        Varargs args = LuaInterpreter.setupStack(p, stack, varargs);
        LuaInterpreter.setupFrame(ds, frame, function, args, stack, flags);
    }

    private static void setupFrame(DebugState ds, DebugFrame di, LuaClosure function, Varargs varargs, LuaValue[] stack, int flags) throws UnwindThrowable, LuaError {
        di.func = function;
        di.closure = function;
        di.varargs = varargs;
        di.stack = stack;
        di.flags |= flags;
        di.extras = Constants.NONE;
        di.pc = 0;
        di.top = 0;
        ds.onCall(di);
    }

    private static int luaO_fb2int(int x) {
        int e = x >> 3 & 0x1F;
        if (e == 0) {
            return x;
        }
        return (x & 7) + 8 << e - 1;
    }

    static Varargs execute(LuaState state, DebugFrame di, LuaInterpretedFunction function) throws LuaError, UnwindThrowable {
        DebugState ds = DebugState.get(state);
        block45: while (true) {
            Prototype p = function.p;
            Upvalue[] upvalues = function.upvalues;
            int[] code = p.code;
            LuaValue[] k = p.constants;
            LuaValue[] stack = di.stack;
            Varargs varargs = di.varargs;
            int pc = di.pc;
            block46: while (true) {
                di.pc = ++pc;
                if (state.isInterrupted()) {
                    state.handleInterrupt();
                }
                ds.onInstruction(di, pc);
                int i = code[pc++];
                int a = Lua.GETARG_A(i);
                switch (Lua.GET_OPCODE(i)) {
                    case 0: {
                        stack[a] = stack[Lua.GETARG_B(i)];
                        break;
                    }
                    case 1: {
                        stack[a] = k[Lua.GETARG_Bx(i)];
                        break;
                    }
                    case 2: {
                        assert (Lua.GET_OPCODE(code[pc]) == 39);
                        int rb = Lua.GETARG_Ax(code[pc++]);
                        stack[a] = k[rb];
                        break;
                    }
                    case 3: {
                        LuaValue luaValue = stack[a] = Lua.GETARG_B(i) != 0 ? Constants.TRUE : Constants.FALSE;
                        if (Lua.GETARG_C(i) == 0) continue block46;
                        break;
                    }
                    case 4: {
                        int b = Lua.GETARG_B(i);
                        do {
                            stack[a++] = Constants.NIL;
                        } while (b-- > 0);
                        break;
                    }
                    case 5: {
                        stack[a] = upvalues[Lua.GETARG_B(i)].getValue();
                        break;
                    }
                    case 6: {
                        int b = Lua.GETARG_B(i);
                        int c = Lua.GETARG_C(i);
                        stack[a] = OperationHelper.getTable(state, upvalues[b].getValue(), LuaInterpreter.getRK(stack, k, c), -b - 1);
                        break;
                    }
                    case 7: {
                        int b = Lua.GETARG_B(i);
                        int c = Lua.GETARG_C(i);
                        stack[a] = OperationHelper.getTable(state, stack[b], LuaInterpreter.getRK(stack, k, c), b);
                        break;
                    }
                    case 8: {
                        int b = Lua.GETARG_B(i);
                        int c = Lua.GETARG_C(i);
                        OperationHelper.setTable(state, upvalues[a].getValue(), LuaInterpreter.getRK(stack, k, b), LuaInterpreter.getRK(stack, k, c), -b - 1);
                        break;
                    }
                    case 9: {
                        upvalues[Lua.GETARG_B(i)].setValue(stack[a]);
                        break;
                    }
                    case 10: {
                        int b = Lua.GETARG_B(i);
                        int c = Lua.GETARG_C(i);
                        OperationHelper.setTable(state, stack[a], LuaInterpreter.getRK(stack, k, b), LuaInterpreter.getRK(stack, k, c), a);
                        break;
                    }
                    case 11: {
                        stack[a] = new LuaTable(LuaInterpreter.luaO_fb2int(Lua.GETARG_B(i)), LuaInterpreter.luaO_fb2int(Lua.GETARG_C(i)));
                        break;
                    }
                    case 12: {
                        int b = Lua.GETARG_B(i);
                        int c = Lua.GETARG_C(i);
                        LuaValue luaValue = stack[b];
                        stack[a + 1] = luaValue;
                        LuaValue o = luaValue;
                        stack[a] = OperationHelper.getTable(state, o, LuaInterpreter.getRK(stack, k, c), b);
                        break;
                    }
                    case 13: {
                        int b = Lua.GETARG_B(i);
                        int c = Lua.GETARG_C(i);
                        stack[a] = OperationHelper.add(state, LuaInterpreter.getRK(stack, k, b), LuaInterpreter.getRK(stack, k, c));
                        break;
                    }
                    case 14: {
                        int b = Lua.GETARG_B(i);
                        int c = Lua.GETARG_C(i);
                        stack[a] = OperationHelper.sub(state, LuaInterpreter.getRK(stack, k, b), LuaInterpreter.getRK(stack, k, c));
                        break;
                    }
                    case 15: {
                        int b = Lua.GETARG_B(i);
                        int c = Lua.GETARG_C(i);
                        stack[a] = OperationHelper.mul(state, LuaInterpreter.getRK(stack, k, b), LuaInterpreter.getRK(stack, k, c));
                        break;
                    }
                    case 16: {
                        int b = Lua.GETARG_B(i);
                        int c = Lua.GETARG_C(i);
                        stack[a] = OperationHelper.div(state, LuaInterpreter.getRK(stack, k, b), LuaInterpreter.getRK(stack, k, c));
                        break;
                    }
                    case 17: {
                        int b = Lua.GETARG_B(i);
                        int c = Lua.GETARG_C(i);
                        stack[a] = OperationHelper.mod(state, LuaInterpreter.getRK(stack, k, b), LuaInterpreter.getRK(stack, k, c));
                        break;
                    }
                    case 18: {
                        int b = Lua.GETARG_B(i);
                        int c = Lua.GETARG_C(i);
                        stack[a] = OperationHelper.pow(state, LuaInterpreter.getRK(stack, k, b), LuaInterpreter.getRK(stack, k, c));
                        break;
                    }
                    case 19: {
                        int b = Lua.GETARG_B(i);
                        stack[a] = OperationHelper.neg(state, LuaInterpreter.getRK(stack, k, b));
                        break;
                    }
                    case 20: {
                        stack[a] = stack[Lua.GETARG_B(i)].toBoolean() ? Constants.FALSE : Constants.TRUE;
                        break;
                    }
                    case 21: {
                        int b = Lua.GETARG_B(i);
                        stack[a] = OperationHelper.length(state, stack[b]);
                        break;
                    }
                    case 22: {
                        int b = Lua.GETARG_B(i);
                        int c = Lua.GETARG_C(i);
                        di.top = c + 1;
                        LuaInterpreter.concat(state, di, stack, di.top, c - b + 1);
                        stack[a] = stack[b];
                        di.top = b;
                        break;
                    }
                    case 23: {
                        pc += LuaInterpreter.doJump(di, i, 0);
                        break;
                    }
                    case 24: {
                        int b = Lua.GETARG_B(i);
                        int c = Lua.GETARG_C(i);
                        if (OperationHelper.eq(state, LuaInterpreter.getRK(stack, k, b), LuaInterpreter.getRK(stack, k, c)) == (a != 0)) {
                            pc += LuaInterpreter.doJump(di, code[pc], 1);
                            break;
                        }
                        ++pc;
                        break;
                    }
                    case 25: {
                        int b = Lua.GETARG_B(i);
                        int c = Lua.GETARG_C(i);
                        if (OperationHelper.lt(state, LuaInterpreter.getRK(stack, k, b), LuaInterpreter.getRK(stack, k, c)) == (a != 0)) {
                            pc += LuaInterpreter.doJump(di, code[pc], 1);
                            break;
                        }
                        ++pc;
                        break;
                    }
                    case 26: {
                        int b = Lua.GETARG_B(i);
                        int c = Lua.GETARG_C(i);
                        if (OperationHelper.le(state, LuaInterpreter.getRK(stack, k, b), LuaInterpreter.getRK(stack, k, c)) == (a != 0)) {
                            pc += LuaInterpreter.doJump(di, code[pc], 1);
                            break;
                        }
                        ++pc;
                        break;
                    }
                    case 27: {
                        if (stack[a].toBoolean() == (Lua.GETARG_C(i) != 0)) {
                            pc += LuaInterpreter.doJump(di, code[pc], 1);
                            break;
                        }
                        ++pc;
                        break;
                    }
                    case 28: {
                        int b = Lua.GETARG_B(i);
                        int c = Lua.GETARG_C(i);
                        LuaValue val = stack[b];
                        if (val.toBoolean() == (c != 0)) {
                            stack[a] = val;
                            pc += LuaInterpreter.doJump(di, code[pc], 1);
                            break;
                        }
                        ++pc;
                        break;
                    }
                    case 29: {
                        int b = Lua.GETARG_B(i);
                        int c = Lua.GETARG_C(i);
                        LuaValue val = stack[a];
                        if (val instanceof LuaInterpretedFunction) {
                            function = (LuaInterpretedFunction)val;
                            Prototype newPrototype = function.p;
                            LuaValue[] newStack = LuaInterpreter.createStack(newPrototype);
                            DebugFrame newFrame = ds.pushInfo();
                            Varargs args = b > 0 ? LuaInterpreter.setupStack(newPrototype, newStack, stack, a + 1, b - 1) : LuaInterpreter.setupStack(newPrototype, newStack, ValueFactory.varargsOfCopy(stack, a + 1, di.top - di.extras.count() - (a + 1), di.extras));
                            LuaInterpreter.setupFrame(ds, newFrame, function, args, newStack, 0);
                            di = newFrame;
                            continue block45;
                        }
                        LuaInterpreter.nativeCall(state, di, stack, val, i, a, b, c);
                        break;
                    }
                    case 30: {
                        LuaFunction functionVal;
                        Varargs args;
                        int b = Lua.GETARG_B(i);
                        LuaValue val = stack[a];
                        switch (b) {
                            case 1: {
                                args = Constants.NONE;
                                break;
                            }
                            case 2: {
                                args = stack[a + 1];
                                break;
                            }
                            default: {
                                Varargs v = di.extras;
                                Varargs varargs2 = args = b > 0 ? ValueFactory.varargsOfCopy(stack, a + 1, b - 1) : ValueFactory.varargsOfCopy(stack, a + 1, di.top - v.count() - (a + 1), v);
                            }
                        }
                        if (val instanceof LuaFunction) {
                            LuaFunction func;
                            functionVal = func = (LuaFunction)val;
                        } else {
                            functionVal = Dispatch.getCallMetamethod(state, val, a);
                            args = ValueFactory.varargsOf(val, args);
                        }
                        if (functionVal instanceof LuaInterpretedFunction) {
                            int flags = di.flags;
                            di.cleanup();
                            ds.popInfo();
                            function = (LuaInterpretedFunction)functionVal;
                            di = (flags & 2) != 0 ? ds.pushJavaInfo() : ds.pushInfo();
                            LuaInterpreter.setupCall(ds, di, function, args, flags & 2 | 4);
                            continue block45;
                        }
                        Varargs v = Dispatch.invoke(state, functionVal, args);
                        di.top = a + v.count();
                        di.extras = v;
                        break;
                    }
                    case 31: {
                        Varargs ret;
                        int b = Lua.GETARG_B(i);
                        int flags = di.flags;
                        int top = di.top;
                        Varargs v = di.extras;
                        di.cleanup();
                        Varargs varargs3 = ret = b > 0 ? ValueFactory.varargsOfCopy(stack, a, b - 1) : ValueFactory.varargsOfCopy(stack, a, top - v.count() - a, v);
                        if ((flags & 2) != 0) {
                            return ret;
                        }
                        ds.onReturn(di, ret);
                        di = ds.getStackUnsafe();
                        function = (LuaInterpretedFunction)di.func;
                        LuaInterpreter.resume(state, di, function, ret);
                        continue block45;
                    }
                    case 32: {
                        double limit = stack[a + 1].checkDouble();
                        double step = stack[a + 2].checkDouble();
                        double value = stack[a].checkDouble();
                        double idx = step + value;
                        if (!(0.0 < step ? idx <= limit : limit <= idx)) continue block46;
                        stack[a + 3] = stack[a] = LuaDouble.valueOf(idx);
                        pc += Lua.GETARG_sBx(i);
                        break;
                    }
                    case 33: {
                        LuaNumber init = stack[a].checkNumber("'for' initial value must be a number");
                        LuaNumber limit = stack[a + 1].checkNumber("'for' limit must be a number");
                        LuaNumber step = stack[a + 2].checkNumber("'for' step must be a number");
                        stack[a] = LuaDouble.valueOf(init.toDouble() - step.toDouble());
                        stack[a + 1] = limit;
                        stack[a + 2] = step;
                        pc += Lua.GETARG_sBx(i);
                        break;
                    }
                    case 34: {
                        Varargs result = Dispatch.invoke(state, stack[a], ValueFactory.varargsOf(stack[a + 1], (Varargs)stack[a + 2]), a);
                        for (int c = Lua.GETARG_C(i); c >= 1; --c) {
                            stack[a + 2 + c] = result.arg(c);
                        }
                        i = code[pc++];
                        a = Lua.GETARG_A(i);
                        assert (Lua.GET_OPCODE(i) == 35);
                    }
                    case 35: {
                        LuaValue value = stack[a + 1];
                        if (value.isNil()) continue block46;
                        stack[a] = value;
                        pc += Lua.GETARG_sBx(i);
                        break;
                    }
                    case 36: {
                        int b = Lua.GETARG_B(i);
                        int c = Lua.GETARG_C(i);
                        if (c == 0) {
                            c = Lua.GETARG_Ax(code[pc++]);
                        }
                        int offset = (c - 1) * 50;
                        LuaTable tbl = stack[a].checkTable();
                        if (b == 0) {
                            int j;
                            b = di.top - a - 1;
                            int m = b - di.extras.count();
                            tbl.presize(offset + b);
                            for (j = 1; j <= m; ++j) {
                                tbl.rawset(offset + j, stack[a + j]);
                            }
                            while (true) {
                                if (j > b) continue block46;
                                tbl.rawset(offset + j, di.extras.arg(j - m));
                                ++j;
                            }
                        }
                        tbl.presize(offset + b);
                        int j = 1;
                        while (true) {
                            if (j > b) continue block46;
                            tbl.rawset(offset + j, stack[a + j]);
                            ++j;
                        }
                    }
                    case 37: {
                        Prototype newp = p.children[Lua.GETARG_Bx(i)];
                        LuaInterpretedFunction newcl = new LuaInterpretedFunction(newp);
                        int nup = newp.upvalues();
                        for (int j = 0; j < nup; ++j) {
                            Prototype.UpvalueInfo up = newp.getUpvalue(j);
                            newcl.upvalues[j] = up.fromLocal() ? di.getUpvalue(up.index()) : upvalues[up.index()];
                        }
                        stack[a] = newcl;
                        break;
                    }
                    case 38: {
                        int b = Lua.GETARG_B(i);
                        if (b == 0) {
                            di.top = a + varargs.count();
                            di.extras = varargs;
                            break;
                        }
                        int j = 1;
                        while (true) {
                            if (j >= b) continue block46;
                            stack[a + j - 1] = varargs.arg(j);
                            ++j;
                        }
                    }
                    default: {
                        assert (false) : "Unknown opcode";
                        throw new IllegalStateException("Unknown opcode");
                    }
                }
            }
            break;
        }
    }

    private static LuaValue getRK(LuaValue[] stack, LuaValue[] k, int slot) {
        return Lua.ISK(slot) ? k[Lua.INDEXK(slot)] : stack[slot];
    }

    private static int doJump(DebugFrame frame, int i, int e) {
        int a = Lua.GETARG_A(i);
        if (a > 0) {
            frame.closeUpvalues(a - 1);
        }
        return Lua.GETARG_sBx(i) + e;
    }

    private static void nativeCall(LuaState state, DebugFrame di, LuaValue[] stack, LuaValue val, int i, int a, int b, int c) throws UnwindThrowable, LuaError {
        switch (i & 0xFFFFC000) {
            case 0x800000: {
                Varargs v = di.extras = Dispatch.invoke(state, val, Constants.NONE, a);
                di.top = a + v.count();
                break;
            }
            case 0x1000000: {
                Varargs v = di.extras = Dispatch.invoke(state, val, stack[a + 1], a);
                di.top = a + v.count();
                break;
            }
            case 0x804000: {
                Dispatch.call(state, val, a);
                break;
            }
            case 0x1004000: {
                Dispatch.call(state, val, stack[a + 1], a);
                break;
            }
            case 25182208: {
                Dispatch.call(state, val, stack[a + 1], stack[a + 2], a);
                break;
            }
            case 0x2004000: {
                Dispatch.call(state, val, stack[a + 1], stack[a + 2], stack[a + 3], a);
                break;
            }
            case 0x808000: {
                stack[a] = Dispatch.call(state, val, a);
                break;
            }
            case 0x1008000: {
                stack[a] = Dispatch.call(state, val, stack[a + 1], a);
                break;
            }
            case 0x1808000: {
                stack[a] = Dispatch.call(state, val, stack[a + 1], stack[a + 2], a);
                break;
            }
            case 0x2008000: {
                stack[a] = Dispatch.call(state, val, stack[a + 1], stack[a + 2], stack[a + 3], a);
                break;
            }
            default: {
                Varargs args = b > 0 ? ValueFactory.varargsOfCopy(stack, a + 1, b - 1) : ValueFactory.varargsOfCopy(stack, a + 1, di.top - di.extras.count() - (a + 1), di.extras);
                Varargs v = Dispatch.invoke(state, val, args, a);
                if (c > 0) {
                    while (--c > 0) {
                        stack[a + c - 1] = v.arg(c);
                    }
                    break;
                }
                di.top = a + v.count();
                di.extras = v;
            }
        }
    }

    private static void concat(LuaState state, DebugFrame frame, LuaValue[] stack, int top, int total) throws LuaError, UnwindThrowable {
        try {
            int n;
            do {
                LuaValue left = stack[top - 2];
                LuaValue right = stack[top - 1];
                if (!left.isString() || !right.isString()) {
                    stack[top - 2] = OperationHelper.concatNonStrings(state, left, right, top - 2, top - 1);
                } else {
                    LuaString rString = right.checkLuaString();
                    if (rString.length() == 0) {
                        stack[top - 2] = left.checkLuaString();
                    } else {
                        LuaString lString = left.checkLuaString();
                        if (lString.length() == 0) {
                            stack[top - 2] = rString;
                        } else {
                            LuaValue value;
                            int length = rString.length() + lString.length();
                            stack[top - 2] = lString;
                            stack[top - 1] = rString;
                            for (n = 2; n < total && (value = stack[top - n - 1]).isString(); ++n) {
                                LuaString string = value.checkLuaString();
                                int strLen = string.length();
                                if (strLen > Integer.MAX_VALUE - length) {
                                    throw new LuaError("string length overflow");
                                }
                                stack[top - n - 1] = string;
                                length += strLen;
                            }
                            stack[top - n] = LuaString.valueOfStrings(stack, top - n, n, length);
                        }
                    }
                }
                top -= n - 1;
            } while ((total -= n - 1) > 1);
        }
        catch (UnwindThrowable e) {
            frame.top = top;
            throw e;
        }
    }

    public static void resume(LuaState state, DebugFrame di, LuaInterpretedFunction function, Varargs varargs) throws LuaError, UnwindThrowable {
        int pc = di.pc++;
        Prototype p = function.p;
        int i = p.code[pc];
        switch (Lua.GET_OPCODE(i)) {
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                di.stack[Lua.GETARG_A((int)i)] = varargs.first();
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                boolean res = varargs.first().toBoolean();
                if ((di.flags & 0x20) != 0) {
                    res = !res;
                    di.flags ^= 0x20;
                }
                if (res == (Lua.GETARG_A(i) != 0)) {
                    di.pc += Lua.GETARG_sBx(p.code[di.pc]);
                }
                ++di.pc;
                break;
            }
            case 29: 
            case 30: {
                int a = Lua.GETARG_A(i);
                int c = Lua.GETARG_C(i);
                if (c > 0) {
                    LuaValue[] stack = di.stack;
                    while (--c > 0) {
                        stack[a + c - 1] = varargs.arg(c);
                    }
                    di.extras = Constants.NONE;
                    break;
                }
                di.extras = varargs;
                di.top = a + varargs.count();
                break;
            }
            case 8: 
            case 10: {
                break;
            }
            case 34: {
                LuaValue[] stack = di.stack;
                int a = Lua.GETARG_A(i);
                for (int c = Lua.GETARG_C(i); c >= 1; --c) {
                    stack[a + 2 + c] = varargs.arg(c);
                }
                break;
            }
            case 22: {
                int a = Lua.GETARG_A(i);
                int b = Lua.GETARG_B(i);
                LuaValue[] stack = di.stack;
                int top = di.top - 1;
                stack[top - 1] = varargs.first();
                int total = top - b;
                if (total > 1) {
                    --di.pc;
                    LuaInterpreter.concat(state, di, stack, top, total);
                    ++di.pc;
                }
                stack[a] = stack[b];
                di.top = top;
                break;
            }
            default: {
                throw LuaInterpreter.reportIllegalResume(state, function.p, pc);
            }
        }
    }

    private static LuaError reportIllegalResume(LuaState state, Prototype prototype, int pc) {
        LuaError err = new LuaError("cannot resume this opcode");
        state.reportInternalError(err, () -> {
            StringBuilder output = new StringBuilder();
            output.append(String.format("Resuming function at invalid opcode. file=\"%s\", pc=%d\n", prototype.shortSource(), pc + 1));
            Print.printCode(output, prototype, true);
            return output.toString();
        });
        return err;
    }
}

