/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt;

import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.ErrorFactory;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaValue;

public abstract class Varargs {
    Varargs() {
    }

    public abstract LuaValue arg(int var1);

    public abstract int count();

    public abstract LuaValue first();

    public abstract void fill(LuaValue[] var1, int var2);

    public LuaValue checkValue(int i) throws LuaError {
        if (i <= this.count()) {
            return this.arg(i);
        }
        throw ErrorFactory.argError(i, "value expected");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int n = this.count();
        for (int i = 1; i <= n; ++i) {
            if (i > 1) {
                sb.append(",");
            }
            sb.append(this.arg(i));
        }
        sb.append(")");
        return sb.toString();
    }

    public Varargs subargs(int start) {
        int end = this.count();
        return switch (end - start) {
            case 0 -> this.arg(start);
            case 1 -> new LuaValue.PairVarargs(this.arg(start), this.arg(end));
            default -> end < start ? Constants.NONE : new SubVarargs(this, start, end);
        };
    }

    private static class SubVarargs
    extends DepthVarargs {
        private final Varargs v;
        private final int start;
        private final int end;

        public SubVarargs(Varargs varargs, int start, int end) {
            super(SubVarargs.depth(varargs));
            this.v = varargs;
            this.start = start;
            this.end = end;
        }

        @Override
        public LuaValue arg(int i) {
            return (i += this.start - 1) >= this.start && i <= this.end ? this.v.arg(i) : Constants.NIL;
        }

        @Override
        public LuaValue first() {
            return this.v.arg(this.start);
        }

        @Override
        public void fill(LuaValue[] array, int offset) {
            int size = this.end + 1 - this.start;
            for (int i = 0; i < size; ++i) {
                array[offset + i] = this.v.arg(this.start + i);
            }
        }

        @Override
        public int count() {
            return this.end + 1 - this.start;
        }
    }

    protected static abstract class DepthVarargs
    extends Varargs {
        protected final int depth;

        protected DepthVarargs(int depth) {
            this.depth = depth;
        }

        public static int depth(Varargs varargs) {
            return varargs instanceof DepthVarargs ? ((DepthVarargs)varargs).depth : 1;
        }
    }
}

