/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt;

import java.util.Arrays;
import org.squiddev.cobalt.LuaBoolean;
import org.squiddev.cobalt.LuaInteger;
import org.squiddev.cobalt.LuaNil;
import org.squiddev.cobalt.LuaNumber;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.Varargs;

public final class Constants {
    public static final int TINT = -2;
    public static final int TNIL = 0;
    public static final int TBOOLEAN = 1;
    public static final int TLIGHTUSERDATA = 2;
    public static final int TNUMBER = 3;
    public static final int TSTRING = 4;
    public static final int TTABLE = 5;
    public static final int TFUNCTION = 6;
    public static final int TUSERDATA = 7;
    public static final int TTHREAD = 8;
    public static final int TVALUE = 9;
    static final String[] TYPE_NAMES = new String[]{"nil", "boolean", "lightuserdata", "number", "string", "table", "function", "userdata", "thread", "value"};
    static final LuaString[] TYPE_NAMES_LUA = (LuaString[])Arrays.stream(TYPE_NAMES).map(LuaString::valueOf).toArray(LuaString[]::new);
    public static final LuaValue NIL = LuaNil.INSTANCE;
    public static final LuaBoolean TRUE = LuaBoolean._TRUE;
    public static final LuaBoolean FALSE = LuaBoolean._FALSE;
    public static final Varargs NONE = new None();
    public static final LuaNumber ZERO = LuaInteger.valueOf(0);
    public static final LuaNumber ONE = LuaInteger.valueOf(1);
    public static final LuaNumber MINUSONE = LuaInteger.valueOf(-1);
    public static final LuaString NAME = ValueFactory.valueOf("__name");
    public static final LuaString INDEX = ValueFactory.valueOf("__index");
    public static final LuaString NEWINDEX = ValueFactory.valueOf("__newindex");
    public static final LuaString CALL = ValueFactory.valueOf("__call");
    public static final LuaString MODE = ValueFactory.valueOf("__mode");
    public static final LuaString METATABLE = ValueFactory.valueOf("__metatable");
    public static final LuaString ADD = ValueFactory.valueOf("__add");
    public static final LuaString SUB = ValueFactory.valueOf("__sub");
    public static final LuaString DIV = ValueFactory.valueOf("__div");
    public static final LuaString MUL = ValueFactory.valueOf("__mul");
    public static final LuaString POW = ValueFactory.valueOf("__pow");
    public static final LuaString MOD = ValueFactory.valueOf("__mod");
    public static final LuaString UNM = ValueFactory.valueOf("__unm");
    public static final LuaString LEN = ValueFactory.valueOf("__len");
    public static final LuaString EQ = ValueFactory.valueOf("__eq");
    public static final LuaString LT = ValueFactory.valueOf("__lt");
    public static final LuaString LE = ValueFactory.valueOf("__le");
    public static final LuaString TOSTRING = ValueFactory.valueOf("__tostring");
    public static final LuaString CONCAT = ValueFactory.valueOf("__concat");
    public static final LuaString PAIRS = ValueFactory.valueOf("__pairs");
    public static final LuaString EMPTYSTRING = ValueFactory.valueOf("");
    public static final LuaString LOADED = ValueFactory.valueOf("_LOADED");
    public static final LuaString ENV = ValueFactory.valueOf("_ENV");
    public static final int MAXTAGLOOP = 100;
    public static final LuaValue[] NILS = new LuaValue[250];

    private Constants() {
    }

    static {
        Arrays.fill(NILS, NIL);
    }

    private static final class None
    extends Varargs {
        private None() {
        }

        @Override
        public LuaValue arg(int i) {
            return NIL;
        }

        @Override
        public int count() {
            return 0;
        }

        @Override
        public LuaValue first() {
            return NIL;
        }

        @Override
        public String toString() {
            return "none";
        }

        @Override
        public void fill(LuaValue[] array, int offset) {
        }
    }
}

