/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.cobalt.internal.doubles;

import cc.tweaked.cobalt.internal.doubles.Assert;
import cc.tweaked.cobalt.internal.doubles.DiyFp;
import org.checkerframework.checker.signedness.qual.Unsigned;

class Doubles {
    public static final @Unsigned long SIGN_MASK = Long.MIN_VALUE;
    private static final @Unsigned long EXPONENT_MASK = 0x7FF0000000000000L;
    private static final @Unsigned long SIGNIFICAND_MASK = 0xFFFFFFFFFFFFFL;
    public static final @Unsigned long HIDDEN_BIT = 0x10000000000000L;
    public static final int PHYSICAL_SIGNIFICAND_SIZE = 52;
    public static final int SIGNIFICAND_SIZE = 53;
    private static final int EXPONENT_BIAS = 1075;
    private static final int DENORMAL_EXPONENT = -1074;

    private Doubles() {
    }

    @Deprecated
    public static DiyFp asNormalizedDiyFp(long value) {
        throw new IllegalStateException("Call the double version");
    }

    public static DiyFp asNormalizedDiyFp(double value) {
        Assert.requireState(value > 0.0, "instance must be positive");
        @Unsigned long f = Doubles.significand(value);
        int exponent = Doubles.exponent(value);
        while ((f & 0x10000000000000L) == 0L) {
            f <<= 1;
            --exponent;
        }
        return new DiyFp(f <<= 11, exponent -= 11);
    }

    public static int exponent(double v) {
        if (Doubles.isDenormal(v)) {
            return -1074;
        }
        int biasedE = (int)((Doubles.getBits(v) & 0x7FF0000000000000L) >> 52);
        return biasedE - 1075;
    }

    public static @Unsigned long significand(double value) {
        @Unsigned long significand = Doubles.getBits(value) & 0xFFFFFFFFFFFFFL;
        if (!Doubles.isDenormal(value)) {
            return significand + 0x10000000000000L;
        }
        return significand;
    }

    public static boolean isDenormal(@Unsigned long v) {
        return (v & 0x7FF0000000000000L) == 0L;
    }

    public static boolean isDenormal(double v) {
        return Doubles.isDenormal(Doubles.getBits(v));
    }

    public static boolean isSpecial(@Unsigned long value) {
        return (value & 0x7FF0000000000000L) == 0x7FF0000000000000L;
    }

    public static boolean isSpecial(double value) {
        return Doubles.isSpecial(Doubles.getBits(value));
    }

    public static int sign(@Unsigned long value) {
        return (value & Long.MIN_VALUE) == 0L ? 1 : -1;
    }

    public static int sign(double value) {
        return Doubles.sign(Doubles.getBits(value));
    }

    public static @Unsigned long getBits(double value) {
        return Double.doubleToRawLongBits(value);
    }
}

