/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.cobalt.internal.doubles;

import cc.tweaked.cobalt.internal.doubles.Bignum;
import cc.tweaked.cobalt.internal.doubles.DecimalRepBuf;
import cc.tweaked.cobalt.internal.doubles.Doubles;
import org.checkerframework.checker.signedness.qual.Unsigned;

final class BigNumDtoa {
    private static final int ASCII_ZERO = 48;
    private static final int ASCII_NINE = 57;

    BigNumDtoa() {
    }

    private static int normalizedExponent(@Unsigned long significand, int exponent) {
        assert (significand != 0L);
        while ((significand & 0x10000000000000L) == 0L) {
            significand <<= 1;
            --exponent;
        }
        return exponent;
    }

    public static void bignumDtoa(double v, BignumDtoaMode mode, int requestedDigits, DecimalRepBuf buf) {
        assert (v > 0.0);
        assert (!Doubles.isSpecial(v));
        @Unsigned long significand = Doubles.significand(v);
        int exponent = Doubles.exponent(v);
        boolean isEven = (significand & 1L) == 0L;
        int normalizedExponent = BigNumDtoa.normalizedExponent(significand, exponent);
        int estimatePower = BigNumDtoa.estimatePower(normalizedExponent);
        if (mode == BignumDtoaMode.FIXED && -estimatePower - 1 > requestedDigits) {
            buf.clearBuf();
            buf.setPointPosition(-requestedDigits);
            return;
        }
        int[] estimatedPoint = new int[1];
        Bignum numerator = new Bignum();
        Bignum denominator = new Bignum();
        Bignum deltaMinus = new Bignum();
        Bignum deltaPlus = new Bignum();
        BigNumDtoa.initialScaledStartValues(significand, exponent, estimatePower, numerator, denominator);
        BigNumDtoa.fixupMultiply10(estimatePower, isEven, estimatedPoint, numerator, denominator, deltaMinus, deltaPlus);
        buf.setPointPosition(estimatedPoint[0]);
        switch (mode) {
            case FIXED: {
                BigNumDtoa.bignumToFixed(requestedDigits, numerator, denominator, buf);
                break;
            }
            case PRECISION: {
                BigNumDtoa.generateCountedDigits(requestedDigits, numerator, denominator, buf);
                break;
            }
            default: {
                throw new IllegalStateException("Unreachable");
            }
        }
    }

    private static void generateCountedDigits(int count, Bignum numerator, Bignum denominator, DecimalRepBuf buf) {
        assert (count >= 0);
        for (int i = 0; i < count - 1; ++i) {
            @Unsigned int digit = numerator.divideModuloIntBignum(denominator);
            buf.append(digit);
            numerator.times10();
        }
        @Unsigned int digit = numerator.divideModuloIntBignum(denominator);
        buf.append(digit);
        if (Bignum.plusCompare(numerator, numerator, denominator) >= 0) {
            buf.roundUp();
        }
    }

    private static void bignumToFixed(int requestedDigits, Bignum numerator, Bignum denominator, DecimalRepBuf buf) {
        int decimalPoint = buf.getPointPosition();
        if (-decimalPoint > requestedDigits) {
            buf.clearBuf();
            buf.setPointPosition(-requestedDigits);
            return;
        }
        if (-decimalPoint == requestedDigits) {
            assert (decimalPoint == -requestedDigits);
            denominator.times10();
            if (Bignum.plusCompare(numerator, numerator, denominator) >= 0) {
                buf.clearBuf();
                buf.append(1);
                buf.setPointPosition(decimalPoint + 1);
            } else {
                buf.clearBuf();
            }
            return;
        }
        int neededDigits = decimalPoint + requestedDigits;
        BigNumDtoa.generateCountedDigits(neededDigits, numerator, denominator, buf);
    }

    private static int estimatePower(int exponent) {
        double k1Log10 = 0.30102999566398114;
        double estimate = Math.ceil((double)(exponent + 53 - 1) * 0.30102999566398114 - 1.0E-10);
        return (int)estimate;
    }

    private static void initialScaledStartValuesPositiveExponent(@Unsigned long significand, int exponent, int estimatedPower, Bignum numerator, Bignum denominator) {
        assert (estimatedPower >= 0);
        numerator.assignUInt64(significand);
        numerator.shiftLeft(exponent);
        denominator.assignPower(10, estimatedPower);
    }

    private static void initialScaledStartValuesNegativeExponentPositivePower(@Unsigned long ulSignificand, int exponent, int estimatedPower, Bignum numerator, Bignum denominator) {
        numerator.assignUInt64(ulSignificand);
        denominator.assignPower(10, estimatedPower);
        denominator.shiftLeft(-exponent);
    }

    private static void initialScaledStartValuesNegativeExponentNegativePower(@Unsigned long ulSignificand, int exponent, int estimatedPower, Bignum numerator, Bignum denominator) {
        Bignum powerTen = numerator;
        powerTen.assignPower(10, -estimatedPower);
        numerator.multiplyByUInt64(ulSignificand);
        denominator.assignUInt(1);
        denominator.shiftLeft(-exponent);
    }

    private static void initialScaledStartValues(@Unsigned long significand, int exponent, int estimatedPower, Bignum numerator, Bignum denominator) {
        if (exponent >= 0) {
            BigNumDtoa.initialScaledStartValuesPositiveExponent(significand, exponent, estimatedPower, numerator, denominator);
        } else if (estimatedPower >= 0) {
            BigNumDtoa.initialScaledStartValuesNegativeExponentPositivePower(significand, exponent, estimatedPower, numerator, denominator);
        } else {
            BigNumDtoa.initialScaledStartValuesNegativeExponentNegativePower(significand, exponent, estimatedPower, numerator, denominator);
        }
    }

    private static void fixupMultiply10(int estimatedPower, boolean isEven, int[] decimalPoint, Bignum numerator, Bignum denominator, Bignum deltaMinus, Bignum deltaPlus) {
        boolean inRange;
        if (isEven) {
            inRange = Bignum.plusCompare(numerator, deltaPlus, denominator) >= 0;
        } else {
            boolean bl = inRange = Bignum.plusCompare(numerator, deltaPlus, denominator) > 0;
        }
        if (inRange) {
            decimalPoint[0] = estimatedPower + 1;
        } else {
            decimalPoint[0] = estimatedPower;
            numerator.times10();
            if (Bignum.equal(deltaMinus, deltaPlus)) {
                deltaMinus.times10();
                deltaPlus.assignBignum(deltaMinus);
            } else {
                deltaMinus.times10();
                deltaPlus.times10();
            }
        }
    }

    public static enum BignumDtoaMode {
        FIXED,
        PRECISION;

    }
}

