/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.f_tech.machines.abstract_machine;

import dev.architectury.registry.menu.MenuRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3620;
import net.minecraft.class_3917;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import uk.co.cablepost.f_tech.machines.abstract_machine.AbstractMachineBlock;
import uk.co.cablepost.f_tech.machines.abstract_machine.AbstractMachineBlockEntity;
import uk.co.cablepost.f_tech.machines.abstract_machine.AbstractMachineBlockItem;
import uk.co.cablepost.f_tech.machines.abstract_machine.AbstractMachineScreen;
import uk.co.cablepost.f_tech.machines.abstract_machine.AbstractMachineScreenHandler;

public abstract class AbstractMachineInit<MachineBlockType extends AbstractMachineBlock, MachineBlockEntityType extends AbstractMachineBlockEntity, MachineScreenHandlerType extends AbstractMachineScreenHandler, MachineScreenType extends AbstractMachineScreen> {
    protected final String modId;
    protected final String machineId;
    protected final class_2960 identifier;
    protected final class_2960 screenHandlerIdentifier;
    protected final DeferredRegister<class_2248> blocks;
    protected final DeferredRegister<class_1792> items;
    protected final DeferredRegister<class_2591<?>> blockEntities;
    protected final DeferredRegister<class_3917<?>> menus;
    protected final RegistrySupplier<MachineBlockType> block;
    protected final RegistrySupplier<class_1747> item;
    protected final RegistrySupplier<class_2591<MachineBlockEntityType>> blockEntity;
    protected final RegistrySupplier<class_3917<MachineScreenHandlerType>> menu;

    public AbstractMachineInit(String modId, String machineId) {
        this(modId, machineId, class_4970.class_2251.method_9637().method_31710(class_3620.field_16005).method_9626(class_2498.field_11533).method_9632(0.8f).method_22488());
    }

    public AbstractMachineInit(String modId, String machineId, class_4970.class_2251 blockProperties) {
        this.modId = modId;
        this.machineId = machineId;
        this.identifier = new class_2960(modId, machineId);
        this.screenHandlerIdentifier = new class_2960(modId, machineId + "_screen");
        this.blocks = DeferredRegister.create((String)modId, (class_5321)class_7924.field_41254);
        this.items = DeferredRegister.create((String)modId, (class_5321)class_7924.field_41197);
        this.blockEntities = DeferredRegister.create((String)modId, (class_5321)class_7924.field_41255);
        this.menus = DeferredRegister.create((String)modId, (class_5321)class_7924.field_41207);
        this.block = this.blocks.register(machineId, () -> this.createBlock(blockProperties));
        this.item = this.items.register(machineId, () -> this.createBlockItem((AbstractMachineBlock)((Object)((Object)this.block.get())), new class_1792.class_1793()));
        this.blockEntity = this.blockEntities.register(machineId, () -> class_2591.class_2592.method_20528(this.createBlockEntityFactory(), (class_2248[])new class_2248[]{(class_2248)this.block.get()}).method_11034(null));
        this.menu = this.menus.register(machineId + "_screen", () -> MenuRegistry.ofExtended(this.createMenuFactory()));
    }

    protected abstract MachineBlockType createBlock(class_4970.class_2251 var1);

    protected abstract class_2591.class_5559<MachineBlockEntityType> createBlockEntityFactory();

    protected abstract MenuRegistry.ExtendedMenuTypeFactory<MachineScreenHandlerType> createMenuFactory();

    protected class_1747 createBlockItem(MachineBlockType block, class_1792.class_1793 properties) {
        return new AbstractMachineBlockItem((class_2248)block, properties);
    }

    public void register() {
        this.blocks.register();
        this.items.register();
        this.blockEntities.register();
        this.menus.register();
    }

    public void registerScreen(MenuRegistry.ScreenFactory screenFactory) {
        MenuRegistry.registerScreenFactory((class_3917)((class_3917)this.menu.get()), (MenuRegistry.ScreenFactory)screenFactory);
    }

    public String getModId() {
        return this.modId;
    }

    public String getMachineId() {
        return this.machineId;
    }

    public class_2960 getIdentifier() {
        return this.identifier;
    }

    public class_2960 getScreenHandlerIdentifier() {
        return this.screenHandlerIdentifier;
    }

    public RegistrySupplier<MachineBlockType> getBlockSupplier() {
        return this.block;
    }

    public MachineBlockType getBlock() {
        return (MachineBlockType)((Object)((AbstractMachineBlock)((Object)this.block.get())));
    }

    public RegistrySupplier<class_1747> getItemSupplier() {
        return this.item;
    }

    public class_1747 getItem() {
        return (class_1747)this.item.get();
    }

    public RegistrySupplier<class_2591<MachineBlockEntityType>> getBlockEntitySupplier() {
        return this.blockEntity;
    }

    public class_2591<MachineBlockEntityType> getBlockEntity() {
        return (class_2591)this.blockEntity.get();
    }

    public RegistrySupplier<class_3917<MachineScreenHandlerType>> getMenuSupplier() {
        return this.menu;
    }

    public class_3917<MachineScreenHandlerType> getMenu() {
        return (class_3917)this.menu.get();
    }
}

