/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.f_tech.machines.abstract_machine;

import java.util.stream.IntStream;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;
import uk.co.cablepost.f_tech.config.FTechConfig;

public abstract class AbstractMachineBlockEntity
extends class_2586
implements class_3908,
class_1278,
class_1263 {
    public class_2371<class_1799> _inventory;
    public final int[] _inputSlots;
    public final int[] _outputSlots;
    public int _processProgress = 0;
    public final boolean _doProcessing;
    protected final class_3913 _propertyDelegate;
    public long _energyAmount = 0L;
    public final long _energyCapacity;
    public final long _energyMaxInsert;
    public final long _energyMaxExtract;

    public AbstractMachineBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, int[] inputSlots, int[] outputSlots, int energyStorageCapacity, int energyStorageMaxInsert, int energyStorageMaxExtract, boolean doProcessing) {
        super(type, pos, state);
        this._inventory = class_2371.method_10213((int)(inputSlots.length + outputSlots.length), (Object)class_1799.field_8037);
        this._inputSlots = inputSlots;
        this._outputSlots = outputSlots;
        long energyMul = FTechConfig.CONFIG.getOrDefault("f_tech_core.energy_mul", 1);
        if (energyMul <= 0L) {
            energyMul = 1L;
        }
        this._energyCapacity = (long)energyStorageCapacity * energyMul;
        this._energyMaxInsert = (long)energyStorageMaxInsert * energyMul;
        this._energyMaxExtract = (long)energyStorageMaxExtract * energyMul;
        this._doProcessing = doProcessing;
        this._propertyDelegate = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> AbstractMachineBlockEntity.this._processProgress;
                    case 1 -> AbstractMachineBlockEntity.this.getMaxProcessProgress();
                    case 2 -> (int)AbstractMachineBlockEntity.this._energyAmount;
                    case 3 -> (int)AbstractMachineBlockEntity.this._energyCapacity;
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
            }

            public int method_17389() {
                return AbstractMachineBlockEntity.getPropertyDelegateSize();
            }
        };
    }

    public static int getPropertyDelegateSize() {
        return 4;
    }

    public abstract int getMaxProcessProgress();

    public int processEnergyConsumption() {
        return 10 * FTechConfig.CONFIG.getOrDefault("f_tech_core.energy_mul", 1);
    }

    public long receiveEnergy(long amount, boolean simulate) {
        if (amount <= 0L) {
            return 0L;
        }
        long inserted = Math.min(this._energyMaxInsert, Math.min(amount, this._energyCapacity - this._energyAmount));
        if (inserted > 0L && !simulate) {
            this._energyAmount += inserted;
            this.method_5431();
        }
        return inserted;
    }

    public long extractEnergy(long amount, boolean simulate) {
        if (amount <= 0L) {
            return 0L;
        }
        long extracted = Math.min(this._energyMaxExtract, Math.min(amount, this._energyAmount));
        if (extracted > 0L && !simulate) {
            this._energyAmount -= extracted;
            this.method_5431();
        }
        return extracted;
    }

    public void method_11007(class_2487 tag) {
        class_1262.method_5426((class_2487)tag, this._inventory);
        tag.method_10569("ProcessProgress", this._processProgress);
        tag.method_10544("Energy", this._energyAmount);
        super.method_11007(tag);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        class_1262.method_5429((class_2487)tag, this._inventory);
        this._processProgress = tag.method_10550("ProcessProgress");
        this._energyAmount = tag.method_10537("Energy");
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)this.method_11010().method_26204().method_9539());
    }

    public int[] method_5494(class_2350 side) {
        return ArrayUtils.addAll((int[])this._inputSlots, (int[])this._outputSlots);
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return IntStream.of(this._inputSlots).anyMatch(x -> x == slot);
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return IntStream.of(this._outputSlots).anyMatch(x -> x == slot);
    }

    public int method_5439() {
        return this._inventory.size();
    }

    public boolean method_5442() {
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 stack = this.method_5438(i);
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this._inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 result = class_1262.method_5430(this._inventory, (int)slot, (int)amount);
        if (!result.method_7960()) {
            this.method_5431();
        }
        return result;
    }

    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this._inventory, (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this._inventory.set(slot, (Object)stack);
        if (stack.method_7947() > stack.method_7914()) {
            stack.method_7939(stack.method_7914());
        }
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5448() {
        this._inventory.clear();
    }

    public static <MachineBlockEntityType extends AbstractMachineBlockEntity> void serverTick(class_1937 world, class_2338 pos, class_2680 state, MachineBlockEntityType blockEntity) {
        if (world.method_8608()) {
            return;
        }
        long processEnergyConsumption = blockEntity.processEnergyConsumption();
        if (blockEntity._doProcessing && blockEntity._inputSlots.length > 0 && blockEntity._outputSlots.length > 0) {
            if (blockEntity._energyAmount < processEnergyConsumption) {
                if (blockEntity._processProgress > 0) {
                    --blockEntity._processProgress;
                    AbstractMachineBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
                }
                return;
            }
            if (blockEntity.inputsAreValidRecipe() && blockEntity.spaceInOutput()) {
                ++blockEntity._processProgress;
                blockEntity._energyAmount -= processEnergyConsumption;
                if (blockEntity._processProgress >= blockEntity.getMaxProcessProgress()) {
                    blockEntity.doProcess();
                    blockEntity._processProgress = 0;
                }
                AbstractMachineBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
            } else if (blockEntity._processProgress > 0) {
                blockEntity._processProgress = 0;
                AbstractMachineBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
            }
        }
        blockEntity.serverTickExtra();
    }

    public void serverTickExtra() {
    }

    public boolean spaceInOutput() {
        for (int slot : this._outputSlots) {
            if (!this.method_5438(slot).method_7960()) continue;
            return true;
        }
        return false;
    }

    public boolean inputsAreValidRecipe() {
        for (int slot : this._inputSlots) {
            if (this.method_5438(slot).method_7960()) continue;
            return true;
        }
        return false;
    }

    public void doProcess() {
        for (int slot : this._inputSlots) {
            if (this.method_5438(slot).method_7960()) continue;
            this.method_5434(slot, 1);
            break;
        }
        for (int slot : this._outputSlots) {
            if (!this.method_5438(slot).method_7960()) continue;
            this.method_5447(slot, new class_1799((class_1935)class_1802.field_8477, 1));
            break;
        }
    }
}

