/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.f_tech.fabric;

import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2591;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.SimpleEnergyStorage;
import uk.co.cablepost.f_tech.machines.abstract_machine.AbstractMachineBlockEntity;
import uk.co.cablepost.f_tech.machines.machine_shell.MachineShellBlockInit;
import uk.co.cablepost.f_tech.machines.test_machine.TestMachineInit;

public class FabricEnergyCompat {
    public static void register() {
        EnergyStorage.SIDED.registerForBlockEntity((blockEntity, direction) -> FabricEnergyCompat.createEnergyStorage(blockEntity), (class_2591)TestMachineInit.TEST_MACHINE_BLOCK_ENTITY.get());
        EnergyStorage.SIDED.registerForBlockEntity((blockEntity, direction) -> {
            AbstractMachineBlockEntity parent = blockEntity.getParentBlockEntity();
            if (parent != null) {
                return FabricEnergyCompat.createEnergyStorage(parent);
            }
            return null;
        }, (class_2591)MachineShellBlockInit.MACHINE_SHELL_BLOCK_ENTITY.get());
    }

    private static EnergyStorage createEnergyStorage(final AbstractMachineBlockEntity blockEntity) {
        return new SimpleEnergyStorage(blockEntity._energyCapacity, blockEntity._energyMaxInsert, blockEntity._energyMaxExtract){

            public long getAmount() {
                return blockEntity._energyAmount;
            }

            public long insert(long maxAmount, TransactionContext transaction) {
                long inserted = Math.min(this.maxInsert, Math.min(maxAmount, this.capacity - blockEntity._energyAmount));
                if (inserted > 0L) {
                    transaction.addCloseCallback((t, result) -> {
                        if (result.wasCommitted()) {
                            blockEntity2._energyAmount += inserted;
                            blockEntity.method_5431();
                        }
                    });
                }
                return inserted;
            }

            public long extract(long maxAmount, TransactionContext transaction) {
                long extracted = Math.min(this.maxExtract, Math.min(maxAmount, blockEntity._energyAmount));
                if (extracted > 0L) {
                    transaction.addCloseCallback((t, result) -> {
                        if (result.wasCommitted()) {
                            blockEntity2._energyAmount -= extracted;
                            blockEntity.method_5431();
                        }
                    });
                }
                return extracted;
            }
        };
    }
}

