/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.visual;

import dev.engine_room.flywheel.api.visual.BlockEntityVisual;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visual.LightUpdatedVisual;
import dev.engine_room.flywheel.api.visual.SectionTrackedVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.math.MoreMath;
import dev.engine_room.flywheel.lib.visual.AbstractVisual;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Iterator;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_4076;
import net.minecraft.class_761;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.joml.FrustumIntersection;

public abstract class AbstractBlockEntityVisual<T extends class_2586>
extends AbstractVisual
implements BlockEntityVisual<T>,
LightUpdatedVisual {
    protected final T blockEntity;
    protected final class_2338 pos;
    protected final class_2338 visualPos;
    protected final class_2680 blockState;
    protected @UnknownNullability SectionTrackedVisual.SectionCollector lightSections;

    public AbstractBlockEntityVisual(VisualizationContext ctx, T blockEntity, float partialTick) {
        super(ctx, blockEntity.method_10997(), partialTick);
        this.blockEntity = blockEntity;
        this.pos = blockEntity.method_11016();
        this.blockState = blockEntity.method_11010();
        this.visualPos = this.pos.method_10059(ctx.renderOrigin());
    }

    @Override
    public void setSectionCollector(SectionTrackedVisual.SectionCollector sectionCollector) {
        this.lightSections = sectionCollector;
        this.lightSections.sections(LongSet.of((long)class_4076.method_33706((class_2338)this.pos)));
    }

    public class_2338 getVisualPosition() {
        return this.visualPos;
    }

    public boolean isVisible(FrustumIntersection frustum) {
        float x = (float)this.visualPos.method_10263() + 0.5f;
        float y = (float)this.visualPos.method_10264() + 0.5f;
        float z = (float)this.visualPos.method_10260() + 0.5f;
        return frustum.testSphere(x, y, z, MoreMath.SQRT_3_OVER_2);
    }

    public boolean doDistanceLimitThisFrame(DynamicVisual.Context context) {
        return !context.limiter().shouldUpdate(this.pos.method_19770((class_2374)context.camera().method_19326()));
    }

    protected int computePackedLight() {
        return class_761.method_23794((class_1920)this.level, (class_2338)this.pos);
    }

    protected void relight(class_2338 pos, FlatLit ... instances) {
        FlatLit.relight(class_761.method_23794((class_1920)this.level, (class_2338)pos), instances);
    }

    protected void relight(FlatLit ... instances) {
        this.relight(this.pos, instances);
    }

    protected void relight(class_2338 pos, Iterator<@Nullable FlatLit> instances) {
        FlatLit.relight(class_761.method_23794((class_1920)this.level, (class_2338)pos), instances);
    }

    protected void relight(Iterator<@Nullable FlatLit> instances) {
        this.relight(this.pos, instances);
    }

    protected void relight(class_2338 pos, Iterable<@Nullable FlatLit> instances) {
        FlatLit.relight(class_761.method_23794((class_1920)this.level, (class_2338)pos), instances);
    }

    protected void relight(Iterable<@Nullable FlatLit> instances) {
        this.relight(this.pos, instances);
    }
}

