/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.util;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;

public final class RendererReloadCache<T, U>
implements Function<T, U> {
    private static final Set<RendererReloadCache<?, ?>> ALL = Collections.newSetFromMap(new WeakHashMap());
    private final Function<T, U> factory;
    private final Map<T, U> map = new ConcurrentHashMap<T, U>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RendererReloadCache(Function<T, U> factory) {
        this.factory = factory;
        Set<RendererReloadCache<?, ?>> set = ALL;
        synchronized (set) {
            ALL.add(this);
        }
    }

    public final U get(T key) {
        return this.map.computeIfAbsent(key, this.factory);
    }

    @Override
    public final U apply(T t) {
        return this.get(t);
    }

    public final void clear() {
        this.map.clear();
    }

    @ApiStatus.Internal
    public static void onReloadLevelRenderer() {
        for (RendererReloadCache<?, ?> cache : ALL) {
            cache.clear();
        }
    }
}

