/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.model.part;

import dev.engine_room.flywheel.lib.math.DataPacker;
import dev.engine_room.flywheel.lib.memory.MemoryBlock;
import net.minecraft.class_4588;
import org.lwjgl.system.MemoryUtil;

class VertexWriter
implements class_4588 {
    private static final int STRIDE = 23;
    private MemoryBlock data = MemoryBlock.malloc(2944L);
    private int vertexCount;
    private boolean filledPosition;
    private boolean filledTexture;
    private boolean filledNormal;

    public class_4588 method_22912(double x, double y, double z) {
        if (!this.filledPosition) {
            long ptr = this.vertexPtr();
            MemoryUtil.memPutFloat((long)ptr, (float)((float)x));
            MemoryUtil.memPutFloat((long)(ptr + 4L), (float)((float)y));
            MemoryUtil.memPutFloat((long)(ptr + 8L), (float)((float)z));
            this.filledPosition = true;
        }
        return this;
    }

    public class_4588 method_1336(int red, int green, int blue, int alpha) {
        return this;
    }

    public class_4588 method_22913(float u, float v) {
        if (!this.filledTexture) {
            long ptr = this.vertexPtr();
            MemoryUtil.memPutFloat((long)(ptr + 12L), (float)u);
            MemoryUtil.memPutFloat((long)(ptr + 16L), (float)v);
            this.filledTexture = true;
        }
        return this;
    }

    public class_4588 method_22917(int u, int v) {
        return this;
    }

    public class_4588 method_22921(int u, int v) {
        return this;
    }

    public class_4588 method_22914(float x, float y, float z) {
        if (!this.filledNormal) {
            long ptr = this.vertexPtr();
            MemoryUtil.memPutByte((long)(ptr + 20L), (byte)DataPacker.packNormI8(x));
            MemoryUtil.memPutByte((long)(ptr + 21L), (byte)DataPacker.packNormI8(y));
            MemoryUtil.memPutByte((long)(ptr + 22L), (byte)DataPacker.packNormI8(z));
            this.filledNormal = true;
        }
        return this;
    }

    public void method_1344() {
        if (!(this.filledPosition && this.filledTexture && this.filledNormal)) {
            throw new IllegalStateException("Not filled all elements of the vertex");
        }
        this.filledPosition = false;
        this.filledTexture = false;
        this.filledNormal = false;
        ++this.vertexCount;
        long byteSize = (this.vertexCount + 1) * 23;
        long capacity = this.data.size();
        if (byteSize > capacity) {
            this.data = this.data.realloc(capacity * 2L);
        }
    }

    public void method_22901(int red, int green, int blue, int alpha) {
    }

    public void method_35666() {
    }

    private long vertexPtr() {
        return this.data.ptr() + (long)(this.vertexCount * 23);
    }

    public MemoryBlock copyDataAndReset() {
        MemoryBlock dataCopy = MemoryBlock.mallocTracked(this.vertexCount * 23);
        this.data.copyTo(dataCopy);
        this.vertexCount = 0;
        this.filledPosition = false;
        this.filledTexture = false;
        this.filledNormal = false;
        return dataCopy;
    }
}

