/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.model.baked;

import dev.engine_room.flywheel.lib.model.baked.MeshEmitter;
import dev.engine_room.flywheel.lib.model.baked.TransformingVertexConsumer;
import dev.engine_room.flywheel.lib.model.baked.UniversalMeshEmitter;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Iterator;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_778;
import org.jetbrains.annotations.Nullable;

final class BakedModelBufferer {
    static final class_1921[] CHUNK_LAYERS = (class_1921[])class_1921.method_22720().toArray(class_1921[]::new);
    static final int CHUNK_LAYER_AMOUNT = CHUNK_LAYERS.length;
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);

    private BakedModelBufferer() {
    }

    public static void bufferModel(class_1087 model, class_2338 pos, class_1920 level, class_2680 state, @Nullable class_4587 poseStack, ResultConsumer resultConsumer) {
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        if (poseStack == null) {
            poseStack = objects.identityPoseStack;
        }
        class_5819 random = objects.random;
        MeshEmitter[] emitters = objects.emitters;
        UniversalMeshEmitter universalEmitter = objects.universalEmitter;
        for (MeshEmitter emitter : emitters) {
            emitter.prepare(resultConsumer);
        }
        long seed = state.method_26190(pos);
        class_1921 defaultLayer = class_4696.method_23679((class_2680)state);
        universalEmitter.prepare(defaultLayer);
        model = universalEmitter.wrapModel(model);
        poseStack.method_22903();
        class_310.method_1551().method_1541().method_3350().method_3374(level, model, state, pos, poseStack, (class_4588)universalEmitter, false, random, seed, class_4608.field_21444);
        poseStack.method_22909();
        universalEmitter.clear();
        for (MeshEmitter emitter : emitters) {
            emitter.end();
        }
    }

    public static void bufferBlocks(Iterator<class_2338> posIterator, class_1920 level, @Nullable class_4587 poseStack, boolean renderFluids, ResultConsumer resultConsumer) {
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        if (poseStack == null) {
            poseStack = objects.identityPoseStack;
        }
        class_5819 random = objects.random;
        MeshEmitter[] emitters = objects.emitters;
        Reference2ReferenceMap<class_1921, MeshEmitter> emitterMap = objects.emitterMap;
        UniversalMeshEmitter universalEmitter = objects.universalEmitter;
        TransformingVertexConsumer transformingWrapper = objects.transformingWrapper;
        for (MeshEmitter emitter : emitters) {
            emitter.prepare(resultConsumer);
        }
        class_776 renderDispatcher = class_310.method_1551().method_1541();
        class_778 blockRenderer = renderDispatcher.method_3350();
        class_778.method_20544();
        while (posIterator.hasNext()) {
            class_3610 fluidState;
            class_2338 pos = posIterator.next();
            class_2680 state = level.method_8320(pos);
            if (renderFluids && !(fluidState = state.method_26227()).method_15769()) {
                class_1921 renderType = class_4696.method_23680((class_3610)fluidState);
                transformingWrapper.prepare((class_4588)((MeshEmitter)emitterMap.get((Object)renderType)).getBuffer(true), poseStack);
                poseStack.method_22903();
                poseStack.method_46416((float)(pos.method_10263() - (pos.method_10263() & 0xF)), (float)(pos.method_10264() - (pos.method_10264() & 0xF)), (float)(pos.method_10260() - (pos.method_10260() & 0xF)));
                renderDispatcher.method_3352(pos, level, (class_4588)transformingWrapper, state, fluidState);
                poseStack.method_22909();
            }
            if (state.method_26217() != class_2464.field_11458) continue;
            long seed = state.method_26190(pos);
            class_1087 model = renderDispatcher.method_3349(state);
            class_1921 defaultLayer = class_4696.method_23679((class_2680)state);
            universalEmitter.prepare(defaultLayer);
            model = universalEmitter.wrapModel(model);
            poseStack.method_22903();
            poseStack.method_46416((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
            blockRenderer.method_3374(level, model, state, pos, poseStack, (class_4588)universalEmitter, true, random, seed, class_4608.field_21444);
            poseStack.method_22909();
        }
        class_778.method_20545();
        transformingWrapper.clear();
        universalEmitter.clear();
        for (MeshEmitter emitter : emitters) {
            emitter.end();
        }
    }

    private static class ThreadLocalObjects {
        public final class_4587 identityPoseStack = new class_4587();
        public final class_5819 random = class_5819.method_43053();
        public final MeshEmitter[] emitters = new MeshEmitter[CHUNK_LAYER_AMOUNT];
        public final Reference2ReferenceMap<class_1921, MeshEmitter> emitterMap = new Reference2ReferenceOpenHashMap();
        public final UniversalMeshEmitter universalEmitter;
        public final TransformingVertexConsumer transformingWrapper = new TransformingVertexConsumer();

        private ThreadLocalObjects() {
            for (int layerIndex = 0; layerIndex < CHUNK_LAYER_AMOUNT; ++layerIndex) {
                MeshEmitter emitter;
                class_1921 renderType = CHUNK_LAYERS[layerIndex];
                this.emitters[layerIndex] = emitter = new MeshEmitter(renderType);
                this.emitterMap.put((Object)renderType, (Object)emitter);
            }
            this.universalEmitter = new UniversalMeshEmitter(this.emitterMap);
        }
    }

    public static interface ResultConsumer {
        public void accept(class_1921 var1, boolean var2, class_287.class_7433 var3);
    }
}

