/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.instance;

import dev.engine_room.flywheel.api.instance.InstanceHandle;
import dev.engine_room.flywheel.api.instance.InstanceType;
import dev.engine_room.flywheel.lib.instance.ColoredLitOverlayInstance;
import dev.engine_room.flywheel.lib.transform.Affine;
import net.minecraft.class_4587;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;

public class TransformedInstance
extends ColoredLitOverlayInstance
implements Affine<TransformedInstance> {
    public final Matrix4f pose = new Matrix4f();

    public TransformedInstance(InstanceType<? extends TransformedInstance> type, InstanceHandle handle) {
        super((InstanceType<? extends ColoredLitOverlayInstance>)type, handle);
    }

    @Override
    public TransformedInstance translate(float x, float y, float z) {
        this.pose.translate(x, y, z);
        return this;
    }

    @Override
    public TransformedInstance rotate(Quaternionfc quaternion) {
        this.pose.rotate(quaternion);
        return this;
    }

    @Override
    public TransformedInstance scale(float x, float y, float z) {
        this.pose.scale(x, y, z);
        return this;
    }

    public TransformedInstance mul(Matrix4fc other) {
        this.pose.mul(other);
        return this;
    }

    public TransformedInstance mul(class_4587.class_4665 other) {
        return this.mul((Matrix4fc)other.method_23761());
    }

    public TransformedInstance mul(class_4587 stack) {
        return this.mul(stack.method_23760());
    }

    public TransformedInstance setTransform(Matrix4fc pose) {
        this.pose.set(pose);
        return this;
    }

    public TransformedInstance setTransform(class_4587.class_4665 pose) {
        this.pose.set((Matrix4fc)pose.method_23761());
        return this;
    }

    public TransformedInstance setTransform(class_4587 stack) {
        return this.setTransform(stack.method_23760());
    }

    public TransformedInstance setIdentityTransform() {
        this.pose.identity();
        return this;
    }

    public TransformedInstance setZeroTransform() {
        this.pose.zero();
        return this;
    }

    @Override
    public TransformedInstance rotateAround(Quaternionfc quaternion, float x, float y, float z) {
        this.pose.rotateAround(quaternion, x, y, z);
        return this;
    }

    @Override
    public TransformedInstance rotateCentered(float radians, float axisX, float axisY, float axisZ) {
        this.pose.translate(0.5f, 0.5f, 0.5f).rotate(radians, axisX, axisY, axisZ).translate(-0.5f, -0.5f, -0.5f);
        return this;
    }

    @Override
    public TransformedInstance rotateXCentered(float radians) {
        this.pose.translate(0.5f, 0.5f, 0.5f).rotateX(radians).translate(-0.5f, -0.5f, -0.5f);
        return this;
    }

    @Override
    public TransformedInstance rotateYCentered(float radians) {
        this.pose.translate(0.5f, 0.5f, 0.5f).rotateY(radians).translate(-0.5f, -0.5f, -0.5f);
        return this;
    }

    @Override
    public TransformedInstance rotateZCentered(float radians) {
        this.pose.translate(0.5f, 0.5f, 0.5f).rotateZ(radians).translate(-0.5f, -0.5f, -0.5f);
        return this;
    }

    @Override
    public TransformedInstance rotate(float radians, float axisX, float axisY, float axisZ) {
        this.pose.rotate(radians, axisX, axisY, axisZ);
        return this;
    }

    @Override
    public TransformedInstance rotate(AxisAngle4f axisAngle) {
        this.pose.rotate(axisAngle);
        return this;
    }

    @Override
    public TransformedInstance rotateX(float radians) {
        this.pose.rotateX(radians);
        return this;
    }

    @Override
    public TransformedInstance rotateY(float radians) {
        this.pose.rotateY(radians);
        return this;
    }

    @Override
    public TransformedInstance rotateZ(float radians) {
        this.pose.rotateZ(radians);
        return this;
    }
}

