/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.impl.compat;

import dev.engine_room.flywheel.api.visualization.BlockEntityVisualizer;
import dev.engine_room.flywheel.impl.FlwImpl;
import dev.engine_room.flywheel.impl.FlwImplXplat;
import dev.engine_room.flywheel.lib.visualization.VisualizationHelper;
import net.caffeinemc.mods.sodium.api.blockentity.BlockEntityRenderHandler;
import net.caffeinemc.mods.sodium.api.blockentity.BlockEntityRenderPredicate;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import org.jetbrains.annotations.Nullable;

public final class SodiumCompat {
    public static final boolean USE_0_6_COMPAT = FlwImplXplat.INSTANCE.useSodium0_6Compat();

    private SodiumCompat() {
    }

    @Nullable
    public static <T extends class_2586> Object onSetBlockEntityVisualizer(class_2591<T> type, @Nullable BlockEntityVisualizer<? super T> oldVisualizer, @Nullable BlockEntityVisualizer<? super T> newVisualizer, @Nullable Object predicate) {
        if (!USE_0_6_COMPAT) {
            return null;
        }
        if (oldVisualizer == null && newVisualizer != null) {
            if (predicate != null) {
                throw new IllegalArgumentException("Sodium predicate must be null when old visualizer is null");
            }
            return Internals.addPredicate(type);
        }
        if (oldVisualizer != null && newVisualizer == null) {
            if (predicate == null) {
                throw new IllegalArgumentException("Sodium predicate must not be null when old visualizer is not null");
            }
            Internals.removePredicate(type, predicate);
            return null;
        }
        return predicate;
    }

    static {
        if (USE_0_6_COMPAT) {
            FlwImpl.LOGGER.debug("Detected Sodium 0.6");
        }
    }

    private static final class Internals {
        private Internals() {
        }

        static <T extends class_2586> Object addPredicate(class_2591<T> type) {
            BlockEntityRenderPredicate predicate = (getter, pos, be) -> VisualizationHelper.tryAddBlockEntity(be);
            BlockEntityRenderHandler.instance().addRenderPredicate(type, predicate);
            return predicate;
        }

        static <T extends class_2586> void removePredicate(class_2591<T> type, Object predicate) {
            BlockEntityRenderHandler.instance().removeRenderPredicate(type, (BlockEntityRenderPredicate)predicate);
        }
    }
}

