/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.impl.compat;

import dev.engine_room.flywheel.impl.FlwImpl;
import dev.engine_room.flywheel.impl.compat.CompatMod;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;

public final class FabricSodiumCompat {
    public static final boolean USE_0_5_COMPAT;
    public static final boolean USE_0_6_COMPAT;

    private FabricSodiumCompat() {
    }

    static {
        boolean use0_5Compat = false;
        boolean use0_6Compat = false;
        Optional optionalModContainer = FabricLoader.getInstance().getModContainer(CompatMod.SODIUM.id);
        if (optionalModContainer.isPresent()) {
            ModContainer modContainer = (ModContainer)optionalModContainer.get();
            Version sodiumVersion = modContainer.getMetadata().getVersion();
            try {
                VersionPredicate predicate0_5 = VersionPredicate.parse((String)"~0.5.0");
                VersionPredicate predicate0_6 = VersionPredicate.parse((String)">=0.6.0-beta.2");
                use0_5Compat = predicate0_5.test((Object)sodiumVersion);
                use0_6Compat = predicate0_6.test((Object)sodiumVersion);
            }
            catch (VersionParsingException e) {
                FlwImpl.LOGGER.debug("Failed to parse Sodium version predicates", (Throwable)e);
            }
        }
        USE_0_5_COMPAT = use0_5Compat;
        USE_0_6_COMPAT = use0_6Compat;
        if (USE_0_5_COMPAT) {
            FlwImpl.LOGGER.debug("Detected Sodium 0.5");
        }
    }
}

