/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.backend.glsl;

import com.mojang.datafixers.util.Pair;
import dev.engine_room.flywheel.backend.glsl.error.ErrorBuilder;
import dev.engine_room.flywheel.backend.glsl.span.Span;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_151;
import net.minecraft.class_2960;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface LoadError {
    public ErrorBuilder generateMessage();

    public record MalformedInclude(class_151 exception) implements LoadError
    {
        @Override
        public ErrorBuilder generateMessage() {
            return ErrorBuilder.create().error(this.exception.toString());
        }
    }

    public record ResourceError(class_2960 location) implements LoadError
    {
        @Override
        public ErrorBuilder generateMessage() {
            return ErrorBuilder.create().error("\"" + this.location + "\" was not found");
        }
    }

    public record IOError(class_2960 location, IOException exception) implements LoadError
    {
        @Override
        public ErrorBuilder generateMessage() {
            if (this.exception instanceof FileNotFoundException) {
                return ErrorBuilder.create().error("\"" + this.location + "\" was not found");
            }
            return ErrorBuilder.create().error("could not load \"" + this.location + "\" due to an IO error").note(this.exception.toString());
        }
    }

    public record IncludeError(class_2960 location, List<Pair<Span, LoadError>> innerErrors) implements LoadError
    {
        @Override
        public ErrorBuilder generateMessage() {
            ErrorBuilder out = ErrorBuilder.create().error("could not load \"" + this.location + "\"").pointAtFile(this.location);
            for (Pair<Span, LoadError> innerError : this.innerErrors) {
                ErrorBuilder err = ((LoadError)innerError.getSecond()).generateMessage();
                out.pointAt((Span)innerError.getFirst()).nested(err);
            }
            return out;
        }
    }

    public record CircularDependency(class_2960 offender, List<class_2960> stack) implements LoadError
    {
        public String format() {
            return this.stack.stream().dropWhile(l -> !l.equals((Object)this.offender)).map(class_2960::toString).collect(Collectors.joining(" -> "));
        }

        @Override
        public ErrorBuilder generateMessage() {
            return ErrorBuilder.create().error("files are circularly dependent").note(this.format());
        }
    }
}

