/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.backend.gl.shader;

import com.mojang.logging.LogUtils;
import dev.engine_room.flywheel.backend.gl.GlObject;
import dev.engine_room.flywheel.backend.gl.GlTextureUnit;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.class_285;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL31;
import org.slf4j.Logger;

public class GlProgram
extends GlObject {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Object2IntMap<String> uniformLocationCache = new Object2IntOpenHashMap();

    public GlProgram(int handle) {
        this.handle(handle);
    }

    public void bind() {
        class_285.method_22094((int)this.handle());
    }

    public static void unbind() {
        class_285.method_22094((int)0);
    }

    public void setFloat(String glslName, float value) {
        int uniform = this.getUniformLocation(glslName);
        if (uniform < 0) {
            return;
        }
        GL20.glUniform1f((int)uniform, (float)value);
    }

    public void setVec2(String glslName, float x, float y) {
        int uniform = this.getUniformLocation(glslName);
        if (uniform < 0) {
            return;
        }
        GL20.glUniform2f((int)uniform, (float)x, (float)y);
    }

    public void setVec3(String glslName, float x, float y, float z) {
        int uniform = this.getUniformLocation(glslName);
        if (uniform < 0) {
            return;
        }
        GL20.glUniform3f((int)uniform, (float)x, (float)y, (float)z);
    }

    public void setVec4(String glslName, float x, float y, float z, float w) {
        int uniform = this.getUniformLocation(glslName);
        if (uniform < 0) {
            return;
        }
        GL20.glUniform4f((int)uniform, (float)x, (float)y, (float)z, (float)w);
    }

    public void setMat4(String glslName, Matrix4fc matrix) {
        int uniform = this.getUniformLocation(glslName);
        if (uniform < 0) {
            return;
        }
        GL20.glUniformMatrix4fv((int)uniform, (boolean)false, (float[])matrix.get(new float[16]));
    }

    public void setMat3(String glslName, Matrix3fc matrix) {
        int uniform = this.getUniformLocation(glslName);
        if (uniform < 0) {
            return;
        }
        GL20.glUniformMatrix3fv((int)uniform, (boolean)false, (float[])matrix.get(new float[9]));
    }

    public void setBool(String glslName, boolean bool) {
        this.setInt(glslName, bool ? 1 : 0);
    }

    public void setUInt(String glslName, int value) {
        int uniform = this.getUniformLocation(glslName);
        if (uniform < 0) {
            return;
        }
        GL30.glUniform1ui((int)uniform, (int)value);
    }

    public void setUVec2(String name, int x, int y) {
        int uniform = this.getUniformLocation(name);
        if (uniform < 0) {
            return;
        }
        GL30.glUniform2ui((int)uniform, (int)x, (int)y);
    }

    public void setInt(String glslName, int value) {
        int uniform = this.getUniformLocation(glslName);
        if (uniform < 0) {
            return;
        }
        GL20.glUniform1i((int)uniform, (int)value);
    }

    public int getUniformLocation(String uniform) {
        return this.uniformLocationCache.computeIfAbsent((Object)uniform, s -> {
            int index = GL20.glGetUniformLocation((int)this.handle(), (CharSequence)uniform);
            if (index < 0) {
                LOGGER.debug("No active uniform '{}' exists. Could be unused.", (Object)uniform);
            }
            return index;
        });
    }

    public void setSamplerBinding(String name, GlTextureUnit binding) {
        this.setSamplerBinding(name, binding.number);
    }

    public void setSamplerBinding(String name, int binding) {
        int samplerUniform = this.getUniformLocation(name);
        if (samplerUniform >= 0) {
            GL20.glUniform1i((int)samplerUniform, (int)binding);
        }
    }

    public void setUniformBlockBinding(String name, int binding) {
        int index = GL31.glGetUniformBlockIndex((int)this.handle(), (CharSequence)name);
        if (index == -1) {
            LOGGER.debug("No active uniform block '{}' exists. Could be unused.", (Object)name);
            return;
        }
        GL31.glUniformBlockBinding((int)this.handle(), (int)index, (int)binding);
    }

    public void bindAttribLocation(String attribute, int binding) {
        GL20.glBindAttribLocation((int)this.handle(), (int)binding, (CharSequence)attribute);
    }

    @Override
    protected void deleteInternal(int handle) {
        GL20.glDeleteProgram((int)handle);
    }
}

