/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.simibubi.create.Create;
import com.simibubi.create.content.kinetics.fan.processing.SplashingRecipe;
import com.simibubi.create.content.kinetics.saw.CuttingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.data.recipe.Mods;
import com.simibubi.create.foundation.mixin.accessor.ConcretePowderBlockAccessor;
import com.simibubi.create.foundation.pack.DynamicPack;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2292;
import net.minecraft.class_2960;
import net.minecraft.class_3497;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7475;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class RuntimeDataGenerator {
    private static final Pattern STRIPPED_WOODS_PREFIX_REGEX = Pattern.compile("(\\w*)??stripped_(\\w*)(_log|_wood|_stem|_hyphae|_block|(?<!_)wood)()$");
    private static final Pattern STRIPPED_WOOD_SUFFIX_REGEX = Pattern.compile("(\\w*)(_log|_wood|_stem|_hyphae|_block|(?<!_)wood)(\\w*)_stripped(\\w*)");
    private static final Pattern NON_STRIPPED_WOODS_REGEX = Pattern.compile("^(?!stripped_)([a-z_]+)(_log|_wood|_stem|_hyphae|(?<!bioshroom)_block)(([a-z_]+)(?<!_stripped))?$");
    private static final Multimap<class_2960, class_3497> TAGS = HashMultimap.create();
    private static final Object2ObjectOpenHashMap<class_2960, JsonObject> JSON_FILES = new Object2ObjectOpenHashMap();
    private static final Map<class_2960, class_2960> MISMATCHED_WOOD_NAMES = ImmutableMap.builder().put((Object)Mods.ARS_N.asResource("blue_archwood"), (Object)Mods.ARS_N.asResource("archwood")).put((Object)Mods.DD.asResource("blooming"), (Object)Mods.DD.asResource("bloom")).build();

    public static void insertIntoPack(DynamicPack dynamicPack) {
        for (class_2960 class_29602 : class_7923.field_41178.method_10235()) {
            RuntimeDataGenerator.cuttingRecipes(class_29602);
            RuntimeDataGenerator.washingRecipes(class_29602);
        }
        Create.LOGGER.info("Created {} recipes which will be injected into the game", (Object)JSON_FILES.size());
        JSON_FILES.forEach(dynamicPack::put);
        Create.LOGGER.info("Created {} tags which will be injected into the game", (Object)TAGS.size());
        for (Map.Entry entry : TAGS.asMap().entrySet()) {
            class_7475 tagFile = new class_7475(new ArrayList((Collection)entry.getValue()), false);
            dynamicPack.put(((class_2960)entry.getKey()).method_45138("tags/items/"), (JsonElement)class_7475.field_39269.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)tagFile).result().orElseThrow());
        }
        JSON_FILES.clear();
        JSON_FILES.trim();
        TAGS.clear();
    }

    private static void cuttingRecipes(class_2960 itemId) {
        boolean hasFoundMatch;
        String path = itemId.method_12832();
        Matcher match = STRIPPED_WOODS_PREFIX_REGEX.matcher(path);
        boolean strippedInPrefix = hasFoundMatch = match.find();
        if (!hasFoundMatch) {
            match = STRIPPED_WOOD_SUFFIX_REGEX.matcher(path);
            hasFoundMatch = match.find();
        }
        boolean noStrippedVariant = false;
        if (!(hasFoundMatch || class_7923.field_41178.method_10250(itemId.method_45138("stripped_")) || class_7923.field_41178.method_10250(itemId.method_48331("_stripped")))) {
            match = NON_STRIPPED_WOODS_REGEX.matcher(path);
            hasFoundMatch = match.find();
            noStrippedVariant = true;
        }
        if (hasFoundMatch) {
            int planksCount;
            String prefix = strippedInPrefix && match.group(1) != null ? match.group(1) : "";
            String suffix = !strippedInPrefix && !noStrippedVariant ? match.group(3) + match.group(4) : "";
            String type = match.group(strippedInPrefix ? 3 : 2);
            class_2960 matched_name = itemId.method_45136(match.group(strippedInPrefix ? 2 : 1));
            class_2960 base = matched_name.method_48331(type.equals("wood") ? "wood" : "");
            base = MISMATCHED_WOOD_NAMES.getOrDefault(base, base);
            class_2960 nonStrippedId = matched_name.method_48331(type).method_45138(prefix).method_48331(suffix);
            class_2960 planksId = base.method_48331("_planks");
            class_2960 stairsId = base.method_48331(base.method_12836().equals(Mods.BTN.getId()) ? "_planks_stairs" : "_stairs");
            class_2960 slabId = base.method_48331(base.method_12836().equals(Mods.BTN.getId()) ? "_planks_slab" : "_slab");
            class_2960 fenceId = base.method_48331("_fence");
            class_2960 fenceGateId = base.method_48331("_fence_gate");
            class_2960 doorId = base.method_48331("_door");
            class_2960 trapdoorId = base.method_48331("_trapdoor");
            class_2960 pressurePlateId = base.method_48331("_pressure_plate");
            class_2960 buttonId = base.method_48331("_button");
            class_2960 signId = base.method_48331("_sign");
            int n = planksCount = type.contains("block") ? 3 : 6;
            if (!noStrippedVariant) {
                if (class_7923.field_41178.method_10250(nonStrippedId)) {
                    RuntimeDataGenerator.simpleWoodRecipe(nonStrippedId, itemId);
                }
                RuntimeDataGenerator.simpleWoodRecipe(itemId, planksId, planksCount);
            } else if (class_7923.field_41178.method_10250(planksId)) {
                class_2960 tag = Create.asResource("runtime_generated/compat/" + itemId.method_12836() + "/" + base.method_12832());
                RuntimeDataGenerator.insertIntoTag(tag, itemId);
                RuntimeDataGenerator.simpleWoodRecipe((class_6862<class_1792>)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)tag), planksId, planksCount);
            }
            if (!path.contains("_wood") && !path.contains("_hyphae") && class_7923.field_41178.method_10250(planksId)) {
                RuntimeDataGenerator.simpleWoodRecipe(planksId, stairsId);
                RuntimeDataGenerator.simpleWoodRecipe(planksId, slabId, 2);
                RuntimeDataGenerator.simpleWoodRecipe(planksId, fenceId);
                RuntimeDataGenerator.simpleWoodRecipe(planksId, fenceGateId);
                RuntimeDataGenerator.simpleWoodRecipe(planksId, doorId);
                RuntimeDataGenerator.simpleWoodRecipe(planksId, trapdoorId);
                RuntimeDataGenerator.simpleWoodRecipe(planksId, pressurePlateId);
                RuntimeDataGenerator.simpleWoodRecipe(planksId, buttonId);
                RuntimeDataGenerator.simpleWoodRecipe(planksId, signId);
            }
        }
    }

    private static void washingRecipes(class_2960 itemId) {
        class_2248 block = (class_2248)class_7923.field_41175.method_10223(itemId);
        if (block instanceof class_2292) {
            class_2292 concretePowderBlock = (class_2292)block;
            class_2248 concreteBlock = ((ConcretePowderBlockAccessor)concretePowderBlock).create$getConcrete().method_26204();
            RuntimeDataGenerator.simpleSplashingRecipe(itemId, class_7923.field_41175.method_10221((Object)concreteBlock));
        }
    }

    private static void insertIntoTag(class_2960 tag, class_2960 itemId) {
        if (class_7923.field_41178.method_10250(itemId)) {
            TAGS.put((Object)tag, (Object)class_3497.method_43942((class_2960)itemId));
        }
    }

    private static void simpleWoodRecipe(class_2960 inputId, class_2960 outputId) {
        RuntimeDataGenerator.simpleWoodRecipe(inputId, outputId, 1);
    }

    private static void simpleWoodRecipe(class_2960 inputId, class_2960 outputId, int amount) {
        if (class_7923.field_41178.method_10250(outputId)) {
            new Builder<CuttingRecipe>(inputId.method_12836(), CuttingRecipe::new, inputId.method_12832(), outputId.method_12832()).require((class_1935)class_7923.field_41178.method_10223(inputId)).output((class_1935)class_7923.field_41178.method_10223(outputId), amount).duration(50).build();
        }
    }

    private static void simpleWoodRecipe(class_6862<class_1792> inputTag, class_2960 outputId, int amount) {
        if (class_7923.field_41178.method_10250(outputId)) {
            new Builder<CuttingRecipe>(inputTag.comp_327().method_12836(), CuttingRecipe::new, "tag_" + inputTag.comp_327().method_12832(), outputId.method_12832()).require(inputTag).output((class_1935)class_7923.field_41178.method_10223(outputId), amount).duration(50).build();
        }
    }

    private static void simpleSplashingRecipe(class_2960 first, class_2960 second) {
        new Builder<SplashingRecipe>(first.method_12836(), SplashingRecipe::new, first.method_12832(), second.method_12832()).require((class_1935)class_7923.field_41175.method_10223(first)).output((class_1935)class_7923.field_41175.method_10223(second)).build();
    }

    private static class Builder<T extends ProcessingRecipe<?>>
    extends ProcessingRecipeBuilder<T> {
        public Builder(String modid, ProcessingRecipeBuilder.ProcessingRecipeFactory<T> factory, String from, String to) {
            super(factory, Create.asResource("runtime_generated/compat/" + modid + "/" + from + "_to_" + to));
        }

        @Override
        public T build() {
            Object t = super.build();
            ProcessingRecipeBuilder.DataGenResult result = new ProcessingRecipeBuilder.DataGenResult(t, Collections.emptyList());
            JSON_FILES.put((Object)result.method_10417().method_45138("recipes/"), (Object)result.method_17799());
            return t;
        }
    }
}

