/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.EdgeData;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackGraphHelper;
import com.simibubi.create.content.trains.graph.TrackGraphLocation;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.signal.SingleBlockEntityEdgePoint;
import com.simibubi.create.content.trains.signal.TrackEdgePoint;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.levelWrappers.SchematicLevel;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.ponder.api.level.PonderLevel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_761;

public class TrackTargetingBehaviour<T extends TrackEdgePoint>
extends BlockEntityBehaviour {
    public static final BehaviourType<TrackTargetingBehaviour<?>> TYPE = new BehaviourType();
    private class_2338 targetTrack;
    private BezierTrackPointLocation targetBezier;
    private class_2350.class_2352 targetDirection;
    private UUID id;
    private class_243 prevDirection;
    private class_243 rotatedDirection;
    private class_2487 migrationData;
    private EdgePointType<T> edgePointType;
    private T edgePoint;
    private boolean orthogonal;

    public TrackTargetingBehaviour(SmartBlockEntity be, EdgePointType<T> edgePointType) {
        super(be);
        this.edgePointType = edgePointType;
        this.targetDirection = class_2350.class_2352.field_11056;
        this.targetTrack = class_2338.field_10980;
        this.id = UUID.randomUUID();
        this.migrationData = null;
        this.orthogonal = false;
    }

    @Override
    public boolean isSafeNBT() {
        return true;
    }

    @Override
    public void write(class_2487 nbt, boolean clientPacket) {
        nbt.method_25927("Id", this.id);
        nbt.method_10566("TargetTrack", (class_2520)class_2512.method_10692((class_2338)this.targetTrack));
        nbt.method_10556("Ortho", this.orthogonal);
        nbt.method_10556("TargetDirection", this.targetDirection == class_2350.class_2352.field_11056);
        if (this.rotatedDirection != null) {
            nbt.method_10566("RotatedAxis", (class_2520)VecHelper.writeNBT((class_243)this.rotatedDirection));
        }
        if (this.prevDirection != null) {
            nbt.method_10566("PrevAxis", (class_2520)VecHelper.writeNBT((class_243)this.prevDirection));
        }
        if (this.migrationData != null && !clientPacket) {
            nbt.method_10566("Migrate", (class_2520)this.migrationData);
        }
        if (this.targetBezier != null) {
            class_2487 bezierNbt = new class_2487();
            bezierNbt.method_10569("Segment", this.targetBezier.segment());
            bezierNbt.method_10566("Key", (class_2520)class_2512.method_10692((class_2338)this.targetBezier.curveTarget().method_10059((class_2382)this.getPos())));
            nbt.method_10566("Bezier", (class_2520)bezierNbt);
        }
        super.write(nbt, clientPacket);
    }

    @Override
    public void read(class_2487 nbt, boolean clientPacket) {
        this.id = nbt.method_10545("Id") ? nbt.method_25926("Id") : UUID.randomUUID();
        this.targetTrack = class_2512.method_10691((class_2487)nbt.method_10562("TargetTrack"));
        this.targetDirection = nbt.method_10577("TargetDirection") ? class_2350.class_2352.field_11056 : class_2350.class_2352.field_11060;
        this.orthogonal = nbt.method_10577("Ortho");
        if (nbt.method_10545("PrevAxis")) {
            this.prevDirection = VecHelper.readNBT((class_2499)nbt.method_10554("PrevAxis", 6));
        }
        if (nbt.method_10545("RotatedAxis")) {
            this.rotatedDirection = VecHelper.readNBT((class_2499)nbt.method_10554("RotatedAxis", 6));
        }
        if (nbt.method_10545("Migrate")) {
            this.migrationData = nbt.method_10562("Migrate");
        }
        if (clientPacket) {
            this.edgePoint = null;
        }
        if (nbt.method_10545("Bezier")) {
            class_2487 bezierNbt = nbt.method_10562("Bezier");
            class_2338 key = class_2512.method_10691((class_2487)bezierNbt.method_10562("Key"));
            this.targetBezier = new BezierTrackPointLocation(bezierNbt.method_10545("FromStack") ? key : key.method_10081((class_2382)this.getPos()), bezierNbt.method_10550("Segment"));
        }
        super.read(nbt, clientPacket);
    }

    @Nullable
    public T getEdgePoint() {
        return this.edgePoint;
    }

    public void invalidateEdgePoint(class_2487 migrationData) {
        this.migrationData = migrationData;
        this.edgePoint = null;
        this.blockEntity.sendData();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.edgePoint == null) {
            this.edgePoint = this.createEdgePoint();
        }
    }

    public T createEdgePoint() {
        class_1937 level = this.getWorld();
        boolean isClientSide = level.field_9236;
        if (this.migrationData == null || isClientSide) {
            for (TrackGraph trackGraph : Create.RAILWAYS.sided((class_1936)level).trackNetworks.values()) {
                T point = trackGraph.getPoint(this.edgePointType, this.id);
                if (point == null) continue;
                return point;
            }
        }
        if (isClientSide) {
            return null;
        }
        if (!this.hasValidTrack()) {
            return null;
        }
        TrackGraphLocation loc = this.determineGraphLocation();
        if (loc == null) {
            return null;
        }
        TrackGraph graph = loc.graph;
        TrackNode node1 = graph.locateNode((TrackNodeLocation)((Object)loc.edge.getFirst()));
        TrackNode node2 = graph.locateNode((TrackNodeLocation)((Object)loc.edge.getSecond()));
        TrackEdge edge = graph.getConnectionsFrom(node1).get(node2);
        if (edge == null) {
            return null;
        }
        T point = this.edgePointType.create();
        boolean front = this.getTargetDirection() == class_2350.class_2352.field_11056;
        this.prevDirection = edge.getDirectionAt(loc.position).method_1021(front ? -1.0 : 1.0);
        if (this.rotatedDirection != null) {
            double dot = this.prevDirection.method_1026(this.rotatedDirection);
            if (dot < (double)-0.85f) {
                this.rotatedDirection = null;
                this.targetDirection = this.targetDirection.method_26424();
                return null;
            }
            this.rotatedDirection = null;
        }
        double length = edge.getLength();
        class_2487 data = this.migrationData;
        this.migrationData = null;
        this.orthogonal = this.targetBezier == null;
        class_243 direction = edge.getDirection(true);
        int nonZeroComponents = 0;
        for (class_2350.class_2351 axis : Iterate.axes) {
            nonZeroComponents += direction.method_18043(axis) != 0.0 ? 1 : 0;
        }
        this.orthogonal &= nonZeroComponents <= 1;
        EdgeData signalData = edge.getEdgeData();
        if (signalData.hasPoints()) {
            for (EdgePointType<?> otherType : EdgePointType.TYPES.values()) {
                Object otherPoint = signalData.get(otherType, loc.position);
                if (otherPoint == null) continue;
                if (otherType != this.edgePointType) {
                    if (((TrackEdgePoint)otherPoint).canCoexistWith(this.edgePointType, front)) continue;
                    return null;
                }
                if (!((TrackEdgePoint)otherPoint).canMerge()) {
                    return null;
                }
                ((TrackEdgePoint)otherPoint).blockEntityAdded(this.blockEntity, front);
                this.id = ((TrackEdgePoint)otherPoint).getId();
                this.blockEntity.notifyUpdate();
                return (T)otherPoint;
            }
        }
        if (data != null) {
            ((TrackEdgePoint)point).read(data, true, DimensionPalette.read(data));
        }
        ((TrackEdgePoint)point).setId(this.id);
        boolean reverseEdge = front || point instanceof SingleBlockEntityEdgePoint;
        ((TrackEdgePoint)point).setLocation((Couple<TrackNodeLocation>)(reverseEdge ? loc.edge : loc.edge.swap()), reverseEdge ? loc.position : length - loc.position);
        ((TrackEdgePoint)point).blockEntityAdded(this.blockEntity, front);
        loc.graph.addPoint(this.edgePointType, point);
        this.blockEntity.sendData();
        return point;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.edgePoint != null && !this.getWorld().field_9236) {
            ((TrackEdgePoint)this.edgePoint).blockEntityRemoved(this.getPos(), this.getTargetDirection() == class_2350.class_2352.field_11056);
        }
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public boolean isOnCurve() {
        return this.targetBezier != null;
    }

    public boolean isOrthogonal() {
        return this.orthogonal;
    }

    public boolean hasValidTrack() {
        return this.getTrackBlockState().method_26204() instanceof ITrackBlock;
    }

    public ITrackBlock getTrack() {
        return (ITrackBlock)this.getTrackBlockState().method_26204();
    }

    public class_2680 getTrackBlockState() {
        return this.getWorld().method_8320(this.getGlobalPosition());
    }

    public class_2338 getGlobalPosition() {
        return this.targetTrack.method_10081((class_2382)this.blockEntity.method_11016());
    }

    public class_2338 getPositionForMapMarker() {
        class_2586 class_25862;
        class_2338 target = this.targetTrack.method_10081((class_2382)this.blockEntity.method_11016());
        if (this.targetBezier != null && (class_25862 = this.getWorld().method_8321(target)) instanceof TrackBlockEntity) {
            TrackBlockEntity tbe = (TrackBlockEntity)class_25862;
            BezierConnection bc = tbe.getConnections().get(this.targetBezier.curveTarget());
            if (bc == null) {
                return target;
            }
            double length = class_3532.method_15357((double)(bc.getLength() * 2.0));
            int seg = this.targetBezier.segment() + 1;
            double t = (double)seg / length;
            return class_2338.method_49638((class_2374)bc.getPosition(t));
        }
        return target;
    }

    public class_2350.class_2352 getTargetDirection() {
        return this.targetDirection;
    }

    public BezierTrackPointLocation getTargetBezier() {
        return this.targetBezier;
    }

    public TrackGraphLocation determineGraphLocation() {
        class_1937 level = this.getWorld();
        class_2338 pos = this.getGlobalPosition();
        class_2680 state = this.getTrackBlockState();
        ITrackBlock track = this.getTrack();
        List<class_243> trackAxes = track.getTrackAxes((class_1922)level, pos, state);
        class_2350.class_2352 targetDirection = this.getTargetDirection();
        return this.targetBezier != null ? TrackGraphHelper.getBezierGraphLocationAt(level, pos, targetDirection, this.targetBezier) : TrackGraphHelper.getGraphLocationAt(level, pos, targetDirection, trackAxes.get(0));
    }

    @Environment(value=EnvType.CLIENT)
    public static void render(class_1936 level, class_2338 pos, class_2350.class_2352 direction, BezierTrackPointLocation bezier, class_4587 ms, class_4597 buffer, int light, int overlay, RenderedTrackOverlayType type, float scale) {
        if (level instanceof SchematicLevel && !(level instanceof PonderLevel)) {
            return;
        }
        class_2680 trackState = level.method_8320(pos);
        class_2248 block = trackState.method_26204();
        if (!(block instanceof ITrackBlock)) {
            return;
        }
        ITrackBlock track = (ITrackBlock)block;
        ms.method_22903();
        PoseTransformStack msr = TransformStack.of((class_4587)ms);
        PartialModel partial = track.prepareTrackOverlay(msr, (class_1922)level, pos, trackState, bezier, direction, type);
        if (partial != null) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)partial, (class_2680)trackState).translate(0.5, 0.0, 0.5)).scale(scale)).translate(-0.5, 0.0, -0.5)).light(class_761.method_23794((class_1920)level, (class_2338)pos)).renderInto(ms, buffer.getBuffer(class_1921.method_23579()));
        }
        ms.method_22909();
    }

    public void transform(class_2586 be, StructureTransform transform) {
        this.id = UUID.randomUUID();
        this.targetTrack = transform.applyWithoutOffset(this.targetTrack);
        if (this.prevDirection != null) {
            this.rotatedDirection = transform.applyWithoutOffsetUncentered(this.prevDirection);
        }
        if (this.targetBezier != null) {
            this.targetBezier = new BezierTrackPointLocation(transform.applyWithoutOffset(this.targetBezier.curveTarget().method_10059((class_2382)this.getPos())).method_10081((class_2382)this.getPos()), this.targetBezier.segment());
        }
        this.blockEntity.notifyUpdate();
    }

    public static enum RenderedTrackOverlayType {
        STATION,
        SIGNAL,
        DUAL_SIGNAL,
        OBSERVER;

    }
}

