/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.observer;

import com.simibubi.create.Create;
import com.simibubi.create.api.contraption.transformable.TransformableBlockEntity;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.compat.computercraft.ComputerCraftProxy;
import com.simibubi.create.compat.computercraft.events.TrainPassEvent;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlock;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.observer.TrackObserver;
import com.simibubi.create.content.trains.observer.TrackObserverBlock;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public class TrackObserverBlockEntity
extends SmartBlockEntity
implements TransformableBlockEntity {
    public TrackTargetingBehaviour<TrackObserver> edgePoint;
    private FilteringBehaviour filtering;
    public AbstractComputerBehaviour computerBehaviour;
    @Nullable
    public UUID passingTrainUUID;

    public TrackObserverBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.edgePoint = new TrackTargetingBehaviour<TrackObserver>(this, EdgePointType.OBSERVER);
        behaviours.add(this.edgePoint);
        this.filtering = this.createFilter().withCallback(this::onFilterChanged);
        behaviours.add(this.filtering);
        this.computerBehaviour = ComputerCraftProxy.behaviour(this);
        behaviours.add(this.computerBehaviour);
        this.filtering.setLabel(CreateLang.translateDirect("logistics.train_observer.cargo_filter", new Object[0]));
    }

    private void onFilterChanged(class_1799 newFilter) {
        if (this.field_11863.method_8608()) {
            return;
        }
        TrackObserver observer = this.getObserver();
        if (observer != null) {
            observer.setFilterAndNotify(this.field_11863, newFilter);
        }
    }

    @Override
    public void tick() {
        class_2680 blockState;
        super.tick();
        if (this.field_11863.method_8608()) {
            return;
        }
        boolean shouldBePowered = false;
        TrackObserver observer = this.getObserver();
        if (observer != null) {
            shouldBePowered = observer.isActivated();
        }
        if (this.isBlockPowered() == shouldBePowered) {
            return;
        }
        if (observer != null && this.computerBehaviour.hasAttachedComputer()) {
            if (shouldBePowered) {
                this.passingTrainUUID = observer.getCurrentTrain();
            }
            if (this.passingTrainUUID != null) {
                this.computerBehaviour.prepareComputerEvent(new TrainPassEvent(Create.RAILWAYS.trains.get(this.passingTrainUUID), shouldBePowered));
                if (!shouldBePowered) {
                    this.passingTrainUUID = null;
                }
            }
        }
        if ((blockState = this.method_11010()).method_28498((class_2769)TrackObserverBlock.POWERED)) {
            this.field_11863.method_8652(this.field_11867, (class_2680)blockState.method_11657((class_2769)TrackObserverBlock.POWERED, (Comparable)Boolean.valueOf(shouldBePowered)), 3);
        }
        DisplayLinkBlock.notifyGatherers((class_1936)this.field_11863, this.field_11867);
    }

    @Nullable
    public TrackObserver getObserver() {
        return this.edgePoint.getEdgePoint();
    }

    public class_1799 getFilter() {
        return this.filtering.getFilter();
    }

    public boolean isBlockPowered() {
        return this.method_11010().method_28500((class_2769)TrackObserverBlock.POWERED).orElse(false);
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return new class_238(this.field_11867, this.edgePoint.getGlobalPosition()).method_1014(2.0);
    }

    @Override
    public void transform(class_2586 be, StructureTransform transform) {
        this.edgePoint.transform(be, transform);
    }

    public FilteringBehaviour createFilter() {
        return new FilteringBehaviour(this, new ValueBoxTransform(){

            @Override
            public void rotate(class_1936 level, class_2338 pos, class_2680 state, class_4587 ms) {
                TransformStack.of((class_4587)ms).rotateXDegrees(90.0f);
            }

            @Override
            public class_243 getLocalOffset(class_1936 level, class_2338 pos, class_2680 state) {
                return new class_243(0.5, 0.96875, 0.5);
            }
        });
    }
}

