/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.bogey;

import com.simibubi.create.AllBogeyStyles;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.bogey.BogeyRenderer;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyVisual;
import com.simibubi.create.content.trains.bogey.BogeyVisualizer;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import io.github.fabricators_of_create.porting_lib.util.EnvExecutor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.jetbrains.annotations.Nullable;

public class BogeyStyle {
    public final class_2960 id;
    public final class_2960 cycleGroup;
    public final class_2561 displayName;
    public final Supplier<class_3414> soundEvent;
    public final class_2394 contactParticle;
    public final class_2394 smokeParticle;
    public final class_2487 defaultData;
    private final Map<BogeySizes.BogeySize, Supplier<? extends AbstractBogeyBlock<?>>> sizes;
    @Environment(value=EnvType.CLIENT)
    private Map<BogeySizes.BogeySize, SizeRenderer> sizeRenderers;

    public BogeyStyle(class_2960 id, class_2960 cycleGroup, class_2561 displayName, Supplier<class_3414> soundEvent, class_2394 contactParticle, class_2394 smokeParticle, class_2487 defaultData, Map<BogeySizes.BogeySize, Supplier<? extends AbstractBogeyBlock<?>>> sizes, Map<BogeySizes.BogeySize, Supplier<Supplier<? extends SizeRenderer>>> sizeRenderers) {
        this.id = id;
        this.cycleGroup = cycleGroup;
        this.displayName = displayName;
        this.soundEvent = soundEvent;
        this.contactParticle = contactParticle;
        this.smokeParticle = smokeParticle;
        this.defaultData = defaultData;
        this.sizes = sizes;
        EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> {
            this.sizeRenderers = new HashMap<BogeySizes.BogeySize, SizeRenderer>();
            sizeRenderers.forEach((k, v) -> this.sizeRenderers.put((BogeySizes.BogeySize)k, (SizeRenderer)((Supplier)v.get()).get()));
        });
    }

    public Map<class_2960, BogeyStyle> getCycleGroup() {
        return AllBogeyStyles.getCycleGroup(this.cycleGroup);
    }

    public Set<BogeySizes.BogeySize> validSizes() {
        return this.sizes.keySet();
    }

    public AbstractBogeyBlock<?> getBlockForSize(BogeySizes.BogeySize size) {
        return this.sizes.get(size).get();
    }

    public AbstractBogeyBlock<?> getNextBlock(BogeySizes.BogeySize currentSize) {
        return Stream.iterate(currentSize.nextBySize(), BogeySizes.BogeySize::nextBySize).filter(this.sizes::containsKey).findFirst().map(this::getBlockForSize).orElse(this.getBlockForSize(currentSize));
    }

    @Environment(value=EnvType.CLIENT)
    public void render(BogeySizes.BogeySize size, float partialTick, class_4587 poseStack, class_4597 buffers, int light, int overlay, float wheelAngle, @Nullable class_2487 bogeyData, boolean inContraption) {
        if (bogeyData == null) {
            bogeyData = new class_2487();
        }
        poseStack.method_22904(0.0, -1.5078125, 0.0);
        SizeRenderer renderer = this.sizeRenderers.get(size);
        if (renderer != null) {
            renderer.renderer.render(bogeyData, wheelAngle, partialTick, poseStack, buffers, light, overlay, inContraption);
        }
    }

    @Environment(value=EnvType.CLIENT)
    @Nullable
    public BogeyVisual createVisual(BogeySizes.BogeySize size, VisualizationContext ctx, float partialTick, boolean inContraption) {
        SizeRenderer renderer = this.sizeRenderers.get(size);
        if (renderer != null) {
            return renderer.visualizer.createVisual(ctx, partialTick, inContraption);
        }
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    public record SizeRenderer(BogeyRenderer renderer, BogeyVisualizer visualizer) {
    }

    public static class Builder {
        protected final class_2960 id;
        protected final class_2960 cycleGroup;
        protected final Map<BogeySizes.BogeySize, Supplier<? extends AbstractBogeyBlock<?>>> sizes = new HashMap();
        protected class_2561 displayName = CreateLang.translateDirect("bogey.style.invalid", new Object[0]);
        protected Supplier<class_3414> soundEvent = AllSoundEvents.TRAIN2::getMainEvent;
        protected class_2394 contactParticle = class_2398.field_11205;
        protected class_2394 smokeParticle = class_2398.field_11203;
        protected class_2487 defaultData = new class_2487();
        protected final Map<BogeySizes.BogeySize, Supplier<Supplier<? extends SizeRenderer>>> sizeRenderers = new HashMap<BogeySizes.BogeySize, Supplier<Supplier<? extends SizeRenderer>>>();

        public Builder(class_2960 id, class_2960 cycleGroup) {
            this.id = id;
            this.cycleGroup = cycleGroup;
        }

        public Builder displayName(class_2561 displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder soundEvent(Supplier<class_3414> soundEvent) {
            this.soundEvent = soundEvent;
            return this;
        }

        public Builder contactParticle(class_2394 contactParticle) {
            this.contactParticle = contactParticle;
            return this;
        }

        public Builder smokeParticle(class_2394 smokeParticle) {
            this.smokeParticle = smokeParticle;
            return this;
        }

        public Builder defaultData(class_2487 defaultData) {
            this.defaultData = defaultData;
            return this;
        }

        public Builder size(BogeySizes.BogeySize size, Supplier<? extends AbstractBogeyBlock<?>> block, Supplier<Supplier<? extends SizeRenderer>> renderer) {
            this.sizes.put(size, block);
            EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> this.lambda$size$0(size, (Supplier)renderer));
            return this;
        }

        public BogeyStyle build() {
            BogeyStyle entry = new BogeyStyle(this.id, this.cycleGroup, this.displayName, this.soundEvent, this.contactParticle, this.smokeParticle, this.defaultData, this.sizes, this.sizeRenderers);
            AllBogeyStyles.BOGEY_STYLES.put(this.id, entry);
            AllBogeyStyles.CYCLE_GROUPS.computeIfAbsent(this.cycleGroup, l -> new HashMap()).put(this.id, entry);
            return entry;
        }

        private /* synthetic */ void lambda$size$0(BogeySizes.BogeySize size, Supplier renderer) {
            this.sizeRenderers.put(size, renderer);
        }
    }
}

