/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.thresholdSwitch;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.compat.thresholdSwitch.ThresholdSwitchCompat;
import com.simibubi.create.content.processing.recipe.ProcessingInventory;
import com.simibubi.create.content.redstone.DirectedDirectionalBlock;
import com.simibubi.create.content.redstone.FilteredDetectorFilterSlot;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlock;
import com.simibubi.create.content.redstone.thresholdSwitch.ThresholdSwitchBlock;
import com.simibubi.create.content.redstone.thresholdSwitch.ThresholdSwitchObservable;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.CapManipulationBehaviourBase;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.TankManipulationBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.util.StorageProvider;
import java.util.List;
import java.util.Objects;
import net.createmod.catnip.math.BlockFace;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1953;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_5250;

public class ThresholdSwitchBlockEntity
extends SmartBlockEntity {
    public int onWhenAbove = 128;
    public int offWhenBelow = 64;
    public int currentMinLevel;
    public int currentLevel = -1;
    public int currentMaxLevel;
    public boolean inStacks;
    private boolean redstoneState = false;
    private boolean inverted = false;
    private boolean poweredAfterDelay = false;
    private FilteringBehaviour filtering;
    private InvManipulationBehaviour observedInventory;
    private TankManipulationBehaviour observedTank;
    private VersionedInventoryTrackerBehaviour invVersionTracker;
    private static final List<ThresholdSwitchCompat> COMPAT = List.of();

    public ThresholdSwitchBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        this.onWhenAbove = compound.method_10550("OnAboveAmount");
        this.offWhenBelow = compound.method_10550("OffBelowAmount");
        this.currentLevel = compound.method_10550("CurrentAmount");
        this.currentMinLevel = compound.method_10550("CurrentMinAmount");
        this.currentMaxLevel = compound.method_10550("CurrentMaxAmount");
        this.inStacks = compound.method_10577("InStacks");
        this.redstoneState = compound.method_10577("Powered");
        this.inverted = compound.method_10577("Inverted");
        this.poweredAfterDelay = compound.method_10577("PoweredAfterDelay");
        super.read(compound, clientPacket);
    }

    protected void writeCommon(class_2487 compound) {
        compound.method_10548("OnAboveAmount", (float)this.onWhenAbove);
        compound.method_10548("OffBelowAmount", (float)this.offWhenBelow);
        compound.method_10556("Inverted", this.inverted);
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        this.writeCommon(compound);
        compound.method_10569("CurrentAmount", this.currentLevel);
        compound.method_10569("CurrentMinAmount", this.currentMinLevel);
        compound.method_10569("CurrentMaxAmount", this.currentMaxLevel);
        compound.method_10556("InStacks", this.inStacks);
        compound.method_10556("Powered", this.redstoneState);
        compound.method_10556("PoweredAfterDelay", this.poweredAfterDelay);
        super.write(compound, clientPacket);
    }

    @Override
    public void writeSafe(class_2487 compound) {
        this.writeCommon(compound);
        super.writeSafe(compound);
    }

    public int getMinLevel() {
        return this.currentMinLevel;
    }

    public int getStockLevel() {
        return this.currentLevel;
    }

    public int getMaxLevel() {
        return this.currentMaxLevel;
    }

    public void updateCurrentLevel() {
        if (Transaction.isOpen()) {
            return;
        }
        Objects.requireNonNull(this.field_11863);
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        this.method_31664(state);
        boolean changed = false;
        int prevLevel = this.currentLevel;
        int prevMaxLevel = this.currentMaxLevel;
        this.observedInventory.findNewCapability();
        this.observedTank.findNewCapability();
        class_2338 target = this.getTargetPos();
        class_2586 targetBlockEntity = this.field_11863.method_8321(target);
        this.observedInventory.findNewCapability();
        this.observedTank.findNewCapability();
        if (targetBlockEntity instanceof ThresholdSwitchObservable) {
            ThresholdSwitchObservable observable = (ThresholdSwitchObservable)targetBlockEntity;
            this.currentMinLevel = observable.getMinValue();
            this.currentLevel = observable.getCurrentValue();
            this.currentMaxLevel = observable.getMaxValue();
        } else if (this.observedInventory.hasInventory() || this.observedTank.hasInventory()) {
            long count;
            long space;
            this.currentMinLevel = 0;
            this.currentLevel = 0;
            this.currentMaxLevel = 0;
            if (this.observedInventory.hasInventory()) {
                Storage inv = this.observedInventory.getInventory();
                if (this.invVersionTracker.stillWaiting(inv)) {
                    this.currentLevel = prevLevel;
                    this.currentMaxLevel = prevMaxLevel;
                } else {
                    this.invVersionTracker.awaitNewVersion(inv);
                    for (StorageView view : inv) {
                        space = view.getCapacity();
                        count = view.getAmount();
                        if (space == 0L) continue;
                        this.currentMaxLevel = (int)((long)this.currentMaxLevel + space);
                        if (!this.filtering.test(((ItemVariant)view.getResource()).toStack())) continue;
                        this.currentLevel = (int)((long)this.currentLevel + count);
                    }
                }
            }
            if (this.observedTank.hasInventory()) {
                Storage tank = this.observedTank.getInventory();
                for (StorageView view : tank) {
                    space = view.getCapacity();
                    count = view.getAmount();
                    if (space == 0L) continue;
                    this.currentMaxLevel = (int)((long)this.currentMaxLevel + space);
                    if (!this.filtering.test(new FluidStack(view))) continue;
                    this.currentLevel = (int)((long)this.currentLevel + count);
                }
            }
        } else {
            this.currentMinLevel = -1;
            this.currentMaxLevel = -1;
            if (this.currentLevel == -1) {
                return;
            }
            this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)ThresholdSwitchBlock.LEVEL, (Comparable)Integer.valueOf(0)), 3);
            this.currentLevel = -1;
            this.redstoneState = false;
            this.sendData();
            this.scheduleBlockTick();
            return;
        }
        this.currentLevel = class_3532.method_15340((int)this.currentLevel, (int)this.currentMinLevel, (int)this.currentMaxLevel);
        changed = this.currentLevel != prevLevel;
        boolean previouslyPowered = this.redstoneState;
        if (this.redstoneState && this.currentLevel <= this.offWhenBelow) {
            this.redstoneState = false;
        } else if (!this.redstoneState && this.currentLevel >= this.onWhenAbove) {
            this.redstoneState = true;
        }
        boolean update = previouslyPowered != this.redstoneState;
        int displayLevel = 0;
        float normedLevel = (float)(this.currentLevel - this.currentMinLevel) / (float)(this.currentMaxLevel - this.currentMinLevel);
        if (this.currentLevel > 0) {
            displayLevel = (int)(1.0f + normedLevel * 4.0f);
        }
        this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)ThresholdSwitchBlock.LEVEL, (Comparable)Integer.valueOf(displayLevel)), update ? 3 : 2);
        if (update) {
            this.scheduleBlockTick();
        }
        if (changed || update) {
            DisplayLinkBlock.notifyGatherers((class_1936)this.field_11863, this.field_11867);
            this.notifyUpdate();
        }
    }

    private boolean isSuitableInventory(Storage<ItemVariant> storage, StorageProvider<ItemVariant> provider) {
        if (AllBlocks.STOCK_TICKER.has(provider.findBlockState())) {
            return false;
        }
        return !(storage instanceof ProcessingInventory);
    }

    private class_2338 getTargetPos() {
        return this.field_11867.method_10093(ThresholdSwitchBlock.getTargetDirection(this.method_11010()));
    }

    public class_1799 getDisplayItemForScreen() {
        class_2338 target = this.getTargetPos();
        return new class_1799((class_1935)this.field_11863.method_8320(target).method_26204());
    }

    public class_5250 format(int value, boolean stacks) {
        class_2586 class_25862;
        ThresholdType type = this.getTypeOfCurrentTarget();
        if (type == ThresholdType.CUSTOM && (class_25862 = this.field_11863.method_8321(this.getTargetPos())) instanceof ThresholdSwitchObservable) {
            ThresholdSwitchObservable tso = (ThresholdSwitchObservable)class_25862;
            return tso.format(value);
        }
        String suffix = type == ThresholdType.ITEM ? (stacks ? "schedule.condition.threshold.stacks" : "schedule.condition.threshold.items") : "schedule.condition.threshold.buckets";
        return CreateLang.text(value + " ").add(CreateLang.translate(suffix, new Object[0])).component();
    }

    public ThresholdType getTypeOfCurrentTarget() {
        if (this.observedInventory.hasInventory()) {
            return ThresholdType.ITEM;
        }
        if (this.observedTank.hasInventory()) {
            return ThresholdType.FLUID;
        }
        if (this.field_11863.method_8321(this.getTargetPos()) instanceof ThresholdSwitchObservable) {
            return ThresholdType.CUSTOM;
        }
        return ThresholdType.UNSUPPORTED;
    }

    protected void scheduleBlockTick() {
        class_2248 block = this.method_11010().method_26204();
        if (!this.field_11863.method_8397().method_8677(this.field_11867, (Object)block)) {
            this.field_11863.method_39280(this.field_11867, block, 2, class_1953.field_9314);
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.field_11863.field_9236) {
            return;
        }
        this.updateCurrentLevel();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.filtering = new FilteringBehaviour(this, new FilteredDetectorFilterSlot(true)).withCallback($ -> {
            this.updateCurrentLevel();
            this.invVersionTracker.reset();
        });
        behaviours.add(this.filtering);
        this.invVersionTracker = new VersionedInventoryTrackerBehaviour(this);
        behaviours.add(this.invVersionTracker);
        CapManipulationBehaviourBase.InterfaceProvider towardBlockFacing = (w, p, s) -> new BlockFace(p, DirectedDirectionalBlock.getTargetDirection(s));
        this.observedInventory = (InvManipulationBehaviour)((InvManipulationBehaviour)new InvManipulationBehaviour(this, towardBlockFacing).bypassSidedness()).withFilter(this::isSuitableInventory);
        behaviours.add(this.observedInventory);
        this.observedTank = (TankManipulationBehaviour)new TankManipulationBehaviour(this, towardBlockFacing).bypassSidedness();
        behaviours.add(this.observedTank);
    }

    public float getLevelForDisplay() {
        return this.currentLevel == -1 ? 0.0f : (float)this.currentLevel;
    }

    public boolean getState() {
        return this.redstoneState;
    }

    public boolean shouldBePowered() {
        return this.inverted != this.redstoneState;
    }

    public void updatePowerAfterDelay() {
        this.poweredAfterDelay = this.shouldBePowered();
        this.field_11863.method_8408(this.field_11867, this.method_11010().method_26204());
        this.sendData();
    }

    public boolean isPowered() {
        return this.poweredAfterDelay;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        if (inverted == this.inverted) {
            return;
        }
        this.inverted = inverted;
        this.updatePowerAfterDelay();
    }

    public static enum ThresholdType {
        UNSUPPORTED,
        ITEM,
        FLUID,
        CUSTOM;

    }
}

