/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.displayLink.target;

import com.simibubi.create.api.behaviour.display.DisplaySource;
import com.simibubi.create.api.behaviour.display.DisplayTarget;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.source.SingleLineDisplaySource;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.simibubi.create.content.trains.display.FlapDisplayBlockEntity;
import com.simibubi.create.content.trains.display.FlapDisplayLayout;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_5250;

public class DisplayBoardTarget
extends DisplayTarget {
    @Override
    public void acceptText(int line, List<class_5250> text, DisplayLinkContext context) {
    }

    public void acceptFlapText(int line, List<List<class_5250>> text, DisplayLinkContext context) {
        FlapDisplayBlockEntity controller = this.getController(context);
        if (controller == null) {
            return;
        }
        if (!controller.isSpeedRequirementFulfilled()) {
            return;
        }
        DisplaySource source = context.blockEntity().activeSource;
        List<FlapDisplayLayout> lines = controller.getLines();
        int i = 0;
        while (i + line < lines.size()) {
            if (i == 0) {
                DisplayBoardTarget.reserve(i + line, controller, context);
            }
            if (i > 0 && this.isReserved(i + line, controller, context)) break;
            FlapDisplayLayout layout = lines.get(i + line);
            if (i >= text.size()) {
                if (source instanceof SingleLineDisplaySource) break;
                controller.applyTextManually(i + line, null);
            } else {
                List<class_5250> textLine;
                source.loadFlapDisplayLayout(context, controller, layout, i);
                for (int sectionIndex = 0; sectionIndex < layout.getSections().size() && (textLine = text.get(i)).size() > sectionIndex; ++sectionIndex) {
                    layout.getSections().get(sectionIndex).setText((class_2561)textLine.get(sectionIndex));
                }
            }
            ++i;
        }
        controller.sendData();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isReserved(int line, class_2586 target, DisplayLinkContext context) {
        if (super.isReserved(line, target, context)) return true;
        if (!(target instanceof FlapDisplayBlockEntity)) return false;
        FlapDisplayBlockEntity fdte = (FlapDisplayBlockEntity)target;
        if (fdte.manualLines.length <= line) return false;
        if (!fdte.manualLines[line]) return false;
        return true;
    }

    @Override
    public DisplayTargetStats provideStats(DisplayLinkContext context) {
        FlapDisplayBlockEntity controller = this.getController(context);
        if (controller == null) {
            return new DisplayTargetStats(1, 1, this);
        }
        return new DisplayTargetStats(controller.ySize * 2, controller.getMaxCharCount(), this);
    }

    private FlapDisplayBlockEntity getController(DisplayLinkContext context) {
        class_2586 teIn = context.getTargetBlockEntity();
        if (!(teIn instanceof FlapDisplayBlockEntity)) {
            return null;
        }
        FlapDisplayBlockEntity be = (FlapDisplayBlockEntity)teIn;
        return be.getController();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_238 getMultiblockBounds(class_1936 level, class_2338 pos) {
        class_238 baseShape = super.getMultiblockBounds(level, pos);
        class_2586 be = level.method_8321(pos);
        if (!(be instanceof FlapDisplayBlockEntity)) {
            return baseShape;
        }
        FlapDisplayBlockEntity fdbe = (FlapDisplayBlockEntity)be;
        FlapDisplayBlockEntity controller = fdbe.getController();
        if (controller == null) {
            return baseShape;
        }
        class_2382 normal = controller.getDirection().method_10170().method_10163();
        return baseShape.method_996(controller.method_11016().method_10059((class_2382)pos)).method_1012((double)(normal.method_10263() * (controller.xSize - 1)), (double)(1 - controller.ySize), (double)(normal.method_10260() * (controller.xSize - 1)));
    }
}

