/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.depot.storage;

import com.mojang.serialization.Codec;
import com.simibubi.create.AllMountedStorageTypes;
import com.simibubi.create.api.contraption.storage.SyncedMountedStorage;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageType;
import com.simibubi.create.api.contraption.storage.item.WrapperMountedItemStorage;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.logistics.depot.DepotBlockEntity;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3499;
import org.jetbrains.annotations.Nullable;

public class DepotMountedStorage
extends WrapperMountedItemStorage<Handler>
implements SyncedMountedStorage {
    public static final Codec<DepotMountedStorage> CODEC = class_1799.field_24671.xmap(DepotMountedStorage::new, DepotMountedStorage::getItem);
    private boolean dirty;

    protected DepotMountedStorage(class_1799 stack) {
        this((MountedItemStorageType)AllMountedStorageTypes.DEPOT.get(), stack);
    }

    protected DepotMountedStorage(MountedItemStorageType<?> type, class_1799 stack) {
        super(type, new Handler(stack));
        ((Handler)this.wrapped).onChange = () -> {
            this.dirty = true;
        };
    }

    @Override
    public void unmount(class_1937 level, class_2680 state, class_2338 pos, @Nullable class_2586 be) {
        if (be instanceof DepotBlockEntity) {
            DepotBlockEntity depot = (DepotBlockEntity)be;
            depot.setHeldItem(this.getStackInSlot(0));
        }
    }

    @Override
    public boolean handleInteraction(class_3222 player, Contraption contraption, class_3499.class_3501 info) {
        return false;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void markClean() {
        this.dirty = false;
    }

    @Override
    public void afterSync(Contraption contraption, class_2338 localPos) {
        class_2586 be = contraption.getBlockEntityClientSide(localPos);
        if (be instanceof DepotBlockEntity) {
            DepotBlockEntity depot = (DepotBlockEntity)be;
            depot.setHeldItem(this.getItem());
        }
    }

    public void setItem(class_1799 stack) {
        this.setStackInSlot(0, stack);
    }

    public class_1799 getItem() {
        return this.getStackInSlot(0);
    }

    public static DepotMountedStorage fromDepot(DepotBlockEntity depot) {
        class_1799 held = depot.getHeldItem();
        return new DepotMountedStorage(held.method_7972());
    }

    public static DepotMountedStorage fromLegacy(class_2487 nbt) {
        ItemStackHandler handler = new ItemStackHandler();
        handler.deserializeNBT(nbt);
        if (handler.getSlotCount() == 1) {
            class_1799 stack = handler.getStackInSlot(0);
            return new DepotMountedStorage(stack);
        }
        return new DepotMountedStorage(class_1799.field_8037);
    }

    public static final class Handler
    extends ItemStackHandler {
        private Runnable onChange = () -> {};

        private Handler(class_1799 stack) {
            super(1);
            this.setStackInSlot(0, stack);
        }

        protected void onContentsChanged(int slot) {
            this.onChange.run();
        }
    }
}

