/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.deployer;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.OrientedContraptionEntity;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.mounted.MountedContraption;
import com.simibubi.create.content.contraptions.render.ActorVisual;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.kinetics.deployer.DeployerActorVisual;
import com.simibubi.create.content.kinetics.deployer.DeployerBlock;
import com.simibubi.create.content.kinetics.deployer.DeployerBlockEntity;
import com.simibubi.create.content.kinetics.deployer.DeployerFakePlayer;
import com.simibubi.create.content.kinetics.deployer.DeployerHandler;
import com.simibubi.create.content.kinetics.deployer.DeployerRenderer;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.content.schematics.SchematicInstances;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.createmod.catnip.levelWrappers.SchematicLevel;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.nbt.NBTHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedSlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4597;
import org.apache.commons.lang3.tuple.Pair;

public class DeployerMovementBehaviour
implements MovementBehaviour {
    @Override
    public class_243 getActiveAreaOffset(MovementContext context) {
        return class_243.method_24954((class_2382)((class_2350)context.state.method_11654((class_2769)DeployerBlock.FACING)).method_10163()).method_1021(2.0);
    }

    @Override
    public void visitNewPosition(MovementContext context, class_2338 pos) {
        if (context.world.field_9236) {
            return;
        }
        this.tryGrabbingItem(context);
        DeployerFakePlayer player = this.getPlayer(context);
        DeployerBlockEntity.Mode mode = this.getMode(context);
        if (mode == DeployerBlockEntity.Mode.USE && !DeployerHandler.shouldActivate(player.method_6047(), context.world, pos, null)) {
            return;
        }
        this.activate(context, pos, player, mode);
        this.checkForTrackPlacementAdvancement(context, player);
        this.tryDisposeOfExcess(context);
        context.stall = player.blockBreakingProgress != null;
    }

    public void activate(MovementContext context, class_2338 pos, DeployerFakePlayer player, DeployerBlockEntity.Mode mode) {
        class_1937 world = context.world;
        player.placedTracks = false;
        FilterItemStack filter = context.getFilterFromBE();
        if (AllItems.SCHEMATIC.isIn(filter.item())) {
            this.activateAsSchematicPrinter(context, pos, player, world, filter.item());
            return;
        }
        class_243 facingVec = class_243.method_24954((class_2382)((class_2350)context.state.method_11654((class_2769)DeployerBlock.FACING)).method_10163());
        facingVec = (class_243)context.rotation.apply(facingVec);
        class_243 vec = context.position.method_1020(facingVec.method_1021(2.0));
        float xRot = AbstractContraptionEntity.pitchFromVector(facingVec) - 90.0f;
        if (Math.abs(xRot) > 89.0f) {
            class_243 initial = new class_243(0.0, 0.0, 1.0);
            AbstractContraptionEntity abstractContraptionEntity = context.contraption.entity;
            if (abstractContraptionEntity instanceof OrientedContraptionEntity) {
                OrientedContraptionEntity oce = (OrientedContraptionEntity)abstractContraptionEntity;
                initial = VecHelper.rotate((class_243)initial, (double)oce.getInitialYaw(), (class_2350.class_2351)class_2350.class_2351.field_11052);
            }
            if ((abstractContraptionEntity = context.contraption.entity) instanceof CarriageContraptionEntity) {
                CarriageContraptionEntity cce = (CarriageContraptionEntity)abstractContraptionEntity;
                initial = VecHelper.rotate((class_243)initial, (double)90.0, (class_2350.class_2351)class_2350.class_2351.field_11052);
            }
            facingVec = (class_243)context.rotation.apply(initial);
        }
        player.method_36456(AbstractContraptionEntity.yawFromVector(facingVec));
        player.method_36457(xRot);
        DeployerHandler.activate(player, vec, pos, facingVec, mode);
    }

    protected void checkForTrackPlacementAdvancement(MovementContext context, DeployerFakePlayer player) {
        if ((context.contraption instanceof MountedContraption || context.contraption instanceof CarriageContraption) && player.placedTracks && context.blockEntityData != null && context.blockEntityData.method_10545("Owner")) {
            AllAdvancements.SELF_DEPLOYING.awardTo(context.world.method_18470(context.blockEntityData.method_25926("Owner")));
        }
    }

    protected void activateAsSchematicPrinter(MovementContext context, class_2338 pos, DeployerFakePlayer player, class_1937 world, class_1799 filter) {
        class_1799 contextStack;
        if (!filter.method_7985()) {
            return;
        }
        if (!world.method_8320(pos).method_45474()) {
            return;
        }
        class_2487 tag = filter.method_7969();
        if (!tag.method_10577("Deployed")) {
            return;
        }
        SchematicLevel schematicWorld = SchematicInstances.get(world, filter);
        if (schematicWorld == null) {
            return;
        }
        if (!schematicWorld.getBounds().method_14662((class_2382)pos.method_10059((class_2382)schematicWorld.anchor))) {
            return;
        }
        class_2680 blockState = schematicWorld.method_8320(pos);
        ItemRequirement requirement = ItemRequirement.of(blockState, schematicWorld.method_8321(pos));
        if (requirement.isInvalid() || requirement.isEmpty()) {
            return;
        }
        if (AllBlocks.BELT.has(blockState)) {
            return;
        }
        List<ItemRequirement.StackRequirement> requiredItems = requirement.getRequiredItems();
        class_1799 class_17992 = contextStack = requiredItems.isEmpty() ? class_1799.field_8037 : requiredItems.get((int)0).stack;
        if (!context.contraption.hasUniversalCreativeCrate) {
            CombinedSlottedStorage<ItemVariant, ? extends SlottedStorage<ItemVariant>> itemHandler = context.contraption.getStorage().getAllItems();
            try (Transaction t = TransferUtil.getTransaction();){
                for (ItemRequirement.StackRequirement required : requiredItems) {
                    int count = required.stack.method_7947();
                    ResourceAmount resource = TransferUtil.extractMatching(itemHandler, required::matches, (long)count, (TransactionContext)t);
                    if (resource != null && resource.amount() == (long)count) continue;
                    return;
                }
                t.commit();
            }
        }
        class_2487 data = BlockHelper.prepareBlockEntityData(blockState, schematicWorld.method_8321(pos));
        BlockHelper.placeSchematicBlock(world, blockState, pos, contextStack, data);
        if (blockState.method_26204() instanceof class_2241 || blockState.method_26204() instanceof ITrackBlock) {
            player.placedTracks = true;
        }
    }

    @Override
    public void tick(MovementContext context) {
        if (context.world.field_9236) {
            return;
        }
        if (!context.stall) {
            return;
        }
        DeployerFakePlayer player = this.getPlayer(context);
        DeployerBlockEntity.Mode mode = this.getMode(context);
        Pair<class_2338, Float> blockBreakingProgress = player.blockBreakingProgress;
        if (blockBreakingProgress != null) {
            int timer = context.data.method_10550("Timer");
            if (timer < 20) {
                context.data.method_10569("Timer", ++timer);
                return;
            }
            context.data.method_10551("Timer");
            this.activate(context, (class_2338)blockBreakingProgress.getKey(), player, mode);
            this.tryDisposeOfExcess(context);
        }
        context.stall = player.blockBreakingProgress != null;
    }

    @Override
    public void cancelStall(MovementContext context) {
        if (context.world.field_9236) {
            return;
        }
        MovementBehaviour.super.cancelStall(context);
        DeployerFakePlayer player = this.getPlayer(context);
        if (player == null) {
            return;
        }
        if (player.blockBreakingProgress == null) {
            return;
        }
        context.world.method_8517(player.method_5628(), (class_2338)player.blockBreakingProgress.getKey(), -1);
        player.blockBreakingProgress = null;
    }

    @Override
    public void stopMoving(MovementContext context) {
        if (context.world.field_9236) {
            return;
        }
        DeployerFakePlayer player = this.getPlayer(context);
        if (player == null) {
            return;
        }
        this.cancelStall(context);
        context.blockEntityData.method_10566("Inventory", (class_2520)player.method_31548().method_7384(new class_2499()));
        player.method_31472();
    }

    private void tryGrabbingItem(MovementContext context) {
        DeployerFakePlayer player = this.getPlayer(context);
        if (player == null) {
            return;
        }
        if (player.method_6047().method_7960()) {
            FilterItemStack filter = context.getFilterFromBE();
            if (AllItems.SCHEMATIC.isIn(filter.item())) {
                return;
            }
            class_1799 held = ItemHelper.extract(context.contraption.getStorage().getAllItems(), stack -> filter.test(context.world, (class_1799)stack), 1, false);
            player.method_6122(class_1268.field_5808, held);
        }
    }

    private void tryDisposeOfExcess(MovementContext context) {
        DeployerFakePlayer player = this.getPlayer(context);
        if (player == null) {
            return;
        }
        class_1661 inv = player.method_31548();
        FilterItemStack filter = context.getFilterFromBE();
        for (List list : Arrays.asList(inv.field_7548, inv.field_7544, inv.field_7547)) {
            for (int i = 0; i < list.size(); ++i) {
                class_1799 itemstack = (class_1799)list.get(i);
                if (itemstack.method_7960() || list == inv.field_7547 && i == inv.field_7545 && filter.test(context.world, itemstack)) continue;
                this.dropItem(context, itemstack);
                list.set(i, class_1799.field_8037);
            }
        }
    }

    @Override
    public void writeExtraData(MovementContext context) {
        DeployerFakePlayer player = this.getPlayer(context);
        if (player == null) {
            return;
        }
        context.data.method_10566("HeldItem", NBTSerializer.serializeNBT((Object)player.method_6047()));
    }

    private DeployerFakePlayer getPlayer(MovementContext context) {
        if (!(context.temporaryData instanceof DeployerFakePlayer) && context.world instanceof class_3218) {
            UUID owner = context.blockEntityData.method_10545("Owner") ? context.blockEntityData.method_25926("Owner") : null;
            DeployerFakePlayer deployerFakePlayer = new DeployerFakePlayer((class_3218)context.world, owner);
            deployerFakePlayer.onMinecartContraption = context.contraption instanceof MountedContraption;
            deployerFakePlayer.method_31548().method_7397(context.blockEntityData.method_10554("Inventory", 10));
            if (context.data.method_10545("HeldItem")) {
                deployerFakePlayer.method_6122(class_1268.field_5808, class_1799.method_7915((class_2487)context.data.method_10562("HeldItem")));
            }
            context.blockEntityData.method_10551("Inventory");
            context.temporaryData = deployerFakePlayer;
        }
        return (DeployerFakePlayer)((Object)context.temporaryData);
    }

    private DeployerBlockEntity.Mode getMode(MovementContext context) {
        return (DeployerBlockEntity.Mode)NBTHelper.readEnum((class_2487)context.blockEntityData, (String)"Mode", DeployerBlockEntity.Mode.class);
    }

    @Override
    public boolean disableBlockEntityRendering() {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, class_4597 buffers) {
        if (!VisualizationManager.supportsVisualization((class_1936)context.world)) {
            DeployerRenderer.renderInContraption(context, renderWorld, matrices, buffers);
        }
    }

    @Override
    @Nullable
    @Environment(value=EnvType.CLIENT)
    public ActorVisual createVisual(VisualizationContext visualizationContext, VirtualRenderWorld simulationWorld, MovementContext movementContext) {
        return new DeployerActorVisual(visualizationContext, simulationWorld, movementContext);
    }
}

