/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.clock;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.clock.CuckooClockBlock;
import com.simibubi.create.content.kinetics.clock.CuckooClockBlockEntity;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

public class CuckooClockRenderer
extends KineticBlockEntityRenderer<CuckooClockBlockEntity> {
    public CuckooClockRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    protected void renderSafe(CuckooClockBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        super.renderSafe(be, partialTicks, ms, buffer, light, overlay);
        if (!(be instanceof CuckooClockBlockEntity)) {
            return;
        }
        class_2680 blockState = be.method_11010();
        class_2350 direction = (class_2350)blockState.method_11654(CuckooClockBlock.HORIZONTAL_FACING);
        class_4588 vb = buffer.getBuffer(class_1921.method_23577());
        SuperByteBuffer hourHand = CachedBuffers.partial((PartialModel)AllPartialModels.CUCKOO_HOUR_HAND, (class_2680)blockState);
        SuperByteBuffer minuteHand = CachedBuffers.partial((PartialModel)AllPartialModels.CUCKOO_MINUTE_HAND, (class_2680)blockState);
        float hourAngle = be.hourHand.getValue(partialTicks);
        float minuteAngle = be.minuteHand.getValue(partialTicks);
        this.rotateHand(hourHand, hourAngle, direction).light(light).renderInto(ms, vb);
        this.rotateHand(minuteHand, minuteAngle, direction).light(light).renderInto(ms, vb);
        SuperByteBuffer leftDoor = CachedBuffers.partial((PartialModel)AllPartialModels.CUCKOO_LEFT_DOOR, (class_2680)blockState);
        SuperByteBuffer rightDoor = CachedBuffers.partial((PartialModel)AllPartialModels.CUCKOO_RIGHT_DOOR, (class_2680)blockState);
        float angle = 0.0f;
        float offset = 0.0f;
        if (be.animationType != null) {
            float value = be.animationProgress.getValue(partialTicks);
            int step = be.animationType == CuckooClockBlockEntity.Animation.SURPRISE ? 3 : 15;
            for (int phase = 30; phase <= 60; phase += step) {
                float local = value - (float)phase;
                if (local < (float)(-step / 3)) continue;
                if (local < 0.0f) {
                    angle = class_3532.method_16439((float)((value - (float)(phase - 5)) / 5.0f), (float)0.0f, (float)135.0f);
                    continue;
                }
                if (local < (float)(step / 3)) {
                    angle = 135.0f;
                    continue;
                }
                if (!(local < (float)(2 * step / 3))) continue;
                angle = class_3532.method_16439((float)((value - (float)(phase + 5)) / 5.0f), (float)135.0f, (float)0.0f);
            }
        }
        this.rotateDoor(leftDoor, angle, true, direction).light(light).renderInto(ms, vb);
        this.rotateDoor(rightDoor, angle, false, direction).light(light).renderInto(ms, vb);
        if (be.animationType != CuckooClockBlockEntity.Animation.NONE) {
            offset = -(angle / 135.0f) * 1.0f / 2.0f + 0.625f;
            PartialModel partialModel = be.animationType == CuckooClockBlockEntity.Animation.PIG ? AllPartialModels.CUCKOO_PIG : AllPartialModels.CUCKOO_CREEPER;
            SuperByteBuffer figure = CachedBuffers.partial((PartialModel)partialModel, (class_2680)blockState);
            figure.rotateCentered(AngleHelper.rad((double)AngleHelper.horizontalAngle((class_2350)direction.method_10160())), class_2350.field_11036);
            figure.translate(offset, 0.0f, 0.0f);
            figure.light(light).renderInto(ms, vb);
        }
    }

    @Override
    protected SuperByteBuffer getRotatedModel(CuckooClockBlockEntity be, class_2680 state) {
        return CachedBuffers.partialFacing((PartialModel)AllPartialModels.SHAFT_HALF, (class_2680)state, (class_2350)((class_2350)state.method_11654(CuckooClockBlock.HORIZONTAL_FACING)).method_10153());
    }

    private SuperByteBuffer rotateHand(SuperByteBuffer buffer, float angle, class_2350 facing) {
        float pivotX = 0.125f;
        float pivotY = 0.375f;
        float pivotZ = 0.5f;
        buffer.rotateCentered(AngleHelper.rad((double)AngleHelper.horizontalAngle((class_2350)facing.method_10160())), class_2350.field_11036);
        buffer.translate(pivotX, pivotY, pivotZ);
        buffer.rotate(AngleHelper.rad((double)angle), class_2350.field_11034);
        buffer.translate(-pivotX, -pivotY, -pivotZ);
        return buffer;
    }

    private SuperByteBuffer rotateDoor(SuperByteBuffer buffer, float angle, boolean left, class_2350 facing) {
        float pivotX = 0.125f;
        float pivotY = 0.0f;
        float pivotZ = (float)(left ? 6 : 10) / 16.0f;
        buffer.rotateCentered(AngleHelper.rad((double)AngleHelper.horizontalAngle((class_2350)facing.method_10160())), class_2350.field_11036);
        buffer.translate(pivotX, pivotY, pivotZ);
        buffer.rotate(AngleHelper.rad((double)angle) * (float)(left ? -1 : 1), class_2350.field_11036);
        buffer.translate(-pivotX, -pivotY, -pivotZ);
        return buffer;
    }
}

