/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.fixes.worldgen.threading_issues.common.debug;

import com.ishland.c2me.fixes.worldgen.threading_issues.common.debug.SMAPPool;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.service.MixinService;

public class SMAPSourceDebugExtension {
    private final String generatedFileName;
    private final String firstStratum;
    private final Map<Integer, FileInfo> fileinfo = new HashMap<Integer, FileInfo>();
    private final Map<Integer, int[]> reverseLineMapping = new HashMap<Integer, int[]>();
    private static final Pattern LINE_INFO_PATTERN = Pattern.compile("([0-9]+)(?:#([0-9]+))?(?:,([0-9]+))?:([0-9]+)(?:,([0-9]+))?");

    public static void enhanceStackTrace(Throwable t, boolean keepOriginalFrames) {
        SMAPSourceDebugExtension.enhanceStackTrace(t, (Map<String, SMAPSourceDebugExtension>)new Object2ReferenceOpenHashMap(), keepOriginalFrames);
    }

    public static void enhanceStackTrace(Throwable t, Map<String, SMAPSourceDebugExtension> cache, boolean keepOriginalFrames) {
        StackTraceElement[] elements = t.getStackTrace();
        ArrayList<StackTraceElement> newElements = null;
        for (int i = 0; i < elements.length; ++i) {
            FileInfo inputFileInfo;
            int[] inputLineInfo;
            String className = elements[i].getClassName();
            SMAPSourceDebugExtension smap = SMAPSourceDebugExtension.getSMAPSourceDebugExtension(className, cache);
            StackTraceElement newFrame = null;
            if (smap != null && (inputLineInfo = smap.reverseLineMapping.get(elements[i].getLineNumber())) != null && elements[i].getFileName().equals(smap.generatedFileName) && (inputFileInfo = smap.fileinfo.get(inputLineInfo[0])) != null) {
                IMixinInfo mixin = SMAPSourceDebugExtension.findMixin(inputFileInfo.path);
                String classSource = SMAPSourceDebugExtension.findClassSource(className);
                newFrame = new StackTraceElement(elements[i].getClassLoaderName(), elements[i].getModuleName(), elements[i].getModuleVersion(), elements[i].getClassName(), elements[i].getMethodName(), SMAPSourceDebugExtension.findBestName(inputFileInfo.name, inputFileInfo.path, "Unspecified") + (mixin != null ? " [%s]".formatted(mixin.getConfig().getName()) : ""), inputLineInfo[1]);
            }
            if (newFrame != null) {
                if (newElements == null) {
                    newElements = new ArrayList<StackTraceElement>(Arrays.asList(elements).subList(0, i));
                }
                if (keepOriginalFrames) {
                    newElements.add(elements[i]);
                }
                newElements.add(newFrame);
                continue;
            }
            if (newElements == null) continue;
            newElements.add(elements[i]);
        }
        if (newElements != null) {
            t.setStackTrace((StackTraceElement[])newElements.toArray(StackTraceElement[]::new));
        }
        if (t.getCause() != null) {
            SMAPSourceDebugExtension.enhanceStackTrace(t.getCause(), cache, keepOriginalFrames);
        }
        if (t.getSuppressed() != null) {
            for (Throwable throwable : t.getSuppressed()) {
                SMAPSourceDebugExtension.enhanceStackTrace(throwable, cache, keepOriginalFrames);
            }
        }
    }

    @Nullable
    public static SMAPSourceDebugExtension getSMAPSourceDebugExtension(String className, Map<String, SMAPSourceDebugExtension> cache) {
        SMAPSourceDebugExtension smap = cache.get(className);
        if (smap == null) {
            String value = SMAPPool.getSourceDebugInfo(className);
            if (value == null) {
                try {
                    ClassNode classNode = MixinService.getService().getBytecodeProvider().getClassNode(className.replace('.', '/'));
                    if (classNode != null) {
                        value = classNode.sourceDebug;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (value != null && (value = value.replaceAll("\r\n?", "\n")).startsWith("SMAP\n")) {
                smap = new SMAPSourceDebugExtension(value);
                cache.put(className, smap);
            }
        }
        return smap;
    }

    private static String findClassSource(String className) {
        Path path;
        Class<?> clazz;
        try {
            clazz = Class.forName(className, false, SMAPSourceDebugExtension.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        if (protectionDomain == null) {
            return null;
        }
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null) {
            return null;
        }
        URL url = codeSource.getLocation();
        if (url == null) {
            return null;
        }
        try {
            path = switch (url.getProtocol()) {
                case "file" -> Paths.get(url.toURI());
                case "jar" -> Paths.get(new URL(url.getPath()).getPath().split("!")[0], new String[0]);
                default -> null;
            };
        }
        catch (MalformedURLException | URISyntaxException e) {
            return null;
        }
        if (path == null) {
            return null;
        }
        Path gameDir = FabricLoader.getInstance().getGameDir().toAbsolutePath().normalize();
        return gameDir.relativize(path).toString();
    }

    public static IMixinInfo getMixinConfigFor(String className, int lineNumber, Map<String, SMAPSourceDebugExtension> cache) {
        FileInfo inputFileInfo;
        int[] inputLineInfo;
        SMAPSourceDebugExtension smap = SMAPSourceDebugExtension.getSMAPSourceDebugExtension(className, cache);
        if (smap != null && (inputLineInfo = smap.reverseLineMapping.get(lineNumber)) != null && (inputFileInfo = smap.fileinfo.get(inputLineInfo[0])) != null) {
            return SMAPSourceDebugExtension.findMixin(inputFileInfo.path);
        }
        return null;
    }

    private static String findBestName(String name, String path, String fallback) {
        if (path != null) {
            return path;
        }
        if (name != null && !name.equals("null")) {
            return name;
        }
        return fallback;
    }

    private static IMixinInfo findMixin(String path) {
        Iterator iterator;
        ClassInfo info;
        if (path != null && path.endsWith(".java") && (info = ClassInfo.fromCache((String)path.substring(0, path.length() - 5))) != null && info.isMixin() && (iterator = info.getAppliedMixins().iterator()).hasNext()) {
            return (IMixinInfo)iterator.next();
        }
        return null;
    }

    private SMAPSourceDebugExtension(String value) {
        String[] lines = value.split("\n");
        if (!(lines[0].equals("SMAP") && lines[3].startsWith("*S ") && lines[4].equals("*F"))) {
            throw new IllegalArgumentException(value);
        }
        this.generatedFileName = lines[1];
        this.firstStratum = lines[3].substring(3);
        int idx = 5;
        while (!lines[idx].startsWith("*")) {
            String infoline = lines[idx++];
            String path = null;
            if (infoline.startsWith("+ ")) {
                path = lines[idx++];
                infoline = infoline.substring(2);
            }
            int pos = infoline.indexOf(" ");
            int filenum = Integer.parseInt(infoline.substring(0, pos));
            String name = infoline.substring(pos + 1);
            this.fileinfo.put(filenum, new FileInfo(name, path == null ? name : path));
        }
        if (lines[idx].equals("*L")) {
            ++idx;
            int lastLFI = 0;
            while (!lines[idx].startsWith("*")) {
                Matcher m;
                if (!(m = LINE_INFO_PATTERN.matcher(lines[idx++])).matches()) {
                    throw new IllegalArgumentException(lines[idx - 1]);
                }
                int inputStartLine = Integer.parseInt(m.group(1));
                int lineFileID = m.group(2) == null ? lastLFI : Integer.parseInt(m.group(2));
                int repeatCount = m.group(3) == null ? 1 : Integer.parseInt(m.group(3));
                int outputStartLine = Integer.parseInt(m.group(4));
                int outputLineIncrement = m.group(5) == null ? 1 : Integer.parseInt(m.group(5));
                for (int i = 0; i < repeatCount; ++i) {
                    int baseOL;
                    int[] inputMapping = new int[]{lineFileID, inputStartLine + i};
                    for (int ol = baseOL = outputStartLine + i * outputLineIncrement; ol < baseOL + outputLineIncrement; ++ol) {
                        if (this.reverseLineMapping.containsKey(ol)) continue;
                        this.reverseLineMapping.put(ol, inputMapping);
                    }
                }
                lastLFI = lineFileID;
            }
        }
    }

    private static class FileInfo {
        public final String name;
        public final String path;

        public FileInfo(String name, String path) {
            this.name = name;
            this.path = path;
        }
    }
}

