/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.ftech_equipment.networking;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import uk.co.cablepost.ftech_equipment.FTechEquipment;
import uk.co.cablepost.ftech_equipment.backpack.inventory.BackpackInventoryMenu;
import uk.co.cablepost.ftech_equipment.networking.handler.AttackToggleHandler;
import uk.co.cablepost.ftech_equipment.networking.handler.BuildInstructionsReplicateHandler;
import uk.co.cablepost.ftech_equipment.networking.handler.DrillSlotActionHandler;
import uk.co.cablepost.ftech_equipment.networking.handler.InventoryActionHandler;
import uk.co.cablepost.ftech_equipment.networking.handler.ItemPickupToggleHandler;
import uk.co.cablepost.ftech_equipment.networking.handler.LocomotionToggleHandler;
import uk.co.cablepost.ftech_equipment.networking.handler.LocomotionVelocitySyncHandler;
import uk.co.cablepost.ftech_equipment.networking.handler.OpenInventoryHandler;
import uk.co.cablepost.ftech_equipment.networking.handler.UpgradeSlotActionHandler;
import uk.co.cablepost.ftech_equipment.networking.handler.WeaponSlotActionHandler;

public class FTechEquipmentNetworking {
    public static void registerServerReceivers() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)FTechEquipment.BACKPACK_OPEN_INVENTORY_PACKET_ID, (buf, context) -> context.queue(() -> {
            class_1657 patt0$temp = context.getPlayer();
            if (patt0$temp instanceof class_3222) {
                class_3222 player = (class_3222)patt0$temp;
                OpenInventoryHandler.handle(player);
            }
        }));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)FTechEquipment.BACKPACK_INVENTORY_ACTION_PACKET_ID, (buf, context) -> {
            boolean inventory = buf.readBoolean();
            int slot = buf.readInt();
            boolean mouseButton = buf.readBoolean();
            boolean shiftHeld = buf.readBoolean();
            context.queue(() -> {
                class_1657 patt0$temp = context.getPlayer();
                if (patt0$temp instanceof class_3222) {
                    class_3222 player = (class_3222)patt0$temp;
                    InventoryActionHandler.handle(player, inventory, slot, mouseButton, shiftHeld);
                }
            });
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)FTechEquipment.BACKPACK_UPGRADE_SLOT_ACTION_PACKET_ID, (buf, context) -> {
            int slotIndex = buf.readInt();
            boolean rightClick = buf.readBoolean();
            boolean shiftHeld = buf.readBoolean();
            context.queue(() -> {
                class_1657 patt0$temp = context.getPlayer();
                if (patt0$temp instanceof class_3222) {
                    class_3222 player = (class_3222)patt0$temp;
                    UpgradeSlotActionHandler.handle(player, slotIndex, rightClick, shiftHeld);
                }
            });
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)FTechEquipment.BACKPACK_DRILL_SLOT_ACTION_PACKET_ID, (buf, context) -> {
            int armOrdinal = buf.readInt();
            boolean rightClick = buf.readBoolean();
            boolean shiftHeld = buf.readBoolean();
            context.queue(() -> {
                class_1657 patt0$temp = context.getPlayer();
                if (patt0$temp instanceof class_3222) {
                    class_3222 player = (class_3222)patt0$temp;
                    DrillSlotActionHandler.handle(player, armOrdinal, rightClick, shiftHeld);
                }
            });
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)FTechEquipment.BACKPACK_WEAPON_SLOT_ACTION_PACKET_ID, (buf, context) -> {
            int armOrdinal = buf.readInt();
            boolean rightClick = buf.readBoolean();
            boolean shiftHeld = buf.readBoolean();
            context.queue(() -> {
                class_1657 patt0$temp = context.getPlayer();
                if (patt0$temp instanceof class_3222) {
                    class_3222 player = (class_3222)patt0$temp;
                    WeaponSlotActionHandler.handle(player, armOrdinal, rightClick, shiftHeld);
                }
            });
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)FTechEquipment.BACKPACK_ITEM_PICKUP_TOGGLE_PACKET_ID, (buf, context) -> {
            boolean enabled = buf.readBoolean();
            context.queue(() -> {
                class_1657 patt0$temp = context.getPlayer();
                if (patt0$temp instanceof class_3222) {
                    class_3222 player = (class_3222)patt0$temp;
                    ItemPickupToggleHandler.handle(player, enabled);
                }
            });
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)FTechEquipment.BACKPACK_ATTACK_TOGGLE_PACKET_ID, (buf, context) -> {
            boolean enabled = buf.readBoolean();
            context.queue(() -> {
                class_1657 patt0$temp = context.getPlayer();
                if (patt0$temp instanceof class_3222) {
                    class_3222 player = (class_3222)patt0$temp;
                    AttackToggleHandler.handle(player, enabled);
                }
            });
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)FTechEquipment.BACKPACK_LOCOMOTION_TOGGLE_PACKET_ID, (buf, context) -> {
            boolean enabled = buf.readBoolean();
            context.queue(() -> {
                class_1657 patt0$temp = context.getPlayer();
                if (patt0$temp instanceof class_3222) {
                    class_3222 player = (class_3222)patt0$temp;
                    LocomotionToggleHandler.handle(player, enabled);
                }
            });
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)FTechEquipment.BACKPACK_BUILD_INSTRUCTIONS_REPLICATE_PACKET_ID, (buf, context) -> {
            boolean enabled = buf.readBoolean();
            int extendLeft = buf.readInt();
            int extendRight = buf.readInt();
            int extendUp = buf.readInt();
            int extendDown = buf.readInt();
            context.queue(() -> {
                class_1657 patt0$temp = context.getPlayer();
                if (patt0$temp instanceof class_3222) {
                    class_3222 player = (class_3222)patt0$temp;
                    BuildInstructionsReplicateHandler.handle(player, enabled, extendLeft, extendRight, extendUp, extendDown);
                }
            });
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)FTechEquipment.BACKPACK_LOCOMOTION_VELOCITY_SYNC_PACKET_ID, (buf, context) -> {
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            context.queue(() -> {
                class_1657 patt0$temp = context.getPlayer();
                if (patt0$temp instanceof class_3222) {
                    class_3222 player = (class_3222)patt0$temp;
                    LocomotionVelocitySyncHandler.handle(player, x, y, z);
                }
            });
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)FTechEquipment.BACKPACK_UPDATE_MENU_CONTAINER_DATA, (buf, context) -> {
            int slot = buf.readInt();
            int value = buf.readInt();
            context.queue(() -> {
                class_1657 patt0$temp = context.getPlayer();
                if (patt0$temp instanceof class_3222) {
                    class_3222 player = (class_3222)patt0$temp;
                    class_1703 patt1$temp = player.field_7512;
                    if (patt1$temp instanceof BackpackInventoryMenu) {
                        BackpackInventoryMenu menu = (BackpackInventoryMenu)patt1$temp;
                        menu.method_7606(slot, value);
                    }
                }
            });
        });
    }

    public static void sendOpenInventory() {
        class_2540 buf = new class_2540(Unpooled.buffer());
        NetworkManager.sendToServer((class_2960)FTechEquipment.BACKPACK_OPEN_INVENTORY_PACKET_ID, (class_2540)buf);
    }

    public static void sendInventoryAction(boolean inventory, int slot, boolean mouseButton, boolean shiftHeld) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeBoolean(inventory);
        buf.writeInt(slot);
        buf.writeBoolean(mouseButton);
        buf.writeBoolean(shiftHeld);
        NetworkManager.sendToServer((class_2960)FTechEquipment.BACKPACK_INVENTORY_ACTION_PACKET_ID, (class_2540)buf);
    }

    public static void sendUpgradeSlotAction(int slotIndex, boolean rightClick, boolean shiftHeld) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(slotIndex);
        buf.writeBoolean(rightClick);
        buf.writeBoolean(shiftHeld);
        NetworkManager.sendToServer((class_2960)FTechEquipment.BACKPACK_UPGRADE_SLOT_ACTION_PACKET_ID, (class_2540)buf);
    }

    public static void sendDrillSlotAction(int armOrdinal, boolean rightClick, boolean shiftHeld) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(armOrdinal);
        buf.writeBoolean(rightClick);
        buf.writeBoolean(shiftHeld);
        NetworkManager.sendToServer((class_2960)FTechEquipment.BACKPACK_DRILL_SLOT_ACTION_PACKET_ID, (class_2540)buf);
    }

    public static void sendWeaponSlotAction(int armOrdinal, boolean rightClick, boolean shiftHeld) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(armOrdinal);
        buf.writeBoolean(rightClick);
        buf.writeBoolean(shiftHeld);
        NetworkManager.sendToServer((class_2960)FTechEquipment.BACKPACK_WEAPON_SLOT_ACTION_PACKET_ID, (class_2540)buf);
    }

    public static void sendItemPickupToggle(boolean enabled) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeBoolean(enabled);
        NetworkManager.sendToServer((class_2960)FTechEquipment.BACKPACK_ITEM_PICKUP_TOGGLE_PACKET_ID, (class_2540)buf);
    }

    public static void sendAttackToggle(boolean enabled) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeBoolean(enabled);
        NetworkManager.sendToServer((class_2960)FTechEquipment.BACKPACK_ATTACK_TOGGLE_PACKET_ID, (class_2540)buf);
    }

    public static void sendLocomotionToggle(boolean enabled) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeBoolean(enabled);
        NetworkManager.sendToServer((class_2960)FTechEquipment.BACKPACK_LOCOMOTION_TOGGLE_PACKET_ID, (class_2540)buf);
    }

    public static void sendBuildInstructionsReplicateParams(boolean enabled, int extendLeft, int extendRight, int extendUp, int extendDown) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeBoolean(enabled);
        buf.writeInt(extendLeft);
        buf.writeInt(extendRight);
        buf.writeInt(extendUp);
        buf.writeInt(extendDown);
        NetworkManager.sendToServer((class_2960)FTechEquipment.BACKPACK_BUILD_INSTRUCTIONS_REPLICATE_PACKET_ID, (class_2540)buf);
    }

    public static void sendVelocitySync(double x, double y, double z) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeDouble(x);
        buf.writeDouble(y);
        buf.writeDouble(z);
        NetworkManager.sendToServer((class_2960)FTechEquipment.BACKPACK_LOCOMOTION_VELOCITY_SYNC_PACKET_ID, (class_2540)buf);
    }

    public static void sendUpdateMenuData(int slot, int value) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(slot);
        buf.writeInt(value);
        NetworkManager.sendToServer((class_2960)FTechEquipment.BACKPACK_UPDATE_MENU_CONTAINER_DATA, (class_2540)buf);
    }
}

