/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.ftech_equipment.fabric.client.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import uk.co.cablepost.f_tech.client.FTechClientUtils;
import uk.co.cablepost.ftech_equipment.FTechEquipment;
import uk.co.cablepost.ftech_equipment.FTechEquipmentKeybindings;
import uk.co.cablepost.ftech_equipment.backpack.BackpackArm;
import uk.co.cablepost.ftech_equipment.backpack.BackpackItem;
import uk.co.cablepost.ftech_equipment.backpack.BackpackWeaponSlotsComponent;
import uk.co.cablepost.ftech_equipment.fabric.client.screen.BackpackInventoryScreen;
import uk.co.cablepost.ftech_equipment.networking.FTechEquipmentNetworking;

@Environment(value=EnvType.CLIENT)
public class BackpackWeaponSlotsWidget
implements class_4068,
class_364,
class_6379 {
    private final BackpackInventoryScreen parent;
    private final class_310 client;
    private final int x;
    private final int y;
    private final class_1799 backpack;
    private boolean focused;
    private static final int SLOT_SIZE = 18;
    private static final int SLOTS_OFFSET_X = 200;
    private static final int[][] SLOT_POSITIONS = new int[][]{{255, 25}, {235, 50}, {220, 75}, {210, 100}, {315, 25}, {335, 50}, {350, 75}, {360, 100}};
    private static final BackpackArm[] SLOT_TO_ARM = new BackpackArm[]{BackpackArm.TOP_LEFT_UPPER, BackpackArm.TOP_LEFT, BackpackArm.TOP_LEFT_LOWER, BackpackArm.LEFT, BackpackArm.TOP_RIGHT_UPPER, BackpackArm.TOP_RIGHT, BackpackArm.TOP_RIGHT_LOWER, BackpackArm.RIGHT};
    private static final String[] ARM_NAMES = new String[]{"UL", "TL", "LL", "L", "UR", "TR", "LR", "R"};
    private static final int TOGGLE_BUTTON_X = 10;
    private static final int TOGGLE_BUTTON_Y = 25;
    private static final int TOGGLE_BUTTON_WIDTH = 80;
    private static final int TOGGLE_BUTTON_HEIGHT = 20;

    public BackpackWeaponSlotsWidget(BackpackInventoryScreen parent, class_310 client, int x, int y, class_1799 backpack) {
        this.parent = parent;
        this.client = client;
        this.x = x;
        this.y = y + 10;
        this.backpack = backpack;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        class_1799 currentBackpack = FTechEquipment.getBackpackOnPlayer((class_1309)class_310.method_1551().field_1724);
        if (currentBackpack == null) {
            return;
        }
        BackpackWeaponSlotsComponent weaponSlots = BackpackItem.getWeaponSlots(currentBackpack);
        boolean enabled = BackpackItem.isAttackEnabled(currentBackpack);
        guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)"Combat Mode"), this.x + 10, this.y, -1, true);
        String stateText = enabled ? "Enabled" : "Disabled";
        int stateColor = enabled ? -16711936 : -39322;
        guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)stateText), this.x + 10 + 80 + 10, this.y + 25 + 5, stateColor, true);
        int toggleX = this.x + 10;
        int toggleY = this.y + 25;
        boolean toggleHovered = this.isMouseOver(mouseX, mouseY, toggleX, toggleY, 80, 20);
        int buttonColor = toggleHovered ? -10066330 : -12303292;
        guiGraphics.method_25294(toggleX, toggleY, toggleX + 80, toggleY + 20, buttonColor);
        guiGraphics.method_49601(toggleX, toggleY, 80, 20, -7829368);
        String toggleText = enabled ? "Disable" : "Enable";
        int toggleTextWidth = this.client.field_1772.method_1727(toggleText);
        guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)toggleText), toggleX + (80 - toggleTextWidth) / 2, toggleY + 6, -1, false);
        guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)"When enabled, arms will"), this.x + 10, this.y + 60, -5592406, false);
        guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)"attack nearby hostile mobs"), this.x + 10, this.y + 72, -5592406, false);
        guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)"with equipped weapons."), this.x + 10, this.y + 84, -5592406, false);
        guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)"Arm Weapons"), this.x + 200 + 55, this.y, -1, true);
        guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)"Left"), this.x + 200 + 20, this.y + 12, -5592406, false);
        guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)"Right"), this.x + 200 + 140, this.y + 12, -5592406, false);
        for (int i = 0; i < 8; ++i) {
            int slotX = this.x + SLOT_POSITIONS[i][0];
            int slotY = this.y + SLOT_POSITIONS[i][1];
            guiGraphics.method_25290(FTechClientUtils.GUI_SLOT_TEXTURE, slotX - 1, slotY - 1, 0.0f, 0.0f, 18, 18, 18, 18);
            class_1799 weapon = weaponSlots.getWeaponForArm(SLOT_TO_ARM[i]);
            if (weapon != null && !weapon.method_7960()) {
                guiGraphics.method_51427(weapon, slotX, slotY);
                guiGraphics.method_51431(this.client.field_1772, weapon, slotX, slotY);
            }
            guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)ARM_NAMES[i]), slotX + 3, slotY + 18, -7829368, false);
        }
        int hoveredSlot = this.getSlotAt(mouseX, mouseY);
        if (hoveredSlot >= 0) {
            class_1799 weapon = weaponSlots.getWeaponForArm(SLOT_TO_ARM[hoveredSlot]);
            if (weapon != null && !weapon.method_7960()) {
                guiGraphics.method_51446(this.client.field_1772, weapon, mouseX, mouseY);
            } else {
                guiGraphics.method_51437(this.client.field_1772, List.of(class_2561.method_43470((String)"Empty - Click with sword/axe to insert"), class_2561.method_43470((String)"Shift-click to quick transfer")), Optional.empty(), mouseX, mouseY);
            }
        }
        if (this.isMouseOver(mouseX, mouseY, toggleX, toggleY, 80, 20)) {
            ArrayList<class_5250> tooltipLines = new ArrayList<class_5250>();
            tooltipLines.add(class_2561.method_43470((String)(enabled ? "Disable combat mode" : "Enable combat mode")));
            String keybind = FTechEquipmentKeybindings.BACKPACK_ATTACK_TOGGLE_KEYBINDING.method_16007().getString();
            if (!keybind.equals("key.keyboard.unknown")) {
                tooltipLines.add(class_2561.method_43470((String)("Keybind: " + keybind)).method_27694(s -> s.method_36139(0xAAAAAA)));
            } else {
                tooltipLines.add(class_2561.method_43470((String)"No keybind set").method_27694(s -> s.method_36139(0x888888)));
            }
            guiGraphics.method_51437(this.client.field_1772, tooltipLines, Optional.empty(), mouseX, mouseY);
        }
    }

    private boolean isMouseOver(double mouseX, double mouseY, int bx, int by, int w, int h) {
        return mouseX >= (double)bx && mouseX < (double)(bx + w) && mouseY >= (double)by && mouseY < (double)(by + h);
    }

    private int getSlotAt(double mouseX, double mouseY) {
        for (int i = 0; i < 8; ++i) {
            int slotX = this.x + SLOT_POSITIONS[i][0];
            int slotY = this.y + SLOT_POSITIONS[i][1];
            if (!(mouseX >= (double)slotX) || !(mouseX < (double)(slotX + 16)) || !(mouseY >= (double)slotY) || !(mouseY < (double)(slotY + 16))) continue;
            return i;
        }
        return -1;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        class_1799 currentBackpack = FTechEquipment.getBackpackOnPlayer((class_1309)class_310.method_1551().field_1724);
        if (currentBackpack == null) {
            return false;
        }
        int toggleX = this.x + 10;
        int toggleY = this.y + 25;
        if (this.isMouseOver(mouseX, mouseY, toggleX, toggleY, 80, 20)) {
            boolean currentlyEnabled = BackpackItem.isAttackEnabled(currentBackpack);
            FTechEquipmentNetworking.sendAttackToggle(!currentlyEnabled);
            return true;
        }
        int hoveredSlot = this.getSlotAt(mouseX, mouseY);
        if (hoveredSlot >= 0) {
            FTechEquipmentNetworking.sendWeaponSlotAction(SLOT_TO_ARM[hoveredSlot].ordinal(), false, class_437.method_25442());
            return true;
        }
        return false;
    }

    public void method_25365(boolean focused) {
        this.focused = focused;
    }

    public boolean method_25370() {
        return this.focused;
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 narrationElementOutput) {
    }
}

