/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.ftech_equipment.fabric.client.widget;

import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import uk.co.cablepost.f_tech.client.FTechClientUtils;
import uk.co.cablepost.ftech_equipment.backpack.BackpackItem;
import uk.co.cablepost.ftech_equipment.backpack.BackpackUpgradeSlotsComponent;
import uk.co.cablepost.ftech_equipment.backpack.inventory.BackpackInventoryMenu;
import uk.co.cablepost.ftech_equipment.fabric.client.screen.BackpackInventoryScreen;
import uk.co.cablepost.ftech_equipment.networking.FTechEquipmentNetworking;

@Environment(value=EnvType.CLIENT)
public class BackpackUpgradeSlotsWidget
implements class_4068,
class_364,
class_6379 {
    private final BackpackInventoryScreen parent;
    private final class_310 client;
    private final int x;
    private final int y;
    private final class_1799 backpack;
    private boolean focused;
    private static final int SLOT_SIZE = 18;
    private static final int GRID_COLS = 3;
    private static final int GRID_ROWS = 3;
    private static final int GRID_SPACING = 2;
    private static final int GRID_OFFSET_X = 100;
    private static final int GRID_OFFSET_Y = 30;

    public BackpackUpgradeSlotsWidget(BackpackInventoryScreen parent, class_310 client, int x, int y, class_1799 backpack) {
        this.parent = parent;
        this.client = client;
        this.x = x;
        this.y = y;
        this.backpack = backpack;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        BackpackUpgradeSlotsComponent upgradeSlots = BackpackItem.getUpgradeSlots(this.backpack);
        guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)"Backpack Upgrades"), this.x + 100 + 10, this.y + 10, -1, true);
        int currentItems = BackpackItem.getCurrentItemCount(this.backpack);
        int maxCapacity = BackpackItem.getMaxCapacity(this.backpack);
        String capacityText = "Capacity: " + currentItems + " / " + maxCapacity + " items";
        guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)capacityText), this.x + 100 - 10, this.y + 30 + 60 + 10, (double)currentItems > (double)maxCapacity * 0.9 ? -39322 : -5592406, false);
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                int slotIndex = row * 3 + col;
                int slotX = this.x + 100 + col * 20;
                int slotY = this.y + 30 + row * 20;
                guiGraphics.method_25290(FTechClientUtils.GUI_SLOT_TEXTURE, slotX - 1, slotY - 1, 0.0f, 0.0f, 18, 18, 18, 18);
                class_1799 upgrade = upgradeSlots.getSlot(slotIndex);
                if (upgrade == null || upgrade.method_7960()) continue;
                guiGraphics.method_51427(upgrade, slotX, slotY);
                guiGraphics.method_51431(this.client.field_1772, upgrade, slotX, slotY);
            }
        }
        guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)"Click to insert/remove upgrades"), this.x + 100 - 20, this.y + 30 + 60 + 25, -10066330, false);
        int hoveredSlot = this.getSlotAt(mouseX, mouseY);
        if (hoveredSlot >= 0) {
            class_1799 upgrade = upgradeSlots.getSlot(hoveredSlot);
            if (upgrade != null && !upgrade.method_7960()) {
                guiGraphics.method_51446(this.client.field_1772, upgrade, mouseX, mouseY);
            } else {
                guiGraphics.method_51437(this.client.field_1772, List.of(class_2561.method_43470((String)"Empty Upgrade Slot"), ((BackpackInventoryMenu)this.parent.method_17577()).getUpgradeAlreadyInstalledAnimationState() == 0 ? class_2561.method_43470((String)"Click with upgrade to insert").method_27694(s -> s.method_36139(0x888888)) : class_2561.method_43470((String)"This upgrade is already installed").method_27694(s -> s.method_36139(0xFF0000))), Optional.empty(), mouseX + 3, mouseY);
            }
        }
    }

    private int getSlotAt(double mouseX, double mouseY) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                int slotIndex = row * 3 + col;
                int slotX = this.x + 100 + col * 20;
                int slotY = this.y + 30 + row * 20;
                if (!(mouseX >= (double)slotX) || !(mouseX < (double)(slotX + 16)) || !(mouseY >= (double)slotY) || !(mouseY < (double)(slotY + 16))) continue;
                return slotIndex;
            }
        }
        return -1;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int hoveredSlot = this.getSlotAt(mouseX, mouseY);
        if (hoveredSlot < 0) {
            return false;
        }
        FTechEquipmentNetworking.sendUpgradeSlotAction(hoveredSlot, button == 1, class_437.method_25442());
        return true;
    }

    public void method_25365(boolean focused) {
        this.focused = focused;
    }

    public boolean method_25370() {
        return this.focused;
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 narrationElementOutput) {
    }
}

