/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.ftech_equipment.fabric.client.widget;

import java.util.ArrayList;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import uk.co.cablepost.ftech_equipment.FTechEquipment;
import uk.co.cablepost.ftech_equipment.FTechEquipmentKeybindings;
import uk.co.cablepost.ftech_equipment.backpack.BackpackItem;
import uk.co.cablepost.ftech_equipment.backpack.locomotion.LocomotionController;
import uk.co.cablepost.ftech_equipment.fabric.client.screen.BackpackInventoryScreen;
import uk.co.cablepost.ftech_equipment.networking.FTechEquipmentNetworking;

@Environment(value=EnvType.CLIENT)
public class BackpackLocomotionWidget
implements class_4068,
class_364,
class_6379 {
    private final BackpackInventoryScreen parent;
    private final class_310 client;
    private final int x;
    private final int y;
    private final class_1799 backpack;
    private boolean focused;
    private static final int BUTTON_WIDTH = 80;
    private static final int BUTTON_HEIGHT = 20;

    public BackpackLocomotionWidget(BackpackInventoryScreen parent, class_310 client, int x, int y, class_1799 backpack) {
        this.parent = parent;
        this.client = client;
        this.x = x + 20;
        this.y = y + 10;
        this.backpack = backpack;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        class_1799 currentBackpack = FTechEquipment.getBackpackOnPlayer((class_1309)class_310.method_1551().field_1724);
        if (currentBackpack == null) {
            return;
        }
        boolean enabled = BackpackItem.isLocomotionEnabled(currentBackpack);
        int grabbingArms = LocomotionController.countGrabbingArms(currentBackpack);
        guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)"Locomotion Configuration"), this.x + 50, this.y, -1, true);
        String stateText = "Locomotion: " + (enabled ? "Enabled" : "Disabled");
        int stateColor = enabled ? -16711936 : -39322;
        guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)stateText), this.x + 50, this.y + 30, stateColor, true);
        if (enabled) {
            String armsText = "Arms Grabbing: " + grabbingArms + "/" + LocomotionController.MIN_ARMS_FOR_LOCOMOTION + "+";
            int armsColor = grabbingArms >= LocomotionController.MIN_ARMS_FOR_LOCOMOTION ? -16711936 : -22016;
            guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)armsText), this.x + 50, this.y + 45, armsColor, false);
        }
        int buttonX = this.x + 70;
        int buttonY = this.y + 65;
        boolean hovered = mouseX >= buttonX && mouseX < buttonX + 80 && mouseY >= buttonY && mouseY < buttonY + 20;
        int buttonColor = hovered ? -10066330 : -12303292;
        guiGraphics.method_25294(buttonX, buttonY, buttonX + 80, buttonY + 20, buttonColor);
        guiGraphics.method_49601(buttonX, buttonY, 80, 20, -7829368);
        String buttonText = enabled ? "Disable" : "Enable";
        int textWidth = this.client.field_1772.method_1727(buttonText);
        guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)buttonText), buttonX + (80 - textWidth) / 2, buttonY + 6, -1, false);
        guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)"Arms grab block surfaces to propel you."), this.x, this.y + 100, -5592406, false);
        guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)("Requires " + LocomotionController.MIN_ARMS_FOR_LOCOMOTION + "+ arms grabbing to hover.")), this.x, this.y + 112, -5592406, false);
        guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)"Use WASD to move, Space to rise, Crouch to fall."), this.x, this.y + 124, -5592406, false);
        if (mouseX >= buttonX && mouseX < buttonX + 80 && mouseY >= buttonY && mouseY < buttonY + 20) {
            ArrayList<class_5250> tooltipLines = new ArrayList<class_5250>();
            tooltipLines.add(class_2561.method_43470((String)(enabled ? "Disable locomotion" : "Enable locomotion")));
            String keybind = FTechEquipmentKeybindings.BACKPACK_LOCOMOTION_TOGGLE_KEYBINDING.method_16007().getString();
            if (!keybind.equals("key.keyboard.unknown")) {
                tooltipLines.add(class_2561.method_43470((String)("Keybind: " + keybind)).method_27694(s -> s.method_36139(0xAAAAAA)));
            } else {
                tooltipLines.add(class_2561.method_43470((String)"No keybind set").method_27694(s -> s.method_36139(0x888888)));
            }
            guiGraphics.method_51437(this.client.field_1772, tooltipLines, Optional.empty(), mouseX, mouseY);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        class_1799 currentBackpack = FTechEquipment.getBackpackOnPlayer((class_1309)class_310.method_1551().field_1724);
        if (currentBackpack == null) {
            return false;
        }
        int buttonX = this.x + 70;
        int buttonY = this.y + 65;
        if (mouseX >= (double)buttonX && mouseX < (double)(buttonX + 80) && mouseY >= (double)buttonY && mouseY < (double)(buttonY + 20)) {
            boolean currentlyEnabled = BackpackItem.isLocomotionEnabled(currentBackpack);
            FTechEquipmentNetworking.sendLocomotionToggle(!currentlyEnabled);
            return true;
        }
        return false;
    }

    public void method_25365(boolean focused) {
        this.focused = focused;
    }

    public boolean method_25370() {
        return this.focused;
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 narrationElementOutput) {
    }
}

