/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.ftech_equipment.fabric.client.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import uk.co.cablepost.f_tech.client.FTechClientUtils;
import uk.co.cablepost.ftech_equipment.FTechEquipment;
import uk.co.cablepost.ftech_equipment.FTechEquipmentKeybindings;
import uk.co.cablepost.ftech_equipment.backpack.BackpackArm;
import uk.co.cablepost.ftech_equipment.backpack.BackpackDrillSlotsComponent;
import uk.co.cablepost.ftech_equipment.backpack.BackpackItem;
import uk.co.cablepost.ftech_equipment.backpack.build_instructions_client.BackpackBuildInstructionsReplicateParamsComponent;
import uk.co.cablepost.ftech_equipment.fabric.client.screen.BackpackInventoryScreen;
import uk.co.cablepost.ftech_equipment.networking.FTechEquipmentNetworking;

@Environment(value=EnvType.CLIENT)
public class BackpackDrillSlotsWidget
implements class_4068,
class_364,
class_6379 {
    private final BackpackInventoryScreen parent;
    private final class_310 client;
    private final int x;
    private final int y;
    private final class_1799 backpack;
    private boolean focused;
    private static final int SLOT_SIZE = 18;
    private static final int SLOTS_OFFSET_X = 200;
    private static final int[][] SLOT_POSITIONS = new int[][]{{255, 25}, {235, 50}, {220, 75}, {210, 100}, {315, 25}, {335, 50}, {350, 75}, {360, 100}};
    private static final BackpackArm[] SLOT_TO_ARM = new BackpackArm[]{BackpackArm.TOP_LEFT_UPPER, BackpackArm.TOP_LEFT, BackpackArm.TOP_LEFT_LOWER, BackpackArm.LEFT, BackpackArm.TOP_RIGHT_UPPER, BackpackArm.TOP_RIGHT, BackpackArm.TOP_RIGHT_LOWER, BackpackArm.RIGHT};
    private static final String[] ARM_NAMES = new String[]{"UL", "TL", "LL", "L", "UR", "TR", "LR", "R"};
    private static final int TOGGLE_BUTTON_X = 10;
    private static final int TOGGLE_BUTTON_Y = 25;
    private static final int TOGGLE_BUTTON_WIDTH = 80;
    private static final int TOGGLE_BUTTON_HEIGHT = 20;
    private static final int EXTEND_CENTER_X = 90;
    private static final int EXTEND_CENTER_Y = 90;
    private static final int EXTEND_BUTTON_SIZE = 18;
    private int maxRange = 1;

    public BackpackDrillSlotsWidget(BackpackInventoryScreen parent, class_310 client, int x, int y, class_1799 backpack) {
        this.parent = parent;
        this.client = client;
        this.x = x;
        this.y = y + 10;
        this.backpack = backpack;
        this.maxRange = BackpackItem.getMaxRange(backpack);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        class_1799 currentBackpack = FTechEquipment.getBackpackOnPlayer((class_1309)class_310.method_1551().field_1724);
        if (currentBackpack == null) {
            return;
        }
        BackpackDrillSlotsComponent drillSlots = BackpackItem.getDrillSlots(currentBackpack);
        BackpackBuildInstructionsReplicateParamsComponent replicateParams = BackpackItem.getReplicateParams(currentBackpack);
        boolean enabled = replicateParams.enabled();
        guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)"Block Operations"), this.x + 10, this.y, -1, true);
        String stateText = enabled ? "Enabled" : "Disabled";
        int stateColor = enabled ? -16711936 : -39322;
        guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)stateText), this.x + 10 + 80 + 10, this.y + 25 + 5, stateColor, true);
        int toggleX = this.x + 10;
        int toggleY = this.y + 25;
        boolean toggleHovered = this.isMouseOver(mouseX, mouseY, toggleX, toggleY, 80, 20);
        int buttonColor = toggleHovered ? -10066330 : -12303292;
        guiGraphics.method_25294(toggleX, toggleY, toggleX + 80, toggleY + 20, buttonColor);
        guiGraphics.method_49601(toggleX, toggleY, 80, 20, -7829368);
        String toggleText = enabled ? "Disable" : "Enable";
        int toggleTextWidth = this.client.field_1772.method_1727(toggleText);
        guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)toggleText), toggleX + (80 - toggleTextWidth) / 2, toggleY + 6, -1, false);
        guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)"Block Size:"), this.x + 10, this.y + 55, -5592406, false);
        int centerX = this.x + 90;
        int centerY = this.y + 90;
        this.drawExtendButton(guiGraphics, centerX, centerY - 36, "+", mouseX, mouseY, replicateParams.extendUp() < this.maxRange);
        this.drawExtendButton(guiGraphics, centerX, centerY - 18, "-", mouseX, mouseY, replicateParams.extendUp() > 0);
        this.drawExtendButton(guiGraphics, centerX, centerY + 18, "-", mouseX, mouseY, replicateParams.extendDown() > 0);
        this.drawExtendButton(guiGraphics, centerX, centerY + 36, "+", mouseX, mouseY, replicateParams.extendDown() < this.maxRange);
        this.drawExtendButton(guiGraphics, centerX - 36, centerY, "+", mouseX, mouseY, replicateParams.extendLeft() < this.maxRange);
        this.drawExtendButton(guiGraphics, centerX - 18, centerY, "-", mouseX, mouseY, replicateParams.extendLeft() > 0);
        this.drawExtendButton(guiGraphics, centerX + 18, centerY, "-", mouseX, mouseY, replicateParams.extendRight() > 0);
        this.drawExtendButton(guiGraphics, centerX + 36, centerY, "+", mouseX, mouseY, replicateParams.extendRight() < this.maxRange);
        guiGraphics.method_25294(centerX, centerY, centerX + 18, centerY + 18, -13421773);
        String upText = "U:" + replicateParams.extendUp();
        String downText = "D:" + replicateParams.extendDown();
        String leftText = "L:" + replicateParams.extendLeft();
        String rightText = "R:" + replicateParams.extendRight();
        guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)upText), centerX + 9 - this.client.field_1772.method_1727(upText) / 2, centerY - 36 - 10, -3355444, false);
        guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)downText), centerX + 9 - this.client.field_1772.method_1727(downText) / 2, centerY + 54 + 2, -3355444, false);
        guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)leftText), centerX - 36 - this.client.field_1772.method_1727(leftText) - 2, centerY + 5, -3355444, false);
        guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)rightText), centerX + 54 + 2, centerY + 5, -3355444, false);
        guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)"Arm Drills"), this.x + 200 + 60, this.y, -1, true);
        guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)"Left"), this.x + 200 + 20, this.y + 12, -5592406, false);
        guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)"Right"), this.x + 200 + 140, this.y + 12, -5592406, false);
        for (int i = 0; i < 8; ++i) {
            int slotX = this.x + SLOT_POSITIONS[i][0];
            int slotY = this.y + SLOT_POSITIONS[i][1];
            guiGraphics.method_25290(FTechClientUtils.GUI_SLOT_TEXTURE, slotX - 1, slotY - 1, 0.0f, 0.0f, 18, 18, 18, 18);
            class_1799 drill = drillSlots.getDrillForArm(SLOT_TO_ARM[i]);
            if (drill != null && !drill.method_7960()) {
                guiGraphics.method_51427(drill, slotX, slotY);
                guiGraphics.method_51431(this.client.field_1772, drill, slotX, slotY);
            }
            guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)ARM_NAMES[i]), slotX + 3, slotY + 18, -7829368, false);
        }
        int hoveredSlot = this.getSlotAt(mouseX, mouseY);
        if (hoveredSlot >= 0) {
            class_1799 drill = drillSlots.getDrillForArm(SLOT_TO_ARM[hoveredSlot]);
            if (drill != null && !drill.method_7960()) {
                guiGraphics.method_51446(this.client.field_1772, drill, mouseX, mouseY);
            } else {
                guiGraphics.method_51437(this.client.field_1772, List.of(class_2561.method_43470((String)"Empty - Click with drill to insert"), class_2561.method_43470((String)"Shift-click to quick transfer")), Optional.empty(), mouseX, mouseY);
            }
        }
        if (this.isMouseOver(mouseX, mouseY, toggleX, toggleY, 80, 20)) {
            ArrayList<class_5250> tooltipLines = new ArrayList<class_5250>();
            tooltipLines.add(class_2561.method_43470((String)(enabled ? "Disable block operations" : "Enable block operations")));
            String keybind = FTechEquipmentKeybindings.BACKPACK_BUILD_INSTRUCTIONS_TOGGLE_KEYBINDING.method_16007().getString();
            if (!keybind.equals("key.keyboard.unknown")) {
                tooltipLines.add(class_2561.method_43470((String)("Keybind: " + keybind)).method_27694(s -> s.method_36139(0xAAAAAA)));
            } else {
                tooltipLines.add(class_2561.method_43470((String)"No keybind set").method_27694(s -> s.method_36139(0x888888)));
            }
            guiGraphics.method_51437(this.client.field_1772, tooltipLines, Optional.empty(), mouseX, mouseY);
        }
    }

    private void drawExtendButton(class_332 guiGraphics, int bx, int by, String text, int mouseX, int mouseY, boolean active) {
        boolean hovered = this.isMouseOver(mouseX, mouseY, bx, by, 18, 18);
        int color = !active ? -13421773 : (hovered ? -10066330 : -12303292);
        guiGraphics.method_25294(bx, by, bx + 18, by + 18, color);
        guiGraphics.method_49601(bx, by, 18, 18, active ? -7829368 : -11184811);
        int textWidth = this.client.field_1772.method_1727(text);
        int textColor = active ? -1 : -10066330;
        guiGraphics.method_51439(this.client.field_1772, (class_2561)class_2561.method_43470((String)text), bx + (18 - textWidth) / 2, by + 5, textColor, false);
    }

    private boolean isMouseOver(double mouseX, double mouseY, int bx, int by, int w, int h) {
        return mouseX >= (double)bx && mouseX < (double)(bx + w) && mouseY >= (double)by && mouseY < (double)(by + h);
    }

    private int getSlotAt(double mouseX, double mouseY) {
        for (int i = 0; i < 8; ++i) {
            int slotX = this.x + SLOT_POSITIONS[i][0];
            int slotY = this.y + SLOT_POSITIONS[i][1];
            if (!(mouseX >= (double)slotX) || !(mouseX < (double)(slotX + 16)) || !(mouseY >= (double)slotY) || !(mouseY < (double)(slotY + 16))) continue;
            return i;
        }
        return -1;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        class_1799 currentBackpack = FTechEquipment.getBackpackOnPlayer((class_1309)class_310.method_1551().field_1724);
        if (currentBackpack == null) {
            return false;
        }
        BackpackBuildInstructionsReplicateParamsComponent replicateParams = BackpackItem.getReplicateParams(currentBackpack);
        int toggleX = this.x + 10;
        int toggleY = this.y + 25;
        if (this.isMouseOver(mouseX, mouseY, toggleX, toggleY, 80, 20)) {
            this.sendReplicateParams(!replicateParams.enabled(), replicateParams.extendLeft(), replicateParams.extendRight(), replicateParams.extendUp(), replicateParams.extendDown());
            return true;
        }
        int centerX = this.x + 90;
        int centerY = this.y + 90;
        if (this.isMouseOver(mouseX, mouseY, centerX, centerY - 36, 18, 18) && replicateParams.extendUp() < this.maxRange) {
            this.sendReplicateParams(replicateParams.enabled(), replicateParams.extendLeft(), replicateParams.extendRight(), class_3532.method_15340((int)(replicateParams.extendUp() + 1), (int)0, (int)this.maxRange), replicateParams.extendDown());
            return true;
        }
        if (this.isMouseOver(mouseX, mouseY, centerX, centerY - 18, 18, 18) && replicateParams.extendUp() > 0) {
            this.sendReplicateParams(replicateParams.enabled(), replicateParams.extendLeft(), replicateParams.extendRight(), class_3532.method_15340((int)(replicateParams.extendUp() - 1), (int)0, (int)this.maxRange), replicateParams.extendDown());
            return true;
        }
        if (this.isMouseOver(mouseX, mouseY, centerX, centerY + 18, 18, 18) && replicateParams.extendDown() > 0) {
            this.sendReplicateParams(replicateParams.enabled(), replicateParams.extendLeft(), replicateParams.extendRight(), replicateParams.extendUp(), class_3532.method_15340((int)(replicateParams.extendDown() - 1), (int)0, (int)this.maxRange));
            return true;
        }
        if (this.isMouseOver(mouseX, mouseY, centerX, centerY + 36, 18, 18) && replicateParams.extendDown() < this.maxRange) {
            this.sendReplicateParams(replicateParams.enabled(), replicateParams.extendLeft(), replicateParams.extendRight(), replicateParams.extendUp(), class_3532.method_15340((int)(replicateParams.extendDown() + 1), (int)0, (int)this.maxRange));
            return true;
        }
        if (this.isMouseOver(mouseX, mouseY, centerX - 36, centerY, 18, 18) && replicateParams.extendLeft() < this.maxRange) {
            this.sendReplicateParams(replicateParams.enabled(), class_3532.method_15340((int)(replicateParams.extendLeft() + 1), (int)0, (int)this.maxRange), replicateParams.extendRight(), replicateParams.extendUp(), replicateParams.extendDown());
            return true;
        }
        if (this.isMouseOver(mouseX, mouseY, centerX - 18, centerY, 18, 18) && replicateParams.extendLeft() > 0) {
            this.sendReplicateParams(replicateParams.enabled(), class_3532.method_15340((int)(replicateParams.extendLeft() - 1), (int)0, (int)this.maxRange), replicateParams.extendRight(), replicateParams.extendUp(), replicateParams.extendDown());
            return true;
        }
        if (this.isMouseOver(mouseX, mouseY, centerX + 18, centerY, 18, 18) && replicateParams.extendRight() > 0) {
            this.sendReplicateParams(replicateParams.enabled(), replicateParams.extendLeft(), class_3532.method_15340((int)(replicateParams.extendRight() - 1), (int)0, (int)this.maxRange), replicateParams.extendUp(), replicateParams.extendDown());
            return true;
        }
        if (this.isMouseOver(mouseX, mouseY, centerX + 36, centerY, 18, 18) && replicateParams.extendRight() < this.maxRange) {
            this.sendReplicateParams(replicateParams.enabled(), replicateParams.extendLeft(), class_3532.method_15340((int)(replicateParams.extendRight() + 1), (int)0, (int)this.maxRange), replicateParams.extendUp(), replicateParams.extendDown());
            return true;
        }
        int hoveredSlot = this.getSlotAt(mouseX, mouseY);
        if (hoveredSlot >= 0) {
            FTechEquipmentNetworking.sendDrillSlotAction(SLOT_TO_ARM[hoveredSlot].ordinal(), false, class_437.method_25442());
            return true;
        }
        return false;
    }

    private void sendReplicateParams(boolean enabled, int extendLeft, int extendRight, int extendUp, int extendDown) {
        FTechEquipmentNetworking.sendBuildInstructionsReplicateParams(enabled, extendLeft, extendRight, extendUp, extendDown);
    }

    public void method_25365(boolean focused) {
        this.focused = focused;
    }

    public boolean method_25370() {
        return this.focused;
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 narrationElementOutput) {
    }
}

