/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.ftech_equipment.fabric.client.sound;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_310;
import uk.co.cablepost.ftech_equipment.backpack.BackpackArm;
import uk.co.cablepost.ftech_equipment.backpack.BackpackArmComponent;
import uk.co.cablepost.ftech_equipment.backpack.BackpackItem;
import uk.co.cablepost.ftech_equipment.fabric.client.sound.BackpackArmMovingSound;

@Environment(value=EnvType.CLIENT)
public class BackpackArmSoundManager {
    private static final Map<String, BackpackArmMovingSound> activeSounds = new HashMap<String, BackpackArmMovingSound>();
    private static final Map<String, Integer> previousDirections = new HashMap<String, Integer>();
    private static final Map<String, Float> previousProgress = new HashMap<String, Float>();

    public static void updateArmSounds(class_1657 player, class_1799 backpack) {
        if (backpack == null || backpack.method_7960()) {
            BackpackArmSoundManager.stopAllSoundsForPlayer(player);
            return;
        }
        for (BackpackArm arm : BackpackArm.values()) {
            BackpackArmComponent armData = BackpackItem.getArmData(arm, backpack);
            BackpackArmSoundManager.updateArmSound(player, arm, armData);
        }
    }

    private static void updateArmSound(class_1657 player, BackpackArm arm, BackpackArmComponent armData) {
        String key = BackpackArmSoundManager.getKey(player, arm);
        int direction = armData.direction();
        float progress = armData.progress();
        int prevDirection = previousDirections.getOrDefault(key, 0);
        float prevProgress = previousProgress.getOrDefault(key, Float.valueOf(0.0f)).floatValue();
        previousDirections.put(key, direction);
        previousProgress.put(key, Float.valueOf(progress));
        boolean isMoving = direction == 1 && progress < 0.99f || direction == 0 && progress > 0.01f;
        boolean wasMoving = prevDirection == 1 && prevProgress < 0.99f || prevDirection == 0 && prevProgress > 0.01f;
        BackpackArmMovingSound existingSound = activeSounds.get(key);
        if (isMoving) {
            if (existingSound == null || existingSound.isFadingOut()) {
                class_243 armPos = BackpackArmSoundManager.getArmPosition(player, armData);
                BackpackArmMovingSound newSound = new BackpackArmMovingSound(player, arm, armPos);
                activeSounds.put(key, newSound);
                class_310.method_1551().method_1483().method_4873((class_1113)newSound);
            } else {
                class_243 armPos = BackpackArmSoundManager.getArmPosition(player, armData);
                existingSound.updatePosition(armPos);
            }
        } else if (existingSound != null && !existingSound.isFadingOut()) {
            existingSound.stopSound();
            activeSounds.remove(key);
        }
    }

    private static class_243 getArmPosition(class_1657 player, BackpackArmComponent armData) {
        class_243 extendedPos = armData.extendedPos();
        if (extendedPos != null && armData.progress() > 0.01f) {
            class_243 playerPos = player.method_19538().method_1031(0.0, 1.0, 0.0);
            return playerPos.method_35590(extendedPos, (double)armData.progress());
        }
        return player.method_19538().method_1031(0.0, 1.0, 0.0);
    }

    private static String getKey(class_1657 player, BackpackArm arm) {
        return player.method_5845() + "_" + arm.name();
    }

    public static void stopAllSoundsForPlayer(class_1657 player) {
        String playerUuid = player.method_5845();
        activeSounds.entrySet().removeIf(entry -> {
            if (((String)entry.getKey()).startsWith(playerUuid)) {
                ((BackpackArmMovingSound)((Object)((Object)entry.getValue()))).stopSound();
                return true;
            }
            return false;
        });
        previousDirections.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith(playerUuid));
        previousProgress.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith(playerUuid));
    }

    public static void stopAllSounds() {
        for (BackpackArmMovingSound sound : activeSounds.values()) {
            sound.stopSound();
        }
        activeSounds.clear();
        previousDirections.clear();
        previousProgress.clear();
    }
}

