/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.ftech_equipment.fabric.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.time.Instant;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import uk.co.cablepost.f_tech.client.FTechClientUtils;
import uk.co.cablepost.ftech_equipment.FTechEquipment;
import uk.co.cablepost.ftech_equipment.FTechEquipmentKeybindings;
import uk.co.cablepost.ftech_equipment.backpack.BackpackComponent;
import uk.co.cablepost.ftech_equipment.backpack.BackpackItem;
import uk.co.cablepost.ftech_equipment.backpack.inventory.BackpackInventoryMenu;
import uk.co.cablepost.ftech_equipment.backpack.inventory.BackpackItemComponent;
import uk.co.cablepost.ftech_equipment.fabric.client.widget.BackpackDrillSlotsWidget;
import uk.co.cablepost.ftech_equipment.fabric.client.widget.BackpackInventoryListWidget;
import uk.co.cablepost.ftech_equipment.fabric.client.widget.BackpackItemPickupWidget;
import uk.co.cablepost.ftech_equipment.fabric.client.widget.BackpackLocomotionWidget;
import uk.co.cablepost.ftech_equipment.fabric.client.widget.BackpackUpgradeSlotsWidget;
import uk.co.cablepost.ftech_equipment.fabric.client.widget.BackpackWeaponSlotsWidget;
import uk.co.cablepost.ftech_equipment.networking.FTechEquipmentNetworking;

public class BackpackInventoryScreen
extends class_465<BackpackInventoryMenu> {
    private static final class_2960 TAB_ICON_STORAGE = new class_2960("f_tech_equipment", "textures/gui/tabs/inventory.png");
    private static final class_2960 TAB_ICON_UPGRADES = new class_2960("f_tech_equipment", "textures/gui/tabs/upgrades.png");
    private static final class_2960 TAB_ICON_BLOCK_OPS = new class_2960("f_tech_equipment", "textures/gui/tabs/block_operations.png");
    private static final class_2960 TAB_ICON_COMBAT = new class_2960("f_tech_equipment", "textures/gui/tabs/combat.png");
    private static final class_2960 TAB_ICON_ITEM_PICKUP = new class_2960("f_tech_equipment", "textures/gui/tabs/item_pickup.png");
    private static final class_2960 TAB_ICON_LOCOMOTION = new class_2960("f_tech_equipment", "textures/gui/tabs/locomotion.png");
    BackpackInventoryListWidget backpackInventoryListWidget = null;
    BackpackDrillSlotsWidget drillSlotsWidget = null;
    BackpackUpgradeSlotsWidget upgradeSlotsWidget = null;
    BackpackWeaponSlotsWidget weaponSlotsWidget = null;
    BackpackItemPickupWidget itemPickupWidget = null;
    BackpackLocomotionWidget locomotionWidget = null;
    long lastRefreshInventory;
    private Tab currentTab = Tab.STORAGE;
    private static final int TAB_WIDTH = 32;
    private static final int TAB_HEIGHT = 32;
    private static final int TAB_SPACING = 0;
    private int tabY;
    private int tabStartX;
    private boolean hasBlockOpsUpgrade;
    private boolean hasCombatUpgrade;
    private boolean hasItemPickupUpgrade;
    private boolean hasLocomotionUpgrade;
    public static final int UPGRADE_ANIMATION_DURATION = 20;
    private int upgradeAlreadyInstalledAnimationTickCount = 20;
    private int lastAnimationState = 0;
    Random random;

    public BackpackInventoryScreen(BackpackInventoryMenu menu, class_1661 playerInventory, class_2561 title) {
        super((class_1703)menu, playerInventory, title);
        this.field_2792 = 400;
        this.field_2779 = 240;
        this.field_25270 = -9999;
    }

    private void updateUpgradeCache() {
        class_1799 backpack = FTechEquipment.getBackpackOnPlayer((class_1309)class_310.method_1551().field_1724);
        this.hasBlockOpsUpgrade = backpack != null && BackpackItem.hasUpgrade(backpack, (class_1792)FTechEquipment.BLOCK_OPERATIONS_UPGRADE_ITEM.get());
        this.hasCombatUpgrade = backpack != null && BackpackItem.hasUpgrade(backpack, (class_1792)FTechEquipment.COMBAT_UPGRADE_ITEM.get());
        this.hasItemPickupUpgrade = backpack != null && BackpackItem.hasUpgrade(backpack, (class_1792)FTechEquipment.ITEM_PICKUP_UPGRADE_ITEM.get());
        this.hasLocomotionUpgrade = backpack != null && BackpackItem.hasUpgrade(backpack, (class_1792)FTechEquipment.LOCOMOTION_UPGRADE_ITEM.get());
    }

    private int getTabX(Tab tab) {
        int position = 0;
        if (tab == Tab.STORAGE) {
            return this.tabStartX + position * 32;
        }
        ++position;
        if (tab == Tab.UPGRADES) {
            return this.tabStartX + position * 32;
        }
        ++position;
        if (this.hasBlockOpsUpgrade) {
            if (tab == Tab.BLOCK_OPERATIONS) {
                return this.tabStartX + position * 32;
            }
            ++position;
        }
        if (this.hasCombatUpgrade) {
            if (tab == Tab.COMBAT) {
                return this.tabStartX + position * 32;
            }
            ++position;
        }
        if (this.hasItemPickupUpgrade) {
            if (tab == Tab.ITEM_PICKUP) {
                return this.tabStartX + position * 32;
            }
            ++position;
        }
        if (this.hasLocomotionUpgrade) {
            if (tab == Tab.LOCOMOTION) {
                return this.tabStartX + position * 32;
            }
            ++position;
        }
        return this.tabStartX;
    }

    private boolean isTabEnabled(Tab tab) {
        return switch (tab.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0, 1 -> true;
            case 2 -> this.hasBlockOpsUpgrade;
            case 3 -> this.hasCombatUpgrade;
            case 4 -> this.hasItemPickupUpgrade;
            case 5 -> this.hasLocomotionUpgrade;
        };
    }

    protected void method_25426() {
        super.method_25426();
        assert (this.field_22787 != null);
        int panelX = (this.field_22789 - this.field_2792) / 2;
        int panelY = (this.field_22790 - this.field_2779) / 2;
        this.tabY = panelY - 32 + 8;
        this.tabStartX = panelX + 8;
        this.random = new Random();
        class_1799 backpack = FTechEquipment.getBackpackOnPlayer((class_1309)class_310.method_1551().field_1724);
        this.updateUpgradeCache();
        ((BackpackInventoryMenu)this.field_2797).setCurrentTab(this.currentTab.ordinal());
        FTechEquipmentNetworking.sendUpdateMenuData(0, this.currentTab.ordinal());
        if (backpack != null) {
            this.lastRefreshInventory = Instant.now().toEpochMilli();
            this.updateTabContent(backpack);
        }
    }

    private void switchTab(Tab tab) {
        class_1799 backpack;
        if (this.currentTab == tab) {
            return;
        }
        this.currentTab = tab;
        ((BackpackInventoryMenu)this.field_2797).setCurrentTab(tab.ordinal());
        FTechEquipmentNetworking.sendUpdateMenuData(0, tab.ordinal());
        if (this.backpackInventoryListWidget != null) {
            this.method_37066((class_364)this.backpackInventoryListWidget);
            this.backpackInventoryListWidget = null;
        }
        if (this.drillSlotsWidget != null) {
            this.method_37066(this.drillSlotsWidget);
            this.drillSlotsWidget = null;
        }
        if (this.upgradeSlotsWidget != null) {
            this.method_37066(this.upgradeSlotsWidget);
            this.upgradeSlotsWidget = null;
        }
        if (this.weaponSlotsWidget != null) {
            this.method_37066(this.weaponSlotsWidget);
            this.weaponSlotsWidget = null;
        }
        if (this.itemPickupWidget != null) {
            this.method_37066(this.itemPickupWidget);
            this.itemPickupWidget = null;
        }
        if (this.locomotionWidget != null) {
            this.method_37066(this.locomotionWidget);
            this.locomotionWidget = null;
        }
        if ((backpack = FTechEquipment.getBackpackOnPlayer((class_1309)class_310.method_1551().field_1724)) != null) {
            this.updateTabContent(backpack);
        }
    }

    private void updateTabContent(class_1799 backpack) {
        switch (this.currentTab.ordinal()) {
            case 0: {
                this.updateBackpackItemsDisplay(backpack, true);
                break;
            }
            case 1: {
                this.updateUpgradeSlotsDisplay(backpack);
                break;
            }
            case 2: {
                this.updateDrillSlotsDisplay(backpack);
                break;
            }
            case 3: {
                this.updateWeaponSlotsDisplay(backpack);
                break;
            }
            case 4: {
                this.updateItemPickupDisplay(backpack);
                break;
            }
            case 5: {
                this.updateLocomotionDisplay(backpack);
            }
        }
    }

    protected void method_37432() {
        class_1799 backpack = FTechEquipment.getBackpackOnPlayer((class_1309)class_310.method_1551().field_1724);
        if (backpack == null) {
            this.method_25419();
            return;
        }
        int state = ((BackpackInventoryMenu)this.field_2797).getUpgradeAlreadyInstalledAnimationState();
        if (state >= 10 && (this.lastAnimationState < 10 || state != this.lastAnimationState)) {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)class_3417.field_18308.comp_349()), (float)0.5f, (float)0.1f));
        }
        this.lastAnimationState = state;
        if (state == 2) {
            this.resetTickCountFloating();
        } else if (state == 1 && this.upgradeAlreadyInstalledAnimationTickCount-- <= 0) {
            this.resetTickCountFloating();
        }
        if (state >= 100) {
            this.resetTickCountInventory(false);
        } else if (state >= 10 && this.upgradeAlreadyInstalledAnimationTickCount-- <= 0) {
            this.resetTickCountInventory(true);
        }
        this.updateUpgradeCache();
        if (!this.isTabEnabled(this.currentTab)) {
            this.currentTab = Tab.STORAGE;
            this.updateTabContent(backpack);
            return;
        }
        BackpackComponent backpackComponent = BackpackItem.getMetaComponent(backpack);
        if (backpackComponent.lastUpdatedInventory() > this.lastRefreshInventory) {
            this.lastRefreshInventory = Instant.now().toEpochMilli();
            switch (this.currentTab.ordinal()) {
                case 0: {
                    this.updateBackpackItemsDisplay(backpack, false);
                    break;
                }
                case 1: {
                    this.updateUpgradeSlotsDisplay(backpack);
                    break;
                }
                case 2: {
                    this.updateDrillSlotsDisplay(backpack);
                    break;
                }
                case 3: {
                    this.updateWeaponSlotsDisplay(backpack);
                    break;
                }
                case 4: {
                    this.updateItemPickupDisplay(backpack);
                    break;
                }
                case 5: {
                    this.updateLocomotionDisplay(backpack);
                }
            }
        }
    }

    private void resetTickCountFloating() {
        this.updateAnimationState(((BackpackInventoryMenu)this.field_2797).getUpgradeAlreadyInstalledAnimationState() - 1);
        this.upgradeAlreadyInstalledAnimationTickCount = 20;
    }

    private void resetTickCountInventory(boolean resetState) {
        this.updateAnimationState(resetState ? 0 : ((BackpackInventoryMenu)this.field_2797).getUpgradeAlreadyInstalledAnimationState() - 90);
        this.upgradeAlreadyInstalledAnimationTickCount = 20;
    }

    private void updateAnimationState(int value) {
        ((BackpackInventoryMenu)this.field_2797).setUpgradeAlreadyInstalledAnimationState(value);
        FTechEquipmentNetworking.sendUpdateMenuData(1, value);
    }

    void updateDrillSlotsDisplay(class_1799 backpack) {
        if (this.drillSlotsWidget != null) {
            this.method_37066(this.drillSlotsWidget);
        }
        this.drillSlotsWidget = new BackpackDrillSlotsWidget(this, this.field_22787, this.field_2776, this.field_2800, backpack);
        this.method_37063(this.drillSlotsWidget);
    }

    void updateWeaponSlotsDisplay(class_1799 backpack) {
        if (this.weaponSlotsWidget != null) {
            this.method_37066(this.weaponSlotsWidget);
        }
        this.weaponSlotsWidget = new BackpackWeaponSlotsWidget(this, this.field_22787, this.field_2776, this.field_2800, backpack);
        this.method_37063(this.weaponSlotsWidget);
    }

    void updateItemPickupDisplay(class_1799 backpack) {
        if (this.itemPickupWidget != null) {
            this.method_37066(this.itemPickupWidget);
        }
        this.itemPickupWidget = new BackpackItemPickupWidget(this, this.field_22787, this.field_2776, this.field_2800, backpack);
        this.method_37063(this.itemPickupWidget);
    }

    void updateLocomotionDisplay(class_1799 backpack) {
        if (this.locomotionWidget != null) {
            this.method_37066(this.locomotionWidget);
        }
        this.locomotionWidget = new BackpackLocomotionWidget(this, this.field_22787, this.field_2776, this.field_2800, backpack);
        this.method_37063(this.locomotionWidget);
    }

    void updateUpgradeSlotsDisplay(class_1799 backpack) {
        if (this.upgradeSlotsWidget != null) {
            this.method_37066(this.upgradeSlotsWidget);
        }
        this.upgradeSlotsWidget = new BackpackUpgradeSlotsWidget(this, this.field_22787, this.field_2776, this.field_2800, backpack);
        this.method_37063(this.upgradeSlotsWidget);
    }

    void updateBackpackItemsDisplay(class_1799 backpack, boolean removeEmpties) {
        double scrollAmount = 0.0;
        if (this.backpackInventoryListWidget != null) {
            scrollAmount = this.backpackInventoryListWidget.method_25341();
            this.method_37066((class_364)this.backpackInventoryListWidget);
        }
        assert (backpack != null);
        List<BackpackItemComponent> readonlyInventory = BackpackItem.getReadonlyInventory(backpack, removeEmpties);
        this.backpackInventoryListWidget = new BackpackInventoryListWidget(this, this.field_22787, this.field_2776, this.field_2800, readonlyInventory, scrollAmount);
        this.method_37063((class_364)this.backpackInventoryListWidget);
    }

    protected void method_2389(class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        if (this.currentTab == Tab.STORAGE) {
            guiGraphics.method_51439(this.field_22793, this.field_22785, 12, 8, 0x404040, false);
        }
    }

    public void renderCustomBackground(class_332 guiGraphics) {
        int m;
        int tabX;
        int panelX = (this.field_22789 - this.field_2792) / 2;
        int panelY = (this.field_22790 - this.field_2779) / 2;
        this.updateUpgradeCache();
        int selectedTabX = this.getTabX(this.currentTab);
        int tabGapX = selectedTabX - panelX;
        int iconOffset = 8;
        int iconY = this.tabY + 8;
        for (Tab tab : Tab.values()) {
            if (!this.isTabEnabled(tab)) continue;
            tabX = this.getTabX(tab);
            if (tab == this.currentTab) continue;
            FTechClientUtils.drawGuiTab((class_332)guiGraphics, (int)tabX, (int)this.tabY, (int)32, (int)32, (boolean)false);
        }
        FTechClientUtils.drawGenericGuiBackgroundWithTab((class_332)guiGraphics, (int)panelX, (int)panelY, (int)this.field_2792, (int)this.field_2779, (int)tabGapX, (int)32);
        FTechClientUtils.drawGuiTab((class_332)guiGraphics, (int)selectedTabX, (int)this.tabY, (int)32, (int)32, (boolean)true);
        for (Tab tab : Tab.values()) {
            if (!this.isTabEnabled(tab)) continue;
            tabX = this.getTabX(tab);
            class_2960 icon = switch (tab.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> TAB_ICON_STORAGE;
                case 1 -> TAB_ICON_UPGRADES;
                case 2 -> TAB_ICON_BLOCK_OPS;
                case 3 -> TAB_ICON_COMBAT;
                case 4 -> TAB_ICON_ITEM_PICKUP;
                case 5 -> TAB_ICON_LOCOMOTION;
            };
            guiGraphics.method_25290(icon, tabX + iconOffset, iconY, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        int inventoryXOffset = (this.field_2792 - 162) / 2;
        int yOffset = 70;
        for (m = 0; m < 3; ++m) {
            for (int l = 0; l < 9; ++l) {
                guiGraphics.method_25290(FTechClientUtils.GUI_SLOT_TEXTURE, panelX + inventoryXOffset + l * 18 - 1, yOffset + panelY + 84 + m * 18 - 1, 0.0f, 0.0f, 18, 18, 18, 18);
            }
        }
        for (m = 0; m < 9; ++m) {
            guiGraphics.method_25290(FTechClientUtils.GUI_SLOT_TEXTURE, panelX + inventoryXOffset + m * 18 - 1, yOffset + panelY + 142 - 1, 0.0f, 0.0f, 18, 18, 18, 18);
        }
        class_1799 backpack = FTechEquipment.getBackpackOnPlayer((class_1309)class_310.method_1551().field_1724);
        if (backpack != null) {
            int currentItems = BackpackItem.getCurrentItemCount(backpack);
            int maxCapacity = BackpackItem.getMaxCapacity(backpack);
            String capacityText = currentItems + " / " + maxCapacity;
            int capacityLabelX = panelX + inventoryXOffset + 162 + 8;
            int capacityLabelY = yOffset + panelY + 84 + 27 - 4;
            int color = currentItems >= maxCapacity ? 0xFF6666 : ((double)currentItems > (double)maxCapacity * 0.8 ? 0xFFAA00 : 0xAAAAAA);
            guiGraphics.method_51433(this.field_22793, capacityText, capacityLabelX, capacityLabelY, color, false);
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(guiGraphics);
        this.renderCustomBackground(guiGraphics);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.method_2380(guiGraphics, mouseX, mouseY);
        for (Tab tab : Tab.values()) {
            int tabX;
            if (!this.isTabEnabled(tab) || !this.isMouseOverTab(mouseX, mouseY, tabX = this.getTabX(tab))) continue;
            class_5250 tooltip = switch (tab.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> class_2561.method_43471((String)"tab.f_tech_equipment.storage");
                case 1 -> class_2561.method_43471((String)"tab.f_tech_equipment.upgrades");
                case 2 -> class_2561.method_43471((String)"tab.f_tech_equipment.block_operations");
                case 3 -> class_2561.method_43471((String)"tab.f_tech_equipment.combat");
                case 4 -> class_2561.method_43471((String)"tab.f_tech_equipment.item_pickup");
                case 5 -> class_2561.method_43471((String)"tab.f_tech_equipment.locomotion");
            };
            guiGraphics.method_51438(this.field_22793, (class_2561)tooltip, mouseX, mouseY);
            break;
        }
    }

    protected void method_2382(class_332 guiGraphics, class_1799 itemStack, int i, int j, String string) {
        float x = 0.0f;
        float y = 0.0f;
        float multiplier = ((float)this.upgradeAlreadyInstalledAnimationTickCount - class_310.method_1551().method_1534()) / 20.0f;
        if (((BackpackInventoryMenu)this.field_2797).getUpgradeAlreadyInstalledAnimationState() != 0) {
            x = this.random.nextFloat(-1.0f, 1.0f);
            y = this.random.nextFloat(-1.0f, 1.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)(1.0f - multiplier), (float)(1.0f - multiplier), (float)1.0f);
        }
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(x * multiplier, y * multiplier, 232.0f);
        guiGraphics.method_51427(itemStack, i, j);
        guiGraphics.method_51432(this.field_22793, itemStack, i, j - (this.field_2782.method_7960() ? 0 : 8), string);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.method_51448().method_22909();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        assert (this.field_22787 != null);
        if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode) || FTechEquipmentKeybindings.BACKPACK_INVENTORY_KEYBINDING.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            for (Tab tab : Tab.values()) {
                int tabX;
                if (!this.isTabEnabled(tab) || !this.isMouseOverTab(mouseX, mouseY, tabX = this.getTabX(tab))) continue;
                this.switchTab(tab);
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private boolean isMouseOverTab(double mouseX, double mouseY, int tabX) {
        return mouseX >= (double)tabX && mouseX < (double)(tabX + 32) && mouseY >= (double)this.tabY && mouseY < (double)(this.tabY + 32);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        super.method_25403(mouseX, mouseY, button, dragX, dragY);
        if (this.method_25399() != null && this.method_25397() && button == 0) {
            return this.method_25399().method_25403(mouseX, mouseY, button, dragX, dragY);
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        super.method_25406(mouseX, mouseY, button);
        if (button == 0 && this.method_25397()) {
            this.method_25398(false);
            if (this.method_25399() != null) {
                return this.method_25399().method_25406(mouseX, mouseY, button);
            }
        }
        return this.method_19355(mouseX, mouseY).filter(element -> element.method_25406(mouseX, mouseY, button)).isPresent();
    }

    public Random getRandom() {
        return this.random;
    }

    public int getUpgradeAlreadyInstalledAnimationTickCount() {
        return this.upgradeAlreadyInstalledAnimationTickCount;
    }

    private static enum Tab {
        STORAGE,
        UPGRADES,
        BLOCK_OPERATIONS,
        COMBAT,
        ITEM_PICKUP,
        LOCOMOTION;

    }
}

