/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.ftech_equipment.fabric.client.render;

import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.client.TrinketRenderer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_583;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import uk.co.cablepost.ftech_equipment.backpack.BackpackArm;
import uk.co.cablepost.ftech_equipment.backpack.BackpackArmComponent;
import uk.co.cablepost.ftech_equipment.backpack.BackpackArmPath;
import uk.co.cablepost.ftech_equipment.backpack.BackpackItem;
import uk.co.cablepost.ftech_equipment.backpack.RoboticDrillItem;
import uk.co.cablepost.ftech_equipment.backpack.action.AttackAction;
import uk.co.cablepost.ftech_equipment.backpack.action.LocomotionAction;
import uk.co.cablepost.ftech_equipment.client.render.BackpackArmVertModel;
import uk.co.cablepost.ftech_equipment.client.render.BackpackHandModel;
import uk.co.cablepost.ftech_equipment.client.render.BackpackModel;
import uk.co.cablepost.ftech_equipment.client.render.IBackpackArmRenderer;

public class TrinketBackpackRenderer
implements TrinketRenderer,
IBackpackArmRenderer {
    protected final BackpackModel backpackModel;
    protected final BackpackArmVertModel backpackArmVertModel;
    protected final BackpackHandModel backpackHandModel;
    protected final class_2960 backpackTexture;
    protected final class_2960 backpackArmVertTexture;
    protected final class_2960 backpackHandTexture;
    private static final class_2960 DEFAULT_BACKPACK_TEXTURE = new class_2960("f_tech_equipment", "textures/entity/trinket/backpack.png");
    private static final class_2960 DEFAULT_BACKPACK_ARM_VERT_TEXTURE = new class_2960("f_tech_equipment", "textures/entity/trinket/backpack_arm_vert.png");
    private static final class_2960 DEFAULT_BACKPACK_HAND_TEXTURE = new class_2960("f_tech_equipment", "textures/entity/trinket/backpack_hand.png");
    private static final Map<String, class_243> smoothedArmPositions = new HashMap<String, class_243>();
    private static final Map<String, Float> smoothedArmProgress = new HashMap<String, Float>();
    protected static final float ARM_SMOOTH_FACTOR = 0.15f;

    public TrinketBackpackRenderer() {
        this(new BackpackModel(BackpackModel.createBodyLayer().method_32109()), new BackpackArmVertModel(BackpackArmVertModel.createBodyLayer().method_32109()), new BackpackHandModel(BackpackHandModel.createBodyLayer().method_32109()), DEFAULT_BACKPACK_TEXTURE, DEFAULT_BACKPACK_ARM_VERT_TEXTURE, DEFAULT_BACKPACK_HAND_TEXTURE);
    }

    public TrinketBackpackRenderer(BackpackModel backpackModel, BackpackArmVertModel backpackArmVertModel, BackpackHandModel backpackHandModel, class_2960 backpackTexture, class_2960 backpackArmVertTexture, class_2960 backpackHandTexture) {
        this.backpackModel = backpackModel;
        this.backpackArmVertModel = backpackArmVertModel;
        this.backpackHandModel = backpackHandModel;
        this.backpackTexture = backpackTexture;
        this.backpackArmVertTexture = backpackArmVertTexture;
        this.backpackHandTexture = backpackHandTexture;
    }

    public BackpackModel getBackpackModel() {
        return this.backpackModel;
    }

    public BackpackArmVertModel getBackpackArmVertModel() {
        return this.backpackArmVertModel;
    }

    public BackpackHandModel getBackpackHandModel() {
        return this.backpackHandModel;
    }

    public class_2960 getBackpackTexture() {
        return this.backpackTexture;
    }

    public class_2960 getBackpackArmVertTexture() {
        return this.backpackArmVertTexture;
    }

    public class_2960 getBackpackHandTexture() {
        return this.backpackHandTexture;
    }

    public void render(class_1799 stack, SlotReference slotReference, class_583<? extends class_1309> contextModel, class_4587 poseStack, class_4597 bufferSource, int light, class_1309 player, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        int overlay = 655360;
        poseStack.method_22903();
        if (player.method_18276()) {
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(25.0f));
            poseStack.method_46416(0.0f, 0.2f, -0.05f);
        }
        class_4588 vertexConsumer = bufferSource.getBuffer(this.backpackModel.method_23500(this.backpackTexture));
        this.backpackModel.method_2828(poseStack, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.method_22909();
    }

    @Override
    public void renderArms(class_4587 poseStack, class_4597 bufferSource, int light, int overlay, class_1309 player, float tickDelta, class_1799 itemStack) {
        for (BackpackArm arm : BackpackArm.values()) {
            this.renderArm(poseStack, bufferSource, light, overlay, player, arm, tickDelta, itemStack);
        }
    }

    protected void renderHand(class_4587 poseStack, class_4597 bufferSource, int light, int overlay, float tickDelta, float fingerAngle) {
        class_4588 vertexConsumer = bufferSource.getBuffer(this.backpackHandModel.method_23500(this.backpackHandTexture));
        poseStack.method_22903();
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        poseStack.method_46416(0.0f, -1.7f, 0.0f);
        poseStack.method_22905(1.5f, 1.5f, 1.5f);
        this.backpackHandModel.finger1.field_3674 = (float)Math.toRadians(-55.0f + fingerAngle);
        this.backpackHandModel.finger2.field_3674 = (float)Math.toRadians(55.0f - fingerAngle);
        this.backpackHandModel.method_2828(poseStack, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.method_22909();
    }

    protected void renderArm(class_4587 poseStack, class_4597 bufferSource, int light, int overlay, class_1309 player, BackpackArm arm, float tickDelta, class_1799 itemStack) {
        BackpackArmPath last;
        BackpackArmComponent armData = BackpackItem.getArmData(arm, itemStack);
        float smoothedProgress = this.getSmoothedArmProgress(player, arm, armData.progress());
        if (smoothedProgress <= 0.01f) {
            TrinketBackpackRenderer.resetSmoothedState(player, arm);
            return;
        }
        class_243 targetPos = armData.extendedPos();
        class_243 smoothedPos = this.getSmoothedArmPosition(player, arm, targetPos);
        class_4588 vertexConsumer = bufferSource.getBuffer(this.backpackArmVertModel.method_23500(this.backpackArmVertTexture));
        poseStack.method_22903();
        boolean firstPerson = class_310.method_1551().field_1690.method_31044().method_31034();
        boolean isSelf = class_310.method_1551().field_1724 != null && player.method_5628() == class_310.method_1551().field_1724.method_5628();
        List<BackpackArmPath> backpackArmPath = BackpackItem.getPartialArmPath(player, arm, smoothedPos, tickDelta, smoothedProgress);
        if (backpackArmPath.isEmpty()) {
            poseStack.method_22909();
            return;
        }
        BackpackArmPath lastRendered = last = backpackArmPath.get(backpackArmPath.size() - 1);
        int i = 0;
        for (BackpackArmPath pathElement : backpackArmPath) {
            if (firstPerson && isSelf && i <= 10) {
                ++i;
                continue;
            }
            if (new class_243(pathElement.pos().field_1352, pathElement.pos().field_1351, pathElement.pos().field_1350).method_1022(new class_243(last.pos().field_1352, last.pos().field_1351, last.pos().field_1350)) < (double)(0.25f * (float)backpackArmPath.size() * 0.011f)) continue;
            poseStack.method_22903();
            poseStack.method_22904(pathElement.pos().field_1352, pathElement.pos().field_1351, pathElement.pos().field_1350);
            poseStack.method_22907(TrinketBackpackRenderer.getRotationForDirection(pathElement.delta()));
            this.backpackArmVertModel.method_2828(poseStack, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            lastRendered = pathElement;
            poseStack.method_22909();
            ++i;
        }
        boolean isLocomotion = LocomotionAction.ID.equals((Object)armData.actionType());
        if (!(armData.holdingStack().method_31574(class_1802.field_8615) && !isLocomotion || backpackArmPath.isEmpty())) {
            boolean isMining;
            poseStack.method_22903();
            double posX = last.pos().field_1352;
            double posY = last.pos().field_1351;
            double posZ = last.pos().field_1350;
            boolean bl = isMining = armData.miningTotalTicks() > 0;
            if (isMining) {
                class_243 direction = last.delta().method_1029();
                double offset = 0.5;
                posX -= direction.field_1352 * offset;
                posY -= direction.field_1351 * offset;
                posZ -= direction.field_1350 * offset;
            }
            poseStack.method_22904(posX, posY, posZ);
            poseStack.method_22907(TrinketBackpackRenderer.getRotationForDirection(lastRendered.delta()));
            float twistCorrection = TrinketBackpackRenderer.calculateTwistCorrection(last.delta());
            poseStack.method_22907(class_7833.field_40717.rotationDegrees(twistCorrection));
            float scale = class_3532.method_15363((float)((float)backpackArmPath.size() / 100.0f), (float)0.1f, (float)0.8f);
            poseStack.method_22905(scale, scale, scale);
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
            if (AttackAction.ID.equals((Object)armData.actionType())) {
                float swingAngle = armData.actionState().method_10583("swingAngle");
                if (swingAngle > 0.0f) {
                    swingAngle = 90.0f - swingAngle;
                }
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(-(swingAngle *= 0.5f)));
            }
            if (!(armData.holdingStack().method_7909() instanceof RoboticDrillItem)) {
                float fingerAngle = isLocomotion ? armData.actionState().method_10583("fingerAngle") : (armData.holdingStack().method_7909() instanceof class_1747 ? -25.0f : 7.0f);
                this.renderHand(poseStack, bufferSource, light, overlay, tickDelta, fingerAngle);
            }
            if (AttackAction.ID.equals((Object)armData.actionType())) {
                poseStack.method_22907(class_7833.field_40718.rotationDegrees(-30.0f));
                poseStack.method_46416(-0.4f, 0.4f, 0.0f);
                poseStack.method_22905(1.2f, 1.2f, 1.2f);
            }
            if (isMining) {
                float gameTime = (float)player.field_6012 + tickDelta;
                float rotationDegrees = gameTime * 36.0f % 360.0f;
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(rotationDegrees));
                poseStack.method_46416(0.0f, 0.0f, 0.0625f);
            }
            if (!isLocomotion) {
                class_310.method_1551().method_1480().method_23178(armData.holdingStack(), class_811.field_4319, light, class_4608.field_21444, poseStack, bufferSource, player.method_37908(), 0);
            }
            poseStack.method_22909();
        }
        poseStack.method_22909();
    }

    protected static float calculateTwistCorrection(class_243 direction) {
        Vector3f dir = direction.method_1029().method_46409();
        if (Math.abs(dir.y) > 0.99f) {
            return 0.0f;
        }
        Quaternionf dirRotation = TrinketBackpackRenderer.getRotationForDirection(direction);
        Vector3f rotatedUp = new Vector3f(0.0f, 1.0f, 0.0f);
        dirRotation.transform(rotatedUp);
        Vector3f worldUp = new Vector3f(0.0f, 1.0f, 0.0f);
        float dotWorld = worldUp.dot((Vector3fc)dir);
        Vector3f worldUpProj = new Vector3f((Vector3fc)worldUp).sub((Vector3fc)new Vector3f((Vector3fc)dir).mul(dotWorld));
        if (worldUpProj.lengthSquared() < 1.0E-4f) {
            return 0.0f;
        }
        worldUpProj.normalize();
        float dotRotated = rotatedUp.dot((Vector3fc)dir);
        Vector3f rotatedUpProj = new Vector3f((Vector3fc)rotatedUp).sub((Vector3fc)new Vector3f((Vector3fc)dir).mul(dotRotated));
        if (rotatedUpProj.lengthSquared() < 1.0E-4f) {
            return 0.0f;
        }
        rotatedUpProj.normalize();
        float dot = worldUpProj.dot((Vector3fc)rotatedUpProj);
        dot = Math.max(-1.0f, Math.min(1.0f, dot));
        float angle = (float)Math.toDegrees(Math.acos(dot));
        Vector3f cross = new Vector3f();
        rotatedUpProj.cross((Vector3fc)worldUpProj, cross);
        if (cross.dot((Vector3fc)dir) < 0.0f) {
            angle = -angle;
        }
        return angle;
    }

    protected static Quaternionf getRotationForDirection(class_243 direction) {
        Quaternionf rotation = new Quaternionf();
        Vector3f forward = new Vector3f(0.0f, 0.0f, -1.0f);
        float dot = forward.dot((Vector3fc)direction.method_1029().method_46409());
        if (dot < -0.999999f) {
            rotation.mul((float)Math.PI, 0.0f, 1.0f, 0.0f);
        } else {
            Vector3f axis = new Vector3f();
            forward.cross((Vector3fc)direction.method_1029().method_46409(), axis);
            if (axis.lengthSquared() >= 1.0E-6f) {
                axis.normalize();
                float angle1 = (float)Math.acos(dot);
                rotation.rotateAxis(angle1, axis.x, axis.y, axis.z);
            }
        }
        return rotation;
    }

    protected class_243 getSmoothedArmPosition(class_1309 player, BackpackArm arm, class_243 targetPos) {
        String key = player.method_5667().toString() + ":" + arm.name();
        class_243 currentSmoothed = smoothedArmPositions.get(key);
        if (currentSmoothed == null) {
            smoothedArmPositions.put(key, targetPos);
            return targetPos;
        }
        class_243 newSmoothed = currentSmoothed.method_35590(targetPos, (double)0.15f);
        smoothedArmPositions.put(key, newSmoothed);
        return newSmoothed;
    }

    protected float getSmoothedArmProgress(class_1309 player, BackpackArm arm, float targetProgress) {
        String key = player.method_5667().toString() + ":" + arm.name();
        Float currentSmoothed = smoothedArmProgress.get(key);
        if (currentSmoothed == null) {
            smoothedArmProgress.put(key, Float.valueOf(targetProgress));
            return targetProgress;
        }
        float newSmoothed = currentSmoothed.floatValue() + (targetProgress - currentSmoothed.floatValue()) * 0.15f;
        smoothedArmProgress.put(key, Float.valueOf(newSmoothed));
        return newSmoothed;
    }

    public static void resetSmoothedState(class_1309 player, BackpackArm arm) {
        String key = player.method_5667().toString() + ":" + arm.name();
        smoothedArmPositions.remove(key);
        smoothedArmProgress.remove(key);
    }
}

