/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.ftech_equipment.fabric.client;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.trinkets.api.client.TrinketRenderer;
import dev.emi.trinkets.api.client.TrinketRendererRegistry;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.UUID;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.TooltipComponentCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3917;
import net.minecraft.class_3929;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4668;
import net.minecraft.class_5601;
import net.minecraft.class_742;
import net.minecraft.class_757;
import net.minecraft.class_765;
import uk.co.cablepost.ftech_equipment.FTechEquipment;
import uk.co.cablepost.ftech_equipment.FTechEquipmentKeybindings;
import uk.co.cablepost.ftech_equipment.backpack.BackpackBuildInstructionComponent;
import uk.co.cablepost.ftech_equipment.backpack.BackpackItem;
import uk.co.cablepost.ftech_equipment.backpack.build_instructions_client.BackpackBuildInstructionsReplicateParamsComponent;
import uk.co.cablepost.ftech_equipment.backpack.inventory.BackpackTooltip;
import uk.co.cablepost.ftech_equipment.backpack.inventory.ClientBackpackTooltip;
import uk.co.cablepost.ftech_equipment.backpack.locomotion.LocomotionControllerClient;
import uk.co.cablepost.ftech_equipment.client.render.BackpackRendererRegistry;
import uk.co.cablepost.ftech_equipment.client.render.IBackpackArmRenderer;
import uk.co.cablepost.ftech_equipment.fabric.client.render.BackpackArmVertModel;
import uk.co.cablepost.ftech_equipment.fabric.client.render.BackpackModel;
import uk.co.cablepost.ftech_equipment.fabric.client.render.TrinketBackpackRenderer;
import uk.co.cablepost.ftech_equipment.fabric.client.screen.BackpackInventoryScreen;
import uk.co.cablepost.ftech_equipment.fabric.client.screen.BuildInstructionsScreen;
import uk.co.cablepost.ftech_equipment.fabric.client.sound.BackpackArmSoundManager;
import uk.co.cablepost.ftech_equipment.networking.FTechEquipmentNetworking;

public final class FTechEquipmentFabricClient
implements ClientModInitializer {
    public static final class_5601 MODEL_BACKPACK_LAYER = new class_5601(new class_2960("f_tech_equipment", "backpack"), "main");
    public static final class_5601 MODEL_BACKPACK_ARM_VERT_LAYER = new class_5601(new class_2960("f_tech_equipment", "backpack_vert"), "main");
    public static final class_1921 ARM_PREVIEW_LINES = class_1921.method_24048((String)"f_tech_equipment_arm_preview_lines", (class_293)class_290.field_29337, (class_293.class_5596)class_293.class_5596.field_27377, (int)1536, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(class_4668.field_29433).method_23609(new class_4668.class_4677(OptionalDouble.empty())).method_23607(class_4668.field_21352).method_23615(class_4668.field_21370).method_23610(class_4668.field_21359).method_23616(class_4668.field_21350).method_23603(class_4668.field_21345).method_23617(false));
    public static TrinketBackpackRenderer TRINKET_BACKPACK_RENDERER;
    private static final UUID REPLAY_MOD_CAMERA_UUID;

    public void onInitializeClient() {
        EntityModelLayerRegistry.registerModelLayer((class_5601)MODEL_BACKPACK_LAYER, BackpackModel::createBodyLayer);
        EntityModelLayerRegistry.registerModelLayer((class_5601)MODEL_BACKPACK_ARM_VERT_LAYER, BackpackArmVertModel::createBodyLayer);
        TRINKET_BACKPACK_RENDERER = new TrinketBackpackRenderer();
        TrinketRendererRegistry.registerRenderer((class_1792)((class_1792)FTechEquipment.BACKPACK_ITEM.get()), (TrinketRenderer)TRINKET_BACKPACK_RENDERER);
        BackpackRendererRegistry.registerArmRenderer((class_1792)FTechEquipment.BACKPACK_ITEM.get(), TRINKET_BACKPACK_RENDERER);
        BackpackModel itemBackpackModel = new BackpackModel(BackpackModel.createBodyLayer().method_32109());
        class_2960 backpackTexture = new class_2960("f_tech_equipment", "textures/entity/trinket/backpack.png");
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)FTechEquipment.BACKPACK_ITEM.get(), (stack, mode, poseStack, bufferSource, light, overlay) -> {
            poseStack.method_22903();
            poseStack.method_22904(0.5, 0.5, 0.5);
            poseStack.method_22905(-1.0f, -1.0f, 1.0f);
            class_4588 vertexConsumer = bufferSource.getBuffer(itemBackpackModel.method_23500(backpackTexture));
            itemBackpackModel.method_2828(poseStack, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.method_22909();
        });
        class_3929.method_17542((class_3917)((class_3917)FTechEquipment.BACKPACK_INVENTORY_MENU.get()), BackpackInventoryScreen::new);
        FTechEquipment.initClient();
        WorldRenderEvents.AFTER_ENTITIES.register(context -> {
            if (class_310.method_1551().field_1687 == null) {
                return;
            }
            class_4587 poseStack = Objects.requireNonNull(context.matrixStack());
            class_757 gameRenderer = class_310.method_1551().field_1773;
            class_4184 camera = gameRenderer.method_19418();
            float tickDelta = context.tickDelta();
            List players = class_310.method_1551().field_1687.method_18456();
            for (class_742 player : players) {
                class_1799 itemStack;
                if (player.method_5667().equals(REPLAY_MOD_CAMERA_UUID) || (itemStack = FTechEquipment.getBackpackOnPlayer((class_1309)player)) == null) continue;
                IBackpackArmRenderer armRenderer = BackpackRendererRegistry.getArmRenderer(itemStack);
                if (armRenderer == null) {
                    armRenderer = TRINKET_BACKPACK_RENDERER;
                }
                poseStack.method_22903();
                poseStack.method_22904(-camera.method_19326().field_1352, -camera.method_19326().field_1351, -camera.method_19326().field_1350);
                class_2338 blockPos = class_2338.method_49638((class_2374)player.method_5836(tickDelta));
                int skyLight = player.method_37908().method_8314(class_1944.field_9284, blockPos);
                int blockLight = player.method_37908().method_8314(class_1944.field_9282, blockPos);
                int entityLight = class_765.method_23687((int)blockLight, (int)skyLight);
                armRenderer.renderArms(poseStack, Objects.requireNonNull(context.consumers()), entityLight, 655360, (class_1309)player, tickDelta, itemStack);
                poseStack.method_22909();
            }
        });
        WorldRenderEvents.LAST.register(this::renderBuildInstructionWireframes);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 != null && client.field_1687 != null) {
                class_1799 backpack = FTechEquipment.getBackpackOnPlayer((class_1309)client.field_1724);
                this.handleKeybinds(client, backpack);
                BackpackArmSoundManager.updateArmSounds((class_1657)client.field_1724, backpack);
                if (backpack != null && !backpack.method_7960() && BackpackItem.hasUpgrade(backpack, (class_1792)FTechEquipment.LOCOMOTION_UPGRADE_ITEM.get())) {
                    LocomotionControllerClient.tickClient(backpack, client.field_1724);
                    class_243 velocity = client.field_1724.method_18798();
                    FTechEquipmentNetworking.sendVelocitySync(velocity.field_1352, velocity.field_1351, velocity.field_1350);
                }
            }
        });
        TooltipComponentCallback.EVENT.register(data -> {
            if (data instanceof BackpackTooltip) {
                BackpackTooltip backpackTooltip = (BackpackTooltip)data;
                return new ClientBackpackTooltip(backpackTooltip);
            }
            return null;
        });
    }

    private void handleKeybinds(class_310 client, class_1799 backpack) {
        boolean currentlyEnabled;
        if (client.field_1755 != null) {
            return;
        }
        if (FTechEquipmentKeybindings.BACKPACK_INVENTORY_KEYBINDING.method_1436()) {
            if (backpack == null || backpack.method_7960()) {
                client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"message.f_tech_equipment.backpack_required"), true);
                return;
            }
            FTechEquipmentNetworking.sendOpenInventory();
        }
        if (FTechEquipmentKeybindings.BACKPACK_BUILD_INSTRUCTIONS_SCREEN_KEYBINDING.method_1436()) {
            if (backpack == null || backpack.method_7960()) {
                client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"message.f_tech_equipment.backpack_required"), true);
                return;
            }
            if (!BackpackItem.hasUpgrade(backpack, (class_1792)FTechEquipment.BLOCK_OPERATIONS_UPGRADE_ITEM.get())) {
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"Block Operations Module required"), true);
                return;
            }
            client.method_1507((class_437)new BuildInstructionsScreen());
        }
        if (FTechEquipmentKeybindings.BACKPACK_BUILD_INSTRUCTIONS_TOGGLE_KEYBINDING.method_1436()) {
            if (backpack == null || backpack.method_7960()) {
                return;
            }
            if (!BackpackItem.hasUpgrade(backpack, (class_1792)FTechEquipment.BLOCK_OPERATIONS_UPGRADE_ITEM.get())) {
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"Block Operations Module required"), true);
                return;
            }
            currentlyEnabled = BackpackItem.getReplicateParams(backpack).enabled();
            BackpackBuildInstructionsReplicateParamsComponent params = BackpackItem.getReplicateParams(backpack);
            FTechEquipmentNetworking.sendBuildInstructionsReplicateParams(!currentlyEnabled, params.extendLeft(), params.extendRight(), params.extendUp(), params.extendDown());
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("Block operations " + (!currentlyEnabled ? "enabled" : "disabled"))), true);
        }
        if (FTechEquipmentKeybindings.BACKPACK_ITEM_PICKUP_TOGGLE_KEYBINDING.method_1436()) {
            if (backpack == null || backpack.method_7960()) {
                return;
            }
            if (!BackpackItem.hasUpgrade(backpack, (class_1792)FTechEquipment.ITEM_PICKUP_UPGRADE_ITEM.get())) {
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"Item Pickup Module required"), true);
                return;
            }
            currentlyEnabled = BackpackItem.isItemPickupEnabled(backpack);
            FTechEquipmentNetworking.sendItemPickupToggle(!currentlyEnabled);
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("Item pickup " + (!currentlyEnabled ? "enabled" : "disabled"))), true);
        }
        if (FTechEquipmentKeybindings.BACKPACK_ATTACK_TOGGLE_KEYBINDING.method_1436()) {
            if (backpack == null || backpack.method_7960()) {
                return;
            }
            if (!BackpackItem.hasUpgrade(backpack, (class_1792)FTechEquipment.COMBAT_UPGRADE_ITEM.get())) {
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"Combat Module required"), true);
                return;
            }
            currentlyEnabled = BackpackItem.isAttackEnabled(backpack);
            FTechEquipmentNetworking.sendAttackToggle(!currentlyEnabled);
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("Combat mode " + (!currentlyEnabled ? "enabled" : "disabled"))), true);
        }
        if (FTechEquipmentKeybindings.BACKPACK_LOCOMOTION_TOGGLE_KEYBINDING.method_1436()) {
            if (backpack == null || backpack.method_7960()) {
                return;
            }
            if (!BackpackItem.hasUpgrade(backpack, (class_1792)FTechEquipment.LOCOMOTION_UPGRADE_ITEM.get())) {
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"Locomotion Module required"), true);
                return;
            }
            currentlyEnabled = BackpackItem.isLocomotionEnabled(backpack);
            FTechEquipmentNetworking.sendLocomotionToggle(!currentlyEnabled);
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("Locomotion " + (!currentlyEnabled ? "enabled" : "disabled"))), true);
        }
    }

    private void renderBuildInstructionWireframes(WorldRenderContext context) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || context.world() == null) {
            return;
        }
        class_1799 backpack = FTechEquipment.getBackpackOnPlayer((class_1309)client.field_1724);
        if (backpack == null) {
            return;
        }
        if (!BackpackItem.hasUpgrade(backpack, (class_1792)FTechEquipment.BLOCK_OPERATIONS_UPGRADE_ITEM.get())) {
            return;
        }
        BackpackBuildInstructionsReplicateParamsComponent params = BackpackItem.getReplicateParams((class_1309)client.field_1724);
        if (!params.enabled()) {
            return;
        }
        List<BackpackBuildInstructionComponent> buildInstructions = BackpackItem.getBuildInstructions(backpack);
        boolean hasQueueUpgrade = BackpackItem.hasUpgrade(backpack, (class_1792)FTechEquipment.QUEUE_UPGRADE_ITEM.get());
        boolean hasDrills = BackpackItem.hasAnyDrills(backpack);
        boolean holdingBlockItem = client.field_1724.method_24520(x -> x.method_7909() instanceof class_1747);
        if (holdingBlockItem || hasDrills) {
            class_239 hitResult;
            boolean showPreview;
            boolean bl = showPreview = hasQueueUpgrade || buildInstructions.isEmpty();
            if (showPreview && (hitResult = client.field_1765) != null && hitResult.method_17783() == class_239.class_240.field_1332) {
                class_2338 blockPos = ((class_3965)hitResult).method_17777();
                if (holdingBlockItem && !context.world().method_8320(blockPos).method_45474()) {
                    blockPos = blockPos.method_10093(((class_3965)hitResult).method_17780());
                }
                List<class_2338> blockPosList = BackpackItem.getReplicateBlocks(blockPos, (class_1309)client.field_1724);
                for (class_2338 pos : blockPosList) {
                    FTechEquipmentFabricClient.renderBlockPreview(context, pos, 1.0f, 1.0f, 0.5f);
                }
            }
        }
        for (BackpackBuildInstructionComponent buildInstruction : buildInstructions) {
            FTechEquipmentFabricClient.renderBlockPreview(context, buildInstruction.blockPos(), 0.3f, 0.3f, 1.0f);
        }
    }

    private static void renderBlockPreview(WorldRenderContext context, class_2338 blockPos, float red, float green, float blue) {
        class_4587 poseStack = Objects.requireNonNull(context.matrixStack());
        class_310 client = class_310.method_1551();
        poseStack.method_22903();
        class_4184 camera = client.field_1773.method_19418();
        poseStack.method_22904(-camera.method_19326().field_1352, -camera.method_19326().field_1351, -camera.method_19326().field_1350);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        float offset = 0.025f;
        float x = (float)blockPos.method_10263() + offset;
        float y = (float)blockPos.method_10264() + offset;
        float z = (float)blockPos.method_10260() + offset;
        float size = 1.0f - offset * 2.0f;
        float alpha = 0.4f;
        FTechEquipmentFabricClient.renderWireframeCube(context, poseStack, x, y, z, size, red, green, blue, alpha, ARM_PREVIEW_LINES);
        FTechEquipmentFabricClient.renderWireframeCube(context, poseStack, x, y, z, size, red, green, blue, alpha, class_1921.method_23594());
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        poseStack.method_22909();
    }

    private static void renderWireframeCube(WorldRenderContext context, class_4587 poseStack, float x, float y, float z, float size, float r, float g, float b, float a, class_1921 renderType) {
        class_4588 buffer = Objects.requireNonNull(context.consumers()).getBuffer(renderType);
        class_4587.class_4665 pose = poseStack.method_23760();
        float x2 = x + size;
        float y2 = y + size;
        float z2 = z + size;
        FTechEquipmentFabricClient.line(buffer, pose, x, y, z, x2, y, z, r, g, b, a);
        FTechEquipmentFabricClient.line(buffer, pose, x2, y, z, x2, y, z2, r, g, b, a);
        FTechEquipmentFabricClient.line(buffer, pose, x2, y, z2, x, y, z2, r, g, b, a);
        FTechEquipmentFabricClient.line(buffer, pose, x, y, z2, x, y, z, r, g, b, a);
        FTechEquipmentFabricClient.line(buffer, pose, x, y2, z, x2, y2, z, r, g, b, a);
        FTechEquipmentFabricClient.line(buffer, pose, x2, y2, z, x2, y2, z2, r, g, b, a);
        FTechEquipmentFabricClient.line(buffer, pose, x2, y2, z2, x, y2, z2, r, g, b, a);
        FTechEquipmentFabricClient.line(buffer, pose, x, y2, z2, x, y2, z, r, g, b, a);
        FTechEquipmentFabricClient.line(buffer, pose, x, y, z, x, y2, z, r, g, b, a);
        FTechEquipmentFabricClient.line(buffer, pose, x2, y, z, x2, y2, z, r, g, b, a);
        FTechEquipmentFabricClient.line(buffer, pose, x2, y, z2, x2, y2, z2, r, g, b, a);
        FTechEquipmentFabricClient.line(buffer, pose, x, y, z2, x, y2, z2, r, g, b, a);
    }

    private static void line(class_4588 buffer, class_4587.class_4665 pose, float x1, float y1, float z1, float x2, float y2, float z2, float r, float g, float b, float a) {
        float nx = x2 - x1;
        float ny = y2 - y1;
        float nz = z2 - z1;
        float len = (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
        if (len > 0.0f) {
            nx /= len;
            ny /= len;
            nz /= len;
        }
        buffer.method_22918(pose.method_23761(), x1, y1, z1).method_22915(r, g, b, a).method_23763(pose.method_23762(), nx, ny, nz).method_1344();
        buffer.method_22918(pose.method_23761(), x2, y2, z2).method_22915(r, g, b, a).method_23763(pose.method_23762(), nx, ny, nz).method_1344();
    }

    static {
        REPLAY_MOD_CAMERA_UUID = UUID.nameUUIDFromBytes("ReplayModCamera".getBytes(StandardCharsets.UTF_8));
    }
}

