/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.ftech_equipment.fabric;

import dev.emi.trinkets.api.TrinketsApi;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import uk.co.cablepost.ftech_equipment.FTechEquipment;
import uk.co.cablepost.ftech_equipment.backpack.BackpackItem;
import uk.co.cablepost.ftech_equipment.backpack.action.ArmActionRegistry;
import uk.co.cablepost.ftech_equipment.backpack.action.AttackAction;
import uk.co.cablepost.ftech_equipment.backpack.action.LocomotionAction;
import uk.co.cablepost.ftech_equipment.backpack.action.MiningAction;
import uk.co.cablepost.ftech_equipment.backpack.action.PickupAction;
import uk.co.cablepost.ftech_equipment.backpack.action.PlacingAction;

public final class FTechEquipmentFabric
implements ModInitializer {
    public void onInitialize() {
        FTechEquipment.init();
        this.registerArmActions();
        this.registerTrinketsValidation();
        this.registerServerTick();
        this.registerBlockBreakEvent();
    }

    private void registerArmActions() {
        ArmActionRegistry.register(new MiningAction());
        ArmActionRegistry.register(new PlacingAction());
        ArmActionRegistry.register(new AttackAction());
        ArmActionRegistry.register(new LocomotionAction());
        ArmActionRegistry.register(new PickupAction());
    }

    private void registerTrinketsValidation() {
        TrinketsApi.registerTrinketPredicate((class_2960)new class_2960("f_tech_equipment", "trinket_validator_identifier"), (stack, slot, entity) -> {
            if (stack.method_31574((class_1792)FTechEquipment.BACKPACK_ITEM.get())) {
                return TriState.TRUE;
            }
            return TriState.DEFAULT;
        });
    }

    private void registerServerTick() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (class_3218 level : server.method_3738()) {
                for (class_3222 player : level.method_18456()) {
                    class_1799 backpack = FTechEquipment.getBackpackOnPlayer((class_1309)player);
                    if (backpack == null || backpack.method_7960()) continue;
                    BackpackItem.tick(backpack, (class_1937)level, (class_1297)player);
                }
            }
        });
    }

    private void registerBlockBreakEvent() {
        PlayerBlockBreakEvents.AFTER.register((world, player, blockPos, blockState, blockEntity) -> {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                FTechEquipment.addBuildInstructions(serverPlayer, blockPos, class_2246.field_10369.method_9564());
            }
        });
    }
}

