/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.ftech_equipment.client.render;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;
import uk.co.cablepost.ftech_equipment.client.render.IBackpackArmRenderer;

public final class BackpackRendererRegistry {
    private static final Map<class_1792, IBackpackArmRenderer> ARM_RENDERERS = new ConcurrentHashMap<class_1792, IBackpackArmRenderer>();

    private BackpackRendererRegistry() {
    }

    public static void registerArmRenderer(class_1792 item, IBackpackArmRenderer renderer) {
        if (item == null) {
            throw new IllegalArgumentException("Item cannot be null");
        }
        if (renderer == null) {
            throw new IllegalArgumentException("Renderer cannot be null");
        }
        ARM_RENDERERS.put(item, renderer);
    }

    @Nullable
    public static IBackpackArmRenderer getArmRenderer(class_1792 item) {
        return ARM_RENDERERS.get(item);
    }

    @Nullable
    public static IBackpackArmRenderer getArmRenderer(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return null;
        }
        return ARM_RENDERERS.get(stack.method_7909());
    }

    public static boolean hasArmRenderer(class_1792 item) {
        return ARM_RENDERERS.containsKey(item);
    }

    @Nullable
    public static IBackpackArmRenderer unregisterArmRenderer(class_1792 item) {
        return ARM_RENDERERS.remove(item);
    }
}

