/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.ftech_equipment.backpack.locomotion;

import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_746;
import uk.co.cablepost.ftech_equipment.backpack.BackpackItem;
import uk.co.cablepost.ftech_equipment.backpack.locomotion.LocomotionController;

public class LocomotionControllerClient {
    private static long lastTickTime = 0L;
    private static final long PAUSE_THRESHOLD_MS = 100L;

    public static void tickClient(class_1799 backpack, class_746 player) {
        if (player == null || player.method_37908() == null || !player.method_37908().field_9236) {
            return;
        }
        if (class_310.method_1551().method_1493()) {
            return;
        }
        if (!BackpackItem.isLocomotionEnabled(backpack)) {
            lastTickTime = 0L;
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (lastTickTime > 0L && currentTime - lastTickTime > 100L) {
            lastTickTime = currentTime;
            return;
        }
        lastTickTime = currentTime;
        int grabbingArms = LocomotionController.countGrabbingArms(backpack);
        if (grabbingArms < 1) {
            return;
        }
        class_310 client = class_310.method_1551();
        boolean wantsForward = client.field_1690.field_1894.method_1434();
        boolean wantsBackward = client.field_1690.field_1881.method_1434();
        boolean wantsLeft = client.field_1690.field_1913.method_1434();
        boolean wantsRight = client.field_1690.field_1849.method_1434();
        boolean wantsJump = client.field_1690.field_1903.method_1434();
        boolean wantsCrouch = client.field_1690.field_1832.method_1434();
        class_243 movementForce = class_243.field_1353;
        if (grabbingArms >= LocomotionController.MIN_ARMS_FOR_LOCOMOTION) {
            movementForce = LocomotionControllerClient.calculateMovementForce((class_1309)player, wantsForward, wantsBackward, wantsLeft, wantsRight);
        }
        double upwardForce = 0.0;
        double groundDistance = LocomotionControllerClient.getDistanceToGround((class_1309)player);
        upwardForce = LocomotionController.UPWARD_FORCE * (LocomotionController.GROUND_CLEARANCE_THRESHOLD - groundDistance) + LocomotionController.UPWARD_FORCE * player.method_18798().field_1351 * (double)-0.6f;
        if (upwardForce < 0.0) {
            upwardForce = 0.0;
        }
        if (wantsCrouch) {
            upwardForce *= (double)0.6f;
        } else {
            for (float i = 0.2f; i < 0.5f; i += 0.1f) {
                if (!(player.method_18798().field_1351 < (double)(-i))) continue;
                upwardForce += (double)i;
            }
        }
        if (groundDistance < 2.0 && player.method_18798().field_1351 < (double)-0.1f) {
            upwardForce += Math.abs(player.method_18798().field_1351) * (double)0.2f;
        }
        if (upwardForce < 0.0) {
            upwardForce = 0.0;
        }
        if (wantsJump && !wantsCrouch && grabbingArms >= LocomotionController.MIN_ARMS_FOR_LOCOMOTION) {
            upwardForce += LocomotionController.JUMP_FORCE;
        }
        double forceMultiplier = 1.0;
        if (player.method_6128()) {
            forceMultiplier = LocomotionController.ELYTRA_FORCE_MULTIPLIER;
        } else if (player.method_5771()) {
            forceMultiplier = LocomotionController.LAVA_FORCE_MULTIPLIER;
        } else if (player.method_5799()) {
            forceMultiplier = LocomotionController.WATER_FORCE_MULTIPLIER;
        }
        double addVelX = movementForce.field_1352 * forceMultiplier;
        double addVelY = upwardForce * forceMultiplier;
        double addVelZ = movementForce.field_1350 * forceMultiplier;
        class_243 current = player.method_18798();
        player.method_18799(current.method_1031(addVelX, addVelY, addVelZ));
    }

    private static class_243 calculateMovementForce(class_1309 entity, boolean forward, boolean backward, boolean left, boolean right) {
        if (!(forward || backward || left || right)) {
            return class_243.field_1353;
        }
        float yaw = entity.method_36454();
        class_243 lookDir = new class_243(-Math.sin(Math.toRadians(yaw)), 0.0, Math.cos(Math.toRadians(yaw))).method_1029();
        class_243 strafeDir = new class_243(-lookDir.field_1350, 0.0, lookDir.field_1352);
        class_243 force = class_243.field_1353;
        if (forward) {
            force = force.method_1019(lookDir.method_1021(LocomotionController.MOVEMENT_SPEED));
        }
        if (backward) {
            force = force.method_1019(lookDir.method_1021(-LocomotionController.MOVEMENT_SPEED * 0.5));
        }
        if (left) {
            force = force.method_1019(strafeDir.method_1021(-LocomotionController.MOVEMENT_SPEED * 0.7));
        }
        if (right) {
            force = force.method_1019(strafeDir.method_1021(LocomotionController.MOVEMENT_SPEED * 0.7));
        }
        return force;
    }

    private static double getDistanceToGround(class_1309 entity) {
        class_1937 level = entity.method_37908();
        class_2338 entityPos = entity.method_24515();
        for (int y = 0; y < 10; ++y) {
            class_2338 checkPos = entityPos.method_10087(y);
            class_2680 state = level.method_8320(checkPos);
            if (state.method_26215()) continue;
            if (!state.method_26227().method_15769()) {
                return entity.method_23318() - (double)checkPos.method_10264();
            }
            class_265 shape = state.method_26220((class_1922)level, checkPos);
            if (shape.method_1110()) continue;
            double blockTop = (double)checkPos.method_10264() + shape.method_1105(class_2350.class_2351.field_11052);
            return entity.method_23318() - blockTop;
        }
        return 10.0;
    }
}

