/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.ftech_equipment.backpack.locomotion;

import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;
import uk.co.cablepost.ftech_equipment.backpack.BackpackArm;
import uk.co.cablepost.ftech_equipment.backpack.BackpackArmComponent;
import uk.co.cablepost.ftech_equipment.backpack.BackpackItem;
import uk.co.cablepost.ftech_equipment.backpack.action.LocomotionAction;
import uk.co.cablepost.ftech_equipment.backpack.locomotion.GrabTarget;
import uk.co.cablepost.ftech_equipment.backpack.locomotion.GrabType;

public class GrabSurfaceDetector {
    private static final double UPWARD_BIAS = 0.3;
    private static final double VELOCITY_WEIGHT_MOVING = 0.7;
    private static final double LOOK_WEIGHT_MOVING = 0.3;
    private static final double VELOCITY_LOOKAHEAD_TICKS = 15.0;
    private static final double SURFACE_INSET = 0.15;

    @Nullable
    public static GrabTarget findGrabSurface(class_1309 entity, BackpackArm arm, double range, class_1799 backpack) {
        class_243[] searchDirs;
        class_243 eyePos = entity.method_33571();
        class_243 lookDir = entity.method_5720();
        class_243 velocity = entity.method_18798();
        GrabTarget bestTarget = null;
        double bestScore = Double.NEGATIVE_INFINITY;
        for (class_243 searchDir : searchDirs = GrabSurfaceDetector.generateSearchDirections(entity, lookDir, velocity, arm)) {
            double score;
            GrabTarget target = GrabSurfaceDetector.tryRaycast(entity, arm, eyePos, searchDir, range, velocity);
            if (target == null || !((score = GrabSurfaceDetector.scoreGrabTarget(entity, target, velocity, arm, backpack)) > bestScore)) continue;
            bestScore = score;
            bestTarget = target;
        }
        return bestTarget;
    }

    private static class_243[] generateSearchDirections(class_1309 entity, class_243 lookDir, class_243 velocity, BackpackArm arm) {
        class_243 horizDir;
        class_243[] directions = new class_243[7];
        if (velocity.method_37268() > 0.01) {
            class_243 velHoriz = new class_243(velocity.field_1352, 0.0, velocity.field_1350);
            class_243 velNorm = GrabSurfaceDetector.safeNormalize(velHoriz, new class_243(0.0, 0.0, 1.0));
            class_243 lookHoriz = new class_243(lookDir.field_1352, 0.0, lookDir.field_1350);
            class_243 lookNorm = GrabSurfaceDetector.safeNormalize(lookHoriz, velNorm);
            horizDir = GrabSurfaceDetector.safeNormalize(velNorm.method_1021(0.7).method_1019(lookNorm.method_1021(0.3)), velNorm);
        } else {
            class_243 lookHoriz = new class_243(lookDir.field_1352, 0.0, lookDir.field_1350);
            horizDir = GrabSurfaceDetector.safeNormalize(lookHoriz, new class_243(0.0, 0.0, 1.0));
        }
        class_243 lateral = GrabSurfaceDetector.getLateralVector(entity);
        double lateralAmount = arm.isLeftSide() ? -0.3 : 0.3;
        directions[0] = GrabSurfaceDetector.safeNormalize(new class_243(horizDir.field_1352, 0.3, horizDir.field_1350), new class_243(0.0, 0.0, 1.0));
        directions[1] = GrabSurfaceDetector.safeNormalize(horizDir.method_1019(lateral.method_1021(lateralAmount)), horizDir);
        directions[2] = GrabSurfaceDetector.safeNormalize(new class_243(horizDir.field_1352 * 0.6, 0.5, horizDir.field_1350 * 0.6), new class_243(0.0, 1.0, 0.0));
        directions[3] = GrabSurfaceDetector.safeNormalize(new class_243(horizDir.field_1352, -0.2, horizDir.field_1350), horizDir);
        directions[4] = GrabSurfaceDetector.safeNormalize(horizDir.method_1019(lateral.method_1021(lateralAmount * 1.5)).method_1019(new class_243(0.0, 0.1, 0.0)), horizDir);
        directions[5] = GrabSurfaceDetector.safeNormalize(new class_243(horizDir.field_1352 * 0.3, 0.7, horizDir.field_1350 * 0.3), new class_243(0.0, 1.0, 0.0));
        directions[6] = GrabSurfaceDetector.safeNormalize(new class_243(horizDir.field_1352 * 0.5, -0.4, horizDir.field_1350 * 0.5), new class_243(0.0, -1.0, 0.0));
        return directions;
    }

    private static class_243 safeNormalize(class_243 vec, class_243 fallback) {
        double lenSq = vec.method_1027();
        if (lenSq < 1.0E-4) {
            return fallback;
        }
        return vec.method_1029();
    }

    @Nullable
    private static GrabTarget tryRaycast(class_1309 entity, BackpackArm arm, class_243 eyePos, class_243 searchDir, double range, class_243 velocity) {
        class_243 lateralOffset = GrabSurfaceDetector.getLateralOffset(entity, arm);
        class_243 velocityOffset = velocity.method_1021(15.0);
        class_243 searchStart = eyePos.method_1019(lateralOffset).method_1019(velocityOffset);
        class_3965 hit = entity.method_37908().method_17742(new class_3959(searchStart, searchStart.method_1019(searchDir.method_1021(range)), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)entity));
        if (hit.method_17783() == class_239.class_240.field_1333) {
            return null;
        }
        class_2338 blockPos = hit.method_17777();
        class_1937 level = entity.method_37908();
        class_2680 state = level.method_8320(blockPos);
        if (!GrabSurfaceDetector.isSolidGrabbable(state, level, blockPos)) {
            return null;
        }
        class_243 grabPos = GrabSurfaceDetector.calculateGrabPosition(level, blockPos, state, hit, arm);
        GrabType grabType = GrabSurfaceDetector.determineGrabType(grabPos, blockPos);
        return new GrabTarget(grabPos, blockPos, hit.method_17780(), grabType);
    }

    private static double scoreGrabTarget(class_1309 entity, GrabTarget target, class_243 velocity, BackpackArm currentArm, class_1799 backpack) {
        class_243 toTarget;
        double score = 10.0;
        class_243 playerPos = entity.method_33571();
        class_243 grabPos = target.position();
        double heightDiff = grabPos.field_1351 - playerPos.field_1351;
        score = heightDiff > 0.0 ? (score += Math.min(heightDiff, 3.0) * 0.5) : (score += Math.max(heightDiff, -3.0) * 0.2);
        double distance = playerPos.method_1022(grabPos);
        if (distance < 2.0) {
            score -= (2.0 - distance) * 0.3;
        } else if (distance > 6.0) {
            score -= (distance - 6.0) * 0.2;
        }
        if (velocity.method_37268() > 0.01 && (toTarget = grabPos.method_1020(playerPos)).method_1027() > 0.01) {
            class_243 toTargetNorm = toTarget.method_1029();
            class_243 velNorm = velocity.method_1029();
            double alignment = toTargetNorm.method_1026(velNorm);
            score += alignment * 2.0;
        }
        double minSpacing = 3.5;
        for (BackpackArm otherArm : BackpackArm.values()) {
            double armDistance;
            class_243 otherGrabPos;
            BackpackArmComponent otherArmData;
            if (otherArm == currentArm || !LocomotionAction.ID.equals((Object)(otherArmData = BackpackItem.getArmData(otherArm, backpack)).actionType()) || otherArmData.direction() == 0 || (otherGrabPos = otherArmData.extendedPos()) == null || !((armDistance = grabPos.method_1022(otherGrabPos)) < minSpacing)) continue;
            double closeness = minSpacing - armDistance;
            score -= closeness * closeness * 8.0;
        }
        return score;
    }

    private static class_243 getLateralVector(class_1309 entity) {
        float yaw = entity.method_36454();
        return new class_243(-Math.cos(Math.toRadians(yaw)), 0.0, -Math.sin(Math.toRadians(yaw)));
    }

    public static boolean isSolidGrabbable(class_2680 state, class_1937 level, class_2338 pos) {
        if (state.method_26215()) {
            return false;
        }
        class_265 shape = state.method_26220((class_1922)level, pos);
        return !shape.method_1110();
    }

    private static class_243 getLateralOffset(class_1309 entity, BackpackArm arm) {
        float yaw = entity.method_36454();
        class_243 rightVec = new class_243(-Math.cos(Math.toRadians(yaw)), 0.0, -Math.sin(Math.toRadians(yaw)));
        double offsetAmount = 0.3;
        if (arm.isLeftSide()) {
            return rightVec.method_1021(-offsetAmount);
        }
        return rightVec.method_1021(offsetAmount);
    }

    private static class_243 calculateGrabPosition(class_1937 level, class_2338 pos, class_2680 state, class_3965 hit, BackpackArm arm) {
        class_265 shape = state.method_26220((class_1922)level, pos);
        if (shape.method_1110()) {
            return hit.method_17784();
        }
        class_238 bounds = shape.method_1107().method_996(pos);
        class_2350 face = hit.method_17780();
        class_243 hitPos = hit.method_17784();
        class_243 edgePos = GrabSurfaceDetector.snapToEdge(hitPos, bounds, face, arm.isLeftSide());
        class_243 faceNormal = class_243.method_24954((class_2382)face.method_10163());
        return edgePos.method_1020(faceNormal.method_1021(0.15));
    }

    private static class_243 snapToEdge(class_243 hitPos, class_238 bounds, class_2350 face, boolean preferLeft) {
        double edgeX = hitPos.field_1352;
        double edgeY = hitPos.field_1351;
        double edgeZ = hitPos.field_1350;
        double edgeInset = 0.05;
        switch (face.method_10166()) {
            case field_11048: {
                double midY = (bounds.field_1322 + bounds.field_1325) / 2.0;
                edgeY = hitPos.field_1351 < midY ? bounds.field_1322 + edgeInset : bounds.field_1325 - edgeInset;
                edgeZ = preferLeft ? bounds.field_1321 + edgeInset : bounds.field_1324 - edgeInset;
                break;
            }
            case field_11052: {
                edgeX = preferLeft ? bounds.field_1323 + edgeInset : bounds.field_1320 - edgeInset;
                double midZ = (bounds.field_1321 + bounds.field_1324) / 2.0;
                edgeZ = hitPos.field_1350 < midZ ? bounds.field_1321 + edgeInset : bounds.field_1324 - edgeInset;
                break;
            }
            case field_11051: {
                edgeX = preferLeft ? bounds.field_1323 + edgeInset : bounds.field_1320 - edgeInset;
                double midY = (bounds.field_1322 + bounds.field_1325) / 2.0;
                edgeY = hitPos.field_1351 < midY ? bounds.field_1322 + edgeInset : bounds.field_1325 - edgeInset;
            }
        }
        return new class_243(edgeX, edgeY, edgeZ);
    }

    private static GrabType determineGrabType(class_243 grabPos, class_2338 blockPos) {
        int edgeCount = 0;
        double threshold = 0.15;
        double relX = grabPos.field_1352 - (double)blockPos.method_10263();
        double relY = grabPos.field_1351 - (double)blockPos.method_10264();
        double relZ = grabPos.field_1350 - (double)blockPos.method_10260();
        if (relX < threshold || relX > 1.0 - threshold) {
            ++edgeCount;
        }
        if (relY < threshold || relY > 1.0 - threshold) {
            ++edgeCount;
        }
        if (relZ < threshold || relZ > 1.0 - threshold) {
            ++edgeCount;
        }
        return edgeCount >= 2 ? GrabType.CORNER : GrabType.SIDE;
    }
}

