/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.ftech_equipment.backpack.action;

import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;
import uk.co.cablepost.ftech_equipment.backpack.BackpackArmComponent;
import uk.co.cablepost.ftech_equipment.backpack.action.ArmAction;
import uk.co.cablepost.ftech_equipment.backpack.action.ArmActionContext;
import uk.co.cablepost.ftech_equipment.backpack.action.ArmMotion;

public abstract class SwingAction
implements ArmAction {
    public static final String KEY_PHASE = "phase";
    public static final String KEY_SWING_PROGRESS = "swingProgress";
    public static final int PHASE_EXTEND = 0;
    public static final int PHASE_SWING = 1;
    public static final int PHASE_RETRACT = 2;

    @Override
    public ArmMotion getMotion() {
        return ArmMotion.SWING_AT_TARGET;
    }

    @Override
    @Nullable
    public BackpackArmComponent tick(ArmActionContext ctx) {
        BackpackArmComponent arm = ctx.armData();
        class_2487 state = arm.actionState().method_10553();
        int phase = state.method_10550(KEY_PHASE);
        switch (phase) {
            case 0: {
                if (arm.progress() >= 0.99f) {
                    state.method_10569(KEY_PHASE, 1);
                    state.method_10548(KEY_SWING_PROGRESS, 0.0f);
                    return arm.withActionState(state);
                }
                return this.onExtending(ctx);
            }
            case 1: {
                float swing = state.method_10583(KEY_SWING_PROGRESS) + this.getSwingSpeed();
                if (swing >= 1.0f) {
                    this.onSwingComplete(ctx);
                    state.method_10569(KEY_PHASE, 2);
                    state.method_10548(KEY_SWING_PROGRESS, 1.0f);
                    return arm.withDirection(0).withActionState(state);
                }
                state.method_10548(KEY_SWING_PROGRESS, swing);
                return arm.withActionState(state);
            }
            case 2: {
                if (arm.progress() <= 0.01f) {
                    return this.onRetracted(ctx);
                }
                return this.onRetracting(ctx);
            }
        }
        return null;
    }

    @Override
    public float getSwingProgress(class_2487 actionState) {
        return actionState.method_10583(KEY_SWING_PROGRESS);
    }

    protected float getSwingSpeed() {
        return 0.15f;
    }

    @Nullable
    protected BackpackArmComponent onExtending(ArmActionContext ctx) {
        return null;
    }

    protected abstract void onSwingComplete(ArmActionContext var1);

    @Nullable
    protected BackpackArmComponent onRetracting(ArmActionContext ctx) {
        return null;
    }

    @Nullable
    protected abstract BackpackArmComponent onRetracted(ArmActionContext var1);
}

